/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.workflow.engine;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.falcon.FalconException;
import org.apache.falcon.LifeCycle;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;
import org.apache.falcon.workflow.engine.WorkflowEngineActionListener;

public abstract class AbstractWorkflowEngine {
    public static final String NAME_NODE = "nameNode";
    public static final String JOB_TRACKER = "jobTracker";
    protected Set<WorkflowEngineActionListener> listeners = new HashSet<WorkflowEngineActionListener>();

    public void registerListener(WorkflowEngineActionListener listener) {
        this.listeners.add(listener);
    }

    public abstract boolean isAlive(Cluster var1) throws FalconException;

    public abstract void schedule(Entity var1, Boolean var2, Map<String, String> var3) throws FalconException;

    public abstract String suspend(Entity var1) throws FalconException;

    public abstract String resume(Entity var1) throws FalconException;

    public abstract String delete(Entity var1) throws FalconException;

    public abstract String delete(Entity var1, String var2) throws FalconException;

    public abstract void reRun(String var1, String var2, Properties var3, boolean var4) throws FalconException;

    public abstract void dryRun(Entity var1, String var2, Boolean var3) throws FalconException;

    public abstract boolean isActive(Entity var1) throws FalconException;

    public abstract boolean isSuspended(Entity var1) throws FalconException;

    public abstract boolean isCompleted(Entity var1) throws FalconException;

    public abstract InstancesResult getRunningInstances(Entity var1, List<LifeCycle> var2) throws FalconException;

    public abstract InstancesResult killInstances(Entity var1, Date var2, Date var3, Properties var4, List<LifeCycle> var5) throws FalconException;

    public abstract InstancesResult reRunInstances(Entity var1, Date var2, Date var3, Properties var4, List<LifeCycle> var5, Boolean var6) throws FalconException;

    public abstract InstancesResult suspendInstances(Entity var1, Date var2, Date var3, Properties var4, List<LifeCycle> var5) throws FalconException;

    public abstract InstancesResult resumeInstances(Entity var1, Date var2, Date var3, Properties var4, List<LifeCycle> var5) throws FalconException;

    public abstract InstancesResult getStatus(Entity var1, Date var2, Date var3, List<LifeCycle> var4) throws FalconException;

    public abstract InstancesSummaryResult getSummary(Entity var1, Date var2, Date var3, List<LifeCycle> var4) throws FalconException;

    public abstract String update(Entity var1, Entity var2, String var3, Boolean var4) throws FalconException;

    public abstract String touch(Entity var1, String var2, Boolean var3) throws FalconException;

    public abstract String getWorkflowStatus(String var1, String var2) throws FalconException;

    public abstract Properties getWorkflowProperties(String var1, String var2) throws FalconException;

    public abstract InstancesResult getJobDetails(String var1, String var2) throws FalconException;

    public abstract InstancesResult getInstanceParams(Entity var1, Date var2, Date var3, List<LifeCycle> var4) throws FalconException;

    public abstract boolean isNotificationEnabled(String var1, String var2) throws FalconException;
}

