/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.falcon.FalconException;
import org.apache.falcon.lifecycle.FeedLifecycleStage;
import org.apache.falcon.lifecycle.LifecyclePolicy;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.ReflectionUtils;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecyclePolicyMap
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(LifecyclePolicyMap.class);
    private static final LifecyclePolicyMap STORE = new LifecyclePolicyMap();
    private final Map<String, LifecyclePolicy> policyMap = new HashMap<String, LifecyclePolicy>();

    private LifecyclePolicyMap() {
    }

    public static LifecyclePolicyMap get() {
        return STORE;
    }

    public LifecyclePolicy get(String policyName) {
        return this.policyMap.get(policyName);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void init() throws FalconException {
        String[] policyNames;
        for (String name : policyNames = StartupProperties.get().getProperty("falcon.feed.lifecycle.policies").split(",")) {
            LifecyclePolicy policy = (LifecyclePolicy)ReflectionUtils.getInstanceByClassName(name);
            LOG.debug("Loaded policy : {} for stage : {}", (Object)policy.getName(), (Object)policy.getStage());
            this.policyMap.put(policy.getName(), policy);
        }
        this.validate();
    }

    @Override
    public void destroy() throws FalconException {
        this.policyMap.clear();
    }

    private void validate() throws FalconException {
        for (FeedLifecycleStage stage : FeedLifecycleStage.values()) {
            if (this.policyMap.containsKey(stage.getDefaultPolicyName())) continue;
            throw new FalconException("Default Policy: " + stage.getDefaultPolicyName() + " for stage: " + stage.name() + "was not found.");
        }
    }
}

