/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GraphUtils.class);

    private GraphUtils() {
    }

    public static void dumpToLog(Graph graph) {
        LOG.debug("Vertices of {}", (Object)graph);
        for (Vertex vertex : graph.getVertices()) {
            LOG.debug(GraphUtils.vertexString(vertex));
        }
        LOG.debug("Edges of {}", (Object)graph);
        for (Edge edge : graph.getEdges()) {
            LOG.debug(GraphUtils.edgeString(edge));
        }
    }

    public static void dump(Graph graph) throws IOException {
        GraphUtils.dump(graph, System.out);
    }

    public static void dump(Graph graph, OutputStream outputStream) throws IOException {
        GraphSONWriter.outputGraph((Graph)graph, (OutputStream)outputStream);
    }

    public static void dump(Graph graph, String fileName) throws IOException {
        GraphSONWriter.outputGraph((Graph)graph, (String)fileName);
    }

    public static String vertexString(Vertex vertex) {
        StringBuilder properties = new StringBuilder();
        for (String propertyKey : vertex.getPropertyKeys()) {
            properties.append(propertyKey).append("=").append(vertex.getProperty(propertyKey)).append(", ");
        }
        return "v[" + vertex.getId() + "], Properties[" + properties + "]";
    }

    public static String edgeString(Edge edge) {
        return "e[" + edge.getLabel() + "], [" + edge.getVertex(Direction.OUT).getProperty("name") + " -> " + edge.getLabel() + " -> " + edge.getVertex(Direction.IN).getProperty("name") + "]";
    }
}

