/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.common.FeedDataPath;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.LocationType;

public class FeedGroup {
    private String name;
    private Frequency frequency;
    private String datePattern;
    private Set<String> feeds;

    public FeedGroup(String group, Frequency frequency, String path) {
        this.name = group;
        this.frequency = frequency;
        this.datePattern = FeedGroup.getDatePattern(path);
        this.feeds = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static String getDatePattern(String path) {
        Matcher matcher = FeedDataPath.PATTERN.matcher(path);
        ArrayList<String> fields = new ArrayList<String>();
        while (matcher.find()) {
            String var = path.substring(matcher.start(), matcher.end());
            fields.add(var);
        }
        Collections.sort(fields);
        return ((Object)fields).toString();
    }

    public Set<String> getFeeds() {
        return this.feeds;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FeedGroup)) {
            return false;
        }
        FeedGroup group = (FeedGroup)obj;
        return this.name.equals(group.getName()) && this.frequency.equals((Object)group.frequency) && this.datePattern.equals(group.datePattern);
    }

    public int hashCode() {
        return 127 * this.name.hashCode() + 31 * this.frequency.hashCode() + this.datePattern.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public boolean canContainFeed(Feed feed) throws FalconException {
        return this.frequency.equals((Object)feed.getFrequency()) && this.datePattern.equals(FeedGroup.getDatePattern(FeedHelper.createStorage(feed).getUriTemplate(LocationType.DATA)));
    }
}

