/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.process.Cluster;
import org.apache.falcon.entity.v0.process.Input;
import org.apache.falcon.entity.v0.process.Output;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.service.ConfigurationChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityGraph
implements ConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGraph.class);
    private static EntityGraph instance = new EntityGraph();
    private Map<Node, Set<Node>> graph = new ConcurrentHashMap<Node, Set<Node>>();

    private EntityGraph() {
    }

    public static EntityGraph get() {
        return instance;
    }

    public Set<Entity> getDependents(Entity entity) throws FalconException {
        Node entityNode = new Node(entity.getEntityType(), entity.getName());
        if (this.graph.containsKey(entityNode)) {
            ConfigurationStore store = ConfigurationStore.get();
            HashSet<Entity> dependents = new HashSet<Entity>();
            for (Node node : this.graph.get(entityNode)) {
                Object dependentEntity = store.get(node.type, node.name);
                if (dependentEntity != null) {
                    dependents.add((Entity)dependentEntity);
                    continue;
                }
                LOG.error("Dependent entity {} was not found in configuration store.", (Object)node);
            }
            return dependents;
        }
        return null;
    }

    @Override
    public void onAdd(Entity entity) throws FalconException {
        Map<Node, Set<Node>> nodeEdges = null;
        switch (entity.getEntityType()) {
            case PROCESS: {
                nodeEdges = this.getEdgesFor((Process)entity);
                break;
            }
            case FEED: {
                nodeEdges = this.getEdgesFor((Feed)entity);
                break;
            }
        }
        if (nodeEdges == null) {
            return;
        }
        LOG.debug("Adding edges for {}: {}", (Object)entity.getName(), nodeEdges);
        for (Map.Entry<Node, Set<Node>> entry : nodeEdges.entrySet()) {
            LOG.debug("Adding edges : {} for {}", entry.getValue(), (Object)entry.getKey());
            if (this.graph.containsKey(entry.getKey())) {
                this.graph.get(entry.getKey()).addAll((Collection<Node>)entry.getValue());
                continue;
            }
            this.graph.put(entry.getKey(), entry.getValue());
        }
        LOG.debug("Merged edges to graph {}", (Object)entity.getName());
    }

    @Override
    public void onRemove(Entity entity) throws FalconException {
        Map<Node, Set<Node>> nodeEdges = null;
        switch (entity.getEntityType()) {
            case PROCESS: {
                nodeEdges = this.getEdgesFor((Process)entity);
                break;
            }
            case FEED: {
                nodeEdges = this.getEdgesFor((Feed)entity);
                break;
            }
        }
        if (nodeEdges == null) {
            return;
        }
        for (Map.Entry entry : nodeEdges.entrySet()) {
            if (!this.graph.containsKey(entry.getKey())) continue;
            this.graph.get(entry.getKey()).removeAll((Collection)entry.getValue());
            if (!this.graph.get(entry.getKey()).isEmpty()) continue;
            this.graph.remove(entry.getKey());
        }
    }

    @Override
    public void onChange(Entity oldEntity, Entity newEntity) throws FalconException {
        this.onRemove(oldEntity);
        this.onAdd(newEntity);
    }

    @Override
    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }

    private Map<Node, Set<Node>> getEdgesFor(Process process) {
        Set feedEdges;
        Node feedNode;
        HashMap<Node, Set<Node>> nodeEdges = new HashMap<Node, Set<Node>>();
        Node processNode = new Node(EntityType.PROCESS, process.getName());
        nodeEdges.put(processNode, new HashSet());
        Set processEdges = (Set)nodeEdges.get(processNode);
        if (process.getInputs() != null) {
            for (Input input : process.getInputs().getInputs()) {
                feedNode = new Node(EntityType.FEED, input.getFeed());
                if (!nodeEdges.containsKey(feedNode)) {
                    nodeEdges.put(feedNode, new HashSet());
                }
                feedEdges = (Set)nodeEdges.get(feedNode);
                processEdges.add(feedNode);
                feedEdges.add(processNode);
            }
        }
        if (process.getOutputs() != null) {
            for (Output output : process.getOutputs().getOutputs()) {
                feedNode = new Node(EntityType.FEED, output.getFeed());
                if (!nodeEdges.containsKey(feedNode)) {
                    nodeEdges.put(feedNode, new HashSet());
                }
                feedEdges = (Set)nodeEdges.get(feedNode);
                processEdges.add(feedNode);
                feedEdges.add(processNode);
            }
        }
        for (Cluster cluster : process.getClusters().getClusters()) {
            Node clusterNode = new Node(EntityType.CLUSTER, cluster.getName());
            processEdges.add(clusterNode);
            nodeEdges.put(clusterNode, new HashSet());
            ((Set)nodeEdges.get(clusterNode)).add(processNode);
        }
        return nodeEdges;
    }

    private Map<Node, Set<Node>> getEdgesFor(Feed feed) {
        HashMap<Node, Set<Node>> nodeEdges = new HashMap<Node, Set<Node>>();
        Node feedNode = new Node(EntityType.FEED, feed.getName());
        HashSet<Node> feedEdges = new HashSet<Node>();
        nodeEdges.put(feedNode, feedEdges);
        for (org.apache.falcon.entity.v0.feed.Cluster cluster : feed.getClusters().getClusters()) {
            Node clusterNode = new Node(EntityType.CLUSTER, cluster.getName());
            if (!nodeEdges.containsKey(clusterNode)) {
                nodeEdges.put(clusterNode, new HashSet());
            }
            Set clusterEdges = (Set)nodeEdges.get(clusterNode);
            feedEdges.add(clusterNode);
            clusterEdges.add(feedNode);
        }
        return nodeEdges;
    }

    private static final class Node {
        private final EntityType type;
        private final String name;

        private Node(EntityType type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            boolean nameEqual;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            boolean bl = this.name != null ? !this.name.equals(node.name) : (nameEqual = node.name != null);
            if (nameEqual) {
                return false;
            }
            return this.type == node.type;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(" + this.type + ") " + this.name;
        }
    }
}

