/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.lock;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.falcon.entity.v0.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryLocks {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryLocks.class);
    private static ConcurrentHashMap<String, Boolean> locks = new ConcurrentHashMap();
    private static MemoryLocks instance = new MemoryLocks();

    private MemoryLocks() {
    }

    public static MemoryLocks getInstance() {
        return instance;
    }

    public boolean acquireLock(Entity entity, String command) {
        boolean lockObtained = false;
        String entityName = this.getLockKey(entity);
        Boolean putResponse = locks.putIfAbsent(entityName, true);
        if (putResponse == null || !putResponse.booleanValue()) {
            LOG.info("Lock acquired for {} on {} by {}", new Object[]{command, entity.toShortString(), Thread.currentThread().getName()});
            lockObtained = true;
        }
        return lockObtained;
    }

    public void releaseLock(Entity entity) {
        String entityName = this.getLockKey(entity);
        locks.remove(entityName);
        LOG.info("Successfully released lock on {} by {}", (Object)entity.toShortString(), (Object)Thread.currentThread().getName());
    }

    private String getLockKey(Entity entity) {
        return entity.getEntityType().toString() + "." + entity.getName();
    }
}

