/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.EntityUtil;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.Storage;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.process.Input;
import org.apache.falcon.entity.v0.process.Output;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.resource.SchedulableEntityInstance;

public final class ProcessHelper {
    private ProcessHelper() {
    }

    public static org.apache.falcon.entity.v0.process.Cluster getCluster(Process process, String clusterName) {
        for (org.apache.falcon.entity.v0.process.Cluster cluster : process.getClusters().getClusters()) {
            if (!cluster.getName().equals(clusterName)) continue;
            return cluster;
        }
        return null;
    }

    public static String getProcessWorkflowName(String workflowName, String processName) {
        return StringUtils.isEmpty((CharSequence)workflowName) ? processName + "-workflow" : workflowName;
    }

    public static Storage.TYPE getStorageType(Cluster cluster, Process process) throws FalconException {
        Storage.TYPE storageType;
        block4: {
            Output output;
            Feed feed;
            Iterator i$;
            storageType = Storage.TYPE.FILESYSTEM;
            if (process.getInputs() == null && process.getOutputs() == null) {
                return storageType;
            }
            if (process.getInputs() != null) {
                Input input;
                i$ = process.getInputs().getInputs().iterator();
                while (i$.hasNext() && Storage.TYPE.TABLE != (storageType = FeedHelper.getStorageType(feed = (Feed)EntityUtil.getEntity(EntityType.FEED, (input = (Input)i$.next()).getFeed()), cluster))) {
                }
            }
            if (process.getOutputs() == null || Storage.TYPE.FILESYSTEM != storageType) break block4;
            i$ = process.getOutputs().getOutputs().iterator();
            while (i$.hasNext() && Storage.TYPE.TABLE != (storageType = FeedHelper.getStorageType(feed = (Feed)EntityUtil.getEntity(EntityType.FEED, (output = (Output)i$.next()).getFeed()), cluster))) {
            }
        }
        return storageType;
    }

    private static void validateProcessInstance(Process process, Date instanceTime, Cluster cluster) {
        org.apache.falcon.entity.v0.process.Cluster processCluster = ProcessHelper.getCluster(process, cluster.getName());
        if (processCluster == null) {
            throw new IllegalArgumentException("Cluster provided: " + cluster.getName() + " is not a valid cluster for the process: " + process.getName());
        }
        if (instanceTime.before(processCluster.getValidity().getStart()) || !instanceTime.before(processCluster.getValidity().getEnd())) {
            throw new IllegalArgumentException("Instance time provided: " + instanceTime + " is not in validity range of process: " + process.getName() + "on cluster: " + cluster.getName());
        }
        Date nextInstance = EntityUtil.getNextStartTime(processCluster.getValidity().getStart(), process.getFrequency(), process.getTimezone(), instanceTime);
        if (!nextInstance.equals(instanceTime)) {
            throw new IllegalArgumentException("Instance time provided: " + instanceTime + " for process: " + process.getName() + " is not a valid instance time on cluster: " + cluster.getName() + " on the basis of startDate and frequency");
        }
    }

    public static Set<SchedulableEntityInstance> getInputFeedInstances(Process process, Date instanceTime, Cluster cluster, boolean allowOptionalFeeds) throws FalconException {
        ProcessHelper.validateProcessInstance(process, instanceTime, cluster);
        HashSet<SchedulableEntityInstance> result = new HashSet<SchedulableEntityInstance>();
        if (process.getInputs() != null) {
            ConfigurationStore store = ConfigurationStore.get();
            for (Input i : process.getInputs().getInputs()) {
                if (i.isOptional() && !allowOptionalFeeds) continue;
                Feed feed = (Feed)store.get(EntityType.FEED, i.getFeed());
                ExpressionHelper evaluator = ExpressionHelper.get();
                ExpressionHelper.setReferenceDate(instanceTime);
                Date inputInstanceStartDate = evaluator.evaluate(i.getStart(), Date.class);
                Date inputInstanceEndDate = evaluator.evaluate(i.getEnd(), Date.class);
                List<Date> instanceTimes = EntityUtil.getEntityInstanceTimes((Entity)feed, cluster.getName(), inputInstanceStartDate, inputInstanceEndDate);
                for (Date time : instanceTimes) {
                    SchedulableEntityInstance instance = new SchedulableEntityInstance(feed.getName(), cluster.getName(), time, EntityType.FEED);
                    instance.setTags("Input");
                    result.add(instance);
                }
            }
        }
        return result;
    }

    public static Set<SchedulableEntityInstance> getOutputFeedInstances(Process process, Date instanceTime, Cluster cluster) throws FalconException {
        HashSet<SchedulableEntityInstance> result = new HashSet<SchedulableEntityInstance>();
        ProcessHelper.validateProcessInstance(process, instanceTime, cluster);
        if (process.getOutputs() != null && process.getOutputs().getOutputs() != null) {
            ExpressionHelper.setReferenceDate(instanceTime);
            ExpressionHelper evaluator = ExpressionHelper.get();
            ConfigurationStore store = ConfigurationStore.get();
            for (Output output : process.getOutputs().getOutputs()) {
                Date outputInstance = evaluator.evaluate(output.getInstance(), Date.class);
                Feed feed = (Feed)store.get(EntityType.FEED, output.getFeed());
                org.apache.falcon.entity.v0.feed.Cluster fCluster = FeedHelper.getCluster(feed, cluster.getName());
                outputInstance = EntityUtil.getPreviousInstanceTime(fCluster.getValidity().getStart(), feed.getFrequency(), feed.getTimezone(), outputInstance);
                SchedulableEntityInstance candidate = new SchedulableEntityInstance(output.getFeed(), cluster.getName(), outputInstance, EntityType.FEED);
                candidate.setTags("Output");
                result.add(candidate);
            }
        }
        return result;
    }
}

