/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.cluster.ClusterLocationType;
import org.apache.falcon.entity.v0.cluster.Interface;
import org.apache.falcon.entity.v0.cluster.Interfacetype;
import org.apache.falcon.entity.v0.cluster.Location;
import org.apache.falcon.entity.v0.cluster.Property;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class ClusterHelper {
    public static final String DEFAULT_BROKER_IMPL_CLASS = "org.apache.activemq.ActiveMQConnectionFactory";
    public static final String WORKINGDIR = "working";
    public static final String NO_USER_BROKER_URL = "NA";

    private ClusterHelper() {
    }

    public static Cluster getCluster(String cluster) throws FalconException {
        return (Cluster)ConfigurationStore.get().get(EntityType.CLUSTER, cluster);
    }

    public static Configuration getConfiguration(Cluster cluster) {
        Configuration conf = new Configuration();
        String storageUrl = ClusterHelper.getStorageUrl(cluster);
        conf.set("fs.defaultFS", storageUrl);
        String executeEndPoint = ClusterHelper.getMREndPoint(cluster);
        conf.set("mapreduce.jobtracker.address", executeEndPoint);
        conf.set("yarn.resourcemanager.address", executeEndPoint);
        if (cluster.getProperties() != null) {
            for (Property prop : cluster.getProperties().getProperties()) {
                conf.set(prop.getName(), prop.getValue());
            }
        }
        return conf;
    }

    public static String getOozieUrl(Cluster cluster) {
        return ClusterHelper.getInterface(cluster, Interfacetype.WORKFLOW).getEndpoint();
    }

    public static String getStorageUrl(Cluster cluster) {
        return ClusterHelper.getNormalizedUrl(cluster, Interfacetype.WRITE);
    }

    public static String getReadOnlyStorageUrl(Cluster cluster) {
        return ClusterHelper.getNormalizedUrl(cluster, Interfacetype.READONLY);
    }

    public static String getMREndPoint(Cluster cluster) {
        return ClusterHelper.getInterface(cluster, Interfacetype.EXECUTE).getEndpoint();
    }

    public static String getRegistryEndPoint(Cluster cluster) {
        Interface catalogInterface = ClusterHelper.getInterface(cluster, Interfacetype.REGISTRY);
        return catalogInterface == null ? null : catalogInterface.getEndpoint();
    }

    public static String getMessageBrokerUrl(Cluster cluster) {
        Interface messageInterface = ClusterHelper.getInterface(cluster, Interfacetype.MESSAGING);
        return messageInterface == null ? NO_USER_BROKER_URL : messageInterface.getEndpoint();
    }

    public static String getMessageBrokerImplClass(Cluster cluster) {
        if (cluster.getProperties() != null) {
            for (Property prop : cluster.getProperties().getProperties()) {
                if (!prop.getName().equals("brokerImplClass")) continue;
                return prop.getValue();
            }
        }
        return DEFAULT_BROKER_IMPL_CLASS;
    }

    public static Interface getInterface(Cluster cluster, Interfacetype type) {
        for (Interface interf : cluster.getInterfaces().getInterfaces()) {
            if (interf.getType() != type) continue;
            return interf;
        }
        return null;
    }

    private static String getNormalizedUrl(Cluster cluster, Interfacetype type) {
        String normalizedUrl = ClusterHelper.getInterface(cluster, type).getEndpoint();
        if (normalizedUrl.endsWith("///")) {
            return normalizedUrl;
        }
        String normalizedPath = new Path(normalizedUrl + "/").toString();
        return normalizedPath.substring(0, normalizedPath.length() - 1);
    }

    public static Location getLocation(Cluster cluster, ClusterLocationType clusterLocationType) {
        Location staging;
        for (Location loc : cluster.getLocations().getLocations()) {
            if (!loc.getName().equals((Object)clusterLocationType)) continue;
            return loc;
        }
        if (clusterLocationType.equals((Object)ClusterLocationType.WORKING) && (staging = ClusterHelper.getLocation(cluster, ClusterLocationType.STAGING)) != null) {
            Location working = new Location();
            working.setName(ClusterLocationType.WORKING);
            working.setPath(staging.getPath().charAt(staging.getPath().length() - 1) == '/' ? staging.getPath().concat(WORKINGDIR) : staging.getPath().concat("/").concat(WORKINGDIR));
            return working;
        }
        return null;
    }

    public static boolean checkWorkingLocationExists(Cluster cluster) {
        for (Location loc : cluster.getLocations().getLocations()) {
            if (!loc.getName().equals((Object)ClusterLocationType.WORKING)) continue;
            return true;
        }
        return false;
    }

    public static String getPropertyValue(Cluster cluster, String propName) {
        if (cluster.getProperties() != null) {
            for (Property prop : cluster.getProperties().getProperties()) {
                if (!prop.getName().equals(propName)) continue;
                return prop.getValue();
            }
        }
        return null;
    }

    public static Map<String, String> getHiveProperties(Cluster cluster) {
        List properties;
        if (cluster.getProperties() != null && (properties = cluster.getProperties().getProperties()) != null && !properties.isEmpty()) {
            HashMap<String, String> hiveProperties = new HashMap<String, String>();
            for (Property prop : properties) {
                if (!prop.getName().startsWith("hive.")) continue;
                hiveProperties.put(prop.getName(), prop.getValue());
            }
            return hiveProperties;
        }
        return null;
    }
}

