/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.catalog;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.falcon.FalconException;
import org.apache.falcon.catalog.AbstractCatalogService;
import org.apache.falcon.catalog.CatalogPartition;
import org.apache.falcon.security.CurrentUser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogService
extends AbstractCatalogService {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalogService.class);
    public static final String CREATE_TIME = "falcon.create_time";
    public static final String UPDATE_TIME = "falcon.update_time";

    public static HiveConf createHiveConf(Configuration conf, String metastoreUrl) throws IOException {
        HiveConf hcatConf = new HiveConf(conf, HiveConf.class);
        hcatConf.set("hive.metastore.local", "false");
        hcatConf.setVar(HiveConf.ConfVars.METASTOREURIS, metastoreUrl);
        hcatConf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, 3);
        hcatConf.set(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, HCatSemanticAnalyzer.class.getName());
        hcatConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
        hcatConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        hcatConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        return hcatConf;
    }

    private static HiveMetaStoreClient createClient(Configuration conf, String metastoreUrl) throws FalconException {
        try {
            LOG.info("Creating HCatalog client object for metastore {} using conf {}", (Object)metastoreUrl, (Object)conf.toString());
            Credentials credentials = HiveCatalogService.getCredentials(conf);
            Configuration jobConf = credentials != null ? HiveCatalogService.copyCredentialsToConf(conf, credentials) : conf;
            HiveConf hcatConf = HiveCatalogService.createHiveConf(jobConf, metastoreUrl);
            if (UserGroupInformation.isSecurityEnabled()) {
                hcatConf.set(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname, conf.get(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname));
                hcatConf.set(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname, "true");
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                ugi.addCredentials(credentials);
            }
            return new HiveMetaStoreClient(hcatConf);
        }
        catch (Exception e) {
            throw new FalconException("Exception creating HiveMetaStoreClient: " + e.getMessage(), e);
        }
    }

    private static JobConf copyCredentialsToConf(Configuration conf, Credentials credentials) {
        JobConf jobConf = new JobConf(conf);
        jobConf.setCredentials(credentials);
        return jobConf;
    }

    private static Credentials getCredentials(Configuration conf) throws IOException {
        String tokenFile = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (tokenFile == null) {
            return null;
        }
        try {
            LOG.info("Adding credentials/delegation tokens from token file={} to conf", (Object)tokenFile);
            Credentials credentials = Credentials.readTokenStorageFile((File)new File(tokenFile), (Configuration)conf);
            LOG.info("credentials numberOfTokens={}, numberOfSecretKeys={}", (Object)credentials.numberOfTokens(), (Object)credentials.numberOfSecretKeys());
            return credentials;
        }
        catch (IOException e) {
            LOG.warn("error while fetching credentials from {}", (Object)tokenFile);
            return null;
        }
    }

    private static HiveMetaStoreClient createProxiedClient(Configuration conf, String catalogUrl) throws FalconException {
        try {
            final HiveConf hcatConf = HiveCatalogService.createHiveConf(conf, catalogUrl);
            UserGroupInformation proxyUGI = CurrentUser.getProxyUGI();
            HiveCatalogService.addSecureCredentialsAndToken(conf, hcatConf, proxyUGI);
            LOG.info("Creating HCatalog client object for {}", (Object)catalogUrl);
            return (HiveMetaStoreClient)proxyUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HiveMetaStoreClient>(){

                @Override
                public HiveMetaStoreClient run() throws Exception {
                    return new HiveMetaStoreClient(hcatConf);
                }
            });
        }
        catch (Exception e) {
            throw new FalconException("Exception creating Proxied HiveMetaStoreClient: " + e.getMessage(), e);
        }
    }

    private static void addSecureCredentialsAndToken(Configuration conf, HiveConf hcatConf, UserGroupInformation proxyUGI) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            String metaStoreServicePrincipal = conf.get("hive.metastore.kerberos.principal");
            hcatConf.set(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname, metaStoreServicePrincipal);
            hcatConf.set(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname, "true");
            Token<DelegationTokenIdentifier> delegationTokenId = HiveCatalogService.getDelegationToken(hcatConf, metaStoreServicePrincipal);
            proxyUGI.addToken(delegationTokenId);
        }
    }

    private static Token<DelegationTokenIdentifier> getDelegationToken(HiveConf hcatConf, String metaStoreServicePrincipal) throws IOException {
        LOG.debug("Creating delegation tokens for principal={}", (Object)metaStoreServicePrincipal);
        HCatClient hcatClient = HCatClient.create((Configuration)hcatConf);
        String delegationToken = hcatClient.getDelegationToken(CurrentUser.getUser(), metaStoreServicePrincipal);
        hcatConf.set("hive.metastore.token.signature", "FalconService");
        Token delegationTokenId = new Token();
        delegationTokenId.decodeFromUrlString(delegationToken);
        delegationTokenId.setService(new Text("FalconService"));
        LOG.info("Created delegation token={}", (Object)delegationToken);
        return delegationTokenId;
    }

    @Override
    public boolean isAlive(Configuration conf, String catalogUrl) throws FalconException {
        LOG.info("Checking if the service is alive for: {}", (Object)catalogUrl);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createProxiedClient(conf, catalogUrl);
            Database database = client.getDatabase("default");
            return database != null;
        }
        catch (Exception e) {
            throw new FalconException("Exception checking if the service is alive:" + e.getMessage(), e);
        }
    }

    @Override
    public boolean tableExists(Configuration conf, String catalogUrl, String database, String tableName) throws FalconException {
        LOG.info("Checking if the table exists: {}", (Object)tableName);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createProxiedClient(conf, catalogUrl);
            Table table = client.getTable(database, tableName);
            return table != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (Exception e) {
            throw new FalconException("Exception checking if the table exists:" + e.getMessage(), e);
        }
    }

    @Override
    public boolean isTableExternal(Configuration conf, String catalogUrl, String database, String tableName) throws FalconException {
        LOG.info("Checking if the table is external: {}", (Object)tableName);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            Table table = client.getTable(database, tableName);
            return table.getTableType().equals(TableType.EXTERNAL_TABLE.name());
        }
        catch (Exception e) {
            throw new FalconException("Exception checking if the table is external:" + e.getMessage(), e);
        }
    }

    @Override
    public List<CatalogPartition> listPartitions(Configuration conf, String catalogUrl, String database, String tableName, List<String> values) throws FalconException {
        LOG.info("List partitions for: {}, partition filter: {}", (Object)tableName, values);
        try {
            ArrayList<CatalogPartition> catalogPartitionList = new ArrayList<CatalogPartition>();
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            List hCatPartitions = client.listPartitions(database, tableName, values, (short)-1);
            for (Partition hCatPartition : hCatPartitions) {
                LOG.debug("Partition: " + hCatPartition.getValues());
                CatalogPartition partition = this.createCatalogPartition(hCatPartition);
                catalogPartitionList.add(partition);
            }
            return catalogPartitionList;
        }
        catch (Exception e) {
            throw new FalconException("Exception listing partitions:" + e.getMessage(), e);
        }
    }

    @Override
    public List<CatalogPartition> listPartitionsByFilter(Configuration conf, String catalogUrl, String database, String tableName, String filter) throws FalconException {
        LOG.info("List partitions for: {}, partition filter: {}", (Object)tableName, (Object)filter);
        try {
            ArrayList<CatalogPartition> catalogPartitionList = new ArrayList<CatalogPartition>();
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            List hCatPartitions = client.listPartitionsByFilter(database, tableName, filter, (short)-1);
            for (Partition hCatPartition : hCatPartitions) {
                LOG.info("Partition: " + hCatPartition.getValues());
                CatalogPartition partition = this.createCatalogPartition(hCatPartition);
                catalogPartitionList.add(partition);
            }
            return catalogPartitionList;
        }
        catch (Exception e) {
            throw new FalconException("Exception listing partitions:" + e.getMessage(), e);
        }
    }

    private CatalogPartition createCatalogPartition(Partition hCatPartition) {
        CatalogPartition catalogPartition = new CatalogPartition();
        catalogPartition.setDatabaseName(hCatPartition.getDbName());
        catalogPartition.setTableName(hCatPartition.getTableName());
        catalogPartition.setValues(hCatPartition.getValues());
        catalogPartition.setInputFormat(hCatPartition.getSd().getInputFormat());
        catalogPartition.setOutputFormat(hCatPartition.getSd().getOutputFormat());
        catalogPartition.setLocation(hCatPartition.getSd().getLocation());
        catalogPartition.setSerdeInfo(hCatPartition.getSd().getSerdeInfo().getSerializationLib());
        catalogPartition.setCreateTime(hCatPartition.getCreateTime());
        catalogPartition.setLastAccessTime(hCatPartition.getLastAccessTime());
        return catalogPartition;
    }

    @Override
    public boolean dropPartition(Configuration conf, String catalogUrl, String database, String tableName, List<String> partitionValues, boolean deleteData) throws FalconException {
        LOG.info("Dropping partition for: {}, partition: {}", (Object)tableName, partitionValues);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            return client.dropPartition(database, tableName, partitionValues, deleteData);
        }
        catch (Exception e) {
            throw new FalconException("Exception dropping partitions:" + e.getMessage(), e);
        }
    }

    @Override
    public void dropPartitions(Configuration conf, String catalogUrl, String database, String tableName, List<String> partitionValues, boolean deleteData) throws FalconException {
        LOG.info("Dropping partitions for: {}, partitions: {}", (Object)tableName, partitionValues);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            List partitions = client.listPartitions(database, tableName, partitionValues, (short)-1);
            for (Partition part : partitions) {
                LOG.info("Dropping partition for: {}, partition: {}", (Object)tableName, (Object)part.getValues());
                client.dropPartition(database, tableName, part.getValues(), deleteData);
            }
        }
        catch (Exception e) {
            throw new FalconException("Exception dropping partitions:" + e.getMessage(), e);
        }
    }

    @Override
    public CatalogPartition getPartition(Configuration conf, String catalogUrl, String database, String tableName, List<String> partitionValues) throws FalconException {
        LOG.info("Fetch partition for: {}, partition spec: {}", (Object)tableName, partitionValues);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            Partition hCatPartition = client.getPartition(database, tableName, partitionValues);
            return this.createCatalogPartition(hCatPartition);
        }
        catch (Exception e) {
            throw new FalconException("Exception fetching partition:" + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getPartitionColumns(Configuration conf, String catalogUrl, String database, String tableName) throws FalconException {
        LOG.info("Fetching partition columns of table: " + tableName);
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            Table table = client.getTable(database, tableName);
            ArrayList<String> partCols = new ArrayList<String>();
            for (FieldSchema part : table.getPartitionKeys()) {
                partCols.add(part.getName());
            }
            return partCols;
        }
        catch (Exception e) {
            throw new FalconException("Exception fetching partition columns: " + e.getMessage(), e);
        }
    }

    @Override
    public void addPartition(Configuration conf, String catalogUrl, String database, String tableName, List<String> partValues, String location) throws FalconException {
        LOG.info("Adding partition {} for {}.{} with location {}", new Object[]{partValues, database, tableName, location});
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            Table table = client.getTable(database, tableName);
            Partition part = new Partition();
            part.setDbName(database);
            part.setTableName(tableName);
            part.setValues(partValues);
            part.setSd(table.getSd());
            part.getSd().setLocation(location);
            part.setParameters(table.getParameters());
            if (part.getParameters() == null) {
                part.setParameters(new HashMap());
            }
            part.getParameters().put(CREATE_TIME, String.valueOf(System.currentTimeMillis()));
            client.add_partition(part);
        }
        catch (Exception e) {
            throw new FalconException("Exception adding partition: " + e.getMessage(), e);
        }
    }

    @Override
    public void updatePartition(Configuration conf, String catalogUrl, String database, String tableName, List<String> partValues, String location) throws FalconException {
        LOG.info("Updating partition {} of {}.{} with location {}", new Object[]{partValues, database, tableName, location});
        try {
            HiveMetaStoreClient client = HiveCatalogService.createClient(conf, catalogUrl);
            Table table = client.getTable(database, tableName);
            Partition part = new Partition();
            part.setDbName(database);
            part.setTableName(tableName);
            part.setValues(partValues);
            part.setSd(table.getSd());
            part.getSd().setLocation(location);
            part.setParameters(table.getParameters());
            if (part.getParameters() == null) {
                part.setParameters(new HashMap());
            }
            part.getParameters().put(UPDATE_TIME, String.valueOf(System.currentTimeMillis()));
            client.alter_partition(database, tableName, part);
        }
        catch (Exception e) {
            throw new FalconException("Exception updating partition: " + e.getMessage(), e);
        }
    }
}

