/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.SchemaHelper;

public class SchedulableEntityInstance
implements Comparable<SchedulableEntityInstance> {
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    private String entityName;
    private String cluster;
    private Date instanceTime;
    private EntityType entityType;
    private String tags;

    private SchedulableEntityInstance() {
    }

    public SchedulableEntityInstance(String entityName, String cluster, Date instanceTime, EntityType type) {
        this.entityName = entityName;
        this.cluster = cluster;
        this.entityType = type;
        if (instanceTime != null) {
            this.instanceTime = new Date(instanceTime.getTime());
        }
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public Date getInstanceTime() {
        return new Date(this.instanceTime.getTime());
    }

    public void setInstanceTime(Date instanceTime) {
        this.instanceTime = new Date(instanceTime.getTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name: " + this.entityName + ", type: " + (Object)((Object)this.entityType) + ", cluster: " + this.cluster + ", instanceTime: " + SchemaHelper.formatDateUTC(this.instanceTime));
        sb.append(", tags: " + (this.tags != null ? this.tags : ""));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulableEntityInstance that = (SchedulableEntityInstance)o;
        if (this.instanceTime == null ? that.instanceTime != null : !this.instanceTime.equals(that.instanceTime)) {
            return false;
        }
        if (!this.entityType.equals((Object)that.entityType)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.entityName, (CharSequence)that.entityName)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.cluster, (CharSequence)that.cluster)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.tags, (CharSequence)that.tags);
    }

    public int hashCode() {
        int result = this.instanceTime.hashCode();
        result = 31 * result + this.entityName.hashCode();
        result = 31 * result + this.entityType.hashCode();
        result = 31 * result + this.cluster.hashCode();
        if (this.tags != null) {
            result = 31 * result + this.tags.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(SchedulableEntityInstance o) {
        int result = this.cluster.compareTo(o.cluster);
        if (result != 0) {
            return result;
        }
        result = this.entityType.compareTo(o.entityType);
        if (result != 0) {
            return result;
        }
        result = this.entityName.compareToIgnoreCase(o.entityName);
        if (result != 0) {
            return result;
        }
        return this.instanceTime.compareTo(o.instanceTime);
    }
}

