/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.falcon.resource.APIResult;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class InstancesResult
extends APIResult {
    @XmlElement
    private Instance[] instances;

    private InstancesResult() {
    }

    public InstancesResult(APIResult.Status status, String message) {
        super(status, message);
    }

    public Instance[] getInstances() {
        return this.instances;
    }

    public void setInstances(Instance[] instances) {
        this.instances = instances;
    }

    @Override
    public Object[] getCollection() {
        return this.getInstances();
    }

    @Override
    public void setCollection(Object[] items) {
        if (items == null) {
            this.setInstances(new Instance[0]);
        } else {
            Instance[] newInstances = new Instance[items.length];
            for (int index = 0; index < items.length; ++index) {
                newInstances[index] = (Instance)items[index];
            }
            this.setInstances(newInstances);
        }
    }

    @XmlRootElement(name="params")
    public static class KeyValuePair {
        @XmlElement
        public String key;
        @XmlElement
        public String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public KeyValuePair() {
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "{key:" + this.key + ", value:" + this.value + "}";
        }
    }

    @XmlRootElement(name="actions")
    public static class InstanceAction {
        @XmlElement
        public String action;
        @XmlElement
        public String status;
        @XmlElement
        public String logFile;

        public InstanceAction() {
        }

        public InstanceAction(String action, String status, String logFile) {
            this.action = action;
            this.status = status;
            this.logFile = logFile;
        }

        public String getAction() {
            return this.action;
        }

        public String getStatus() {
            return this.status;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public String toString() {
            return "{action:" + this.action + ", status:" + this.status + (this.logFile == null ? "" : ", log:" + this.logFile) + "}";
        }
    }

    @XmlRootElement(name="instance")
    public static class Instance {
        @XmlElement
        public String instance;
        @XmlElement
        public WorkflowStatus status;
        @XmlElement
        public String logFile;
        @XmlElement
        public String cluster;
        @XmlElement
        public String sourceCluster;
        @XmlElement
        public Date startTime;
        @XmlElement
        public Date endTime;
        @XmlElement
        public int runId;
        @XmlElement
        public String details;
        @XmlElement
        public InstanceAction[] actions;
        @XmlElement(name="wfParams")
        public KeyValuePair[] wfParams;

        public Instance() {
        }

        public Instance(String cluster, String instance, WorkflowStatus status) {
            this.cluster = cluster;
            this.instance = instance;
            this.status = status;
        }

        public String getInstance() {
            return this.instance;
        }

        public WorkflowStatus getStatus() {
            return this.status;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSourceCluster() {
            return this.sourceCluster;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public int getRunId() {
            return this.runId;
        }

        public InstanceAction[] getActions() {
            return this.actions;
        }

        public String getDetails() {
            return this.details;
        }

        public KeyValuePair[] getWfParams() {
            return this.wfParams;
        }

        public String toString() {
            return "{instance:" + this.instance + ", status:" + (Object)((Object)this.status) + (this.logFile == null ? "" : ", log:" + this.logFile) + (this.sourceCluster == null ? "" : ", source-cluster:" + this.sourceCluster) + (this.cluster == null ? "" : ", cluster:" + this.cluster) + "}";
        }
    }

    public static enum InstanceFilterFields {
        STATUS,
        CLUSTER,
        SOURCECLUSTER,
        STARTEDAFTER;

    }

    public static enum WorkflowStatus {
        WAITING,
        RUNNING,
        SUSPENDED,
        KILLED,
        FAILED,
        SUCCEEDED,
        ERROR,
        SKIPPED,
        UNDEFINED;

    }
}

