/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FileUtils;
import org.apache.falcon.resource.APIResult;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class FeedInstanceResult
extends APIResult {
    @XmlElement
    private Instance[] instances;

    private FeedInstanceResult() {
    }

    public FeedInstanceResult(String message, Instance[] instances) {
        this(APIResult.Status.SUCCEEDED, message, instances);
    }

    public FeedInstanceResult(APIResult.Status status, String message, Instance[] inInstances) {
        super(status, message);
        this.instances = inInstances;
    }

    public FeedInstanceResult(APIResult.Status status, String message) {
        super(status, message);
    }

    public Instance[] getInstances() {
        return this.instances;
    }

    public void setInstances(Instance[] instances) {
        this.instances = instances;
    }

    @Override
    public Object[] getCollection() {
        return this.getInstances();
    }

    @Override
    public void setCollection(Object[] items) {
        if (items == null) {
            this.setInstances(new Instance[0]);
        } else {
            Instance[] newInstances = new Instance[items.length];
            for (int index = 0; index < items.length; ++index) {
                newInstances[index] = (Instance)items[index];
            }
            this.setInstances(newInstances);
        }
    }

    @XmlRootElement(name="instance")
    public static class Instance {
        @XmlElement
        public String cluster;
        @XmlElement
        public String instance;
        @XmlElement
        public String status;
        @XmlElement
        public String uri;
        @XmlElement
        public long creationTime;
        @XmlElement
        public long size;
        @XmlElement
        public String sizeH;

        public Instance() {
        }

        public Instance(String cluster, String instance, String status) {
            this.cluster = cluster;
            this.instance = instance;
            this.status = status;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getStatus() {
            return this.status;
        }

        public String getUri() {
            return this.uri;
        }

        public String getCluster() {
            return this.cluster;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public Long getSize() {
            return this.size;
        }

        public String getSizeH() {
            return FileUtils.byteCountToDisplaySize((long)this.size);
        }

        public String toString() {
            return "{instance:" + this.instance + ", status:" + this.status + (this.uri == null ? "" : ", uri: " + this.uri) + (this.cluster == null ? "" : ", cluster:" + this.cluster) + "}";
        }
    }
}

