/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.falcon.resource.APIResult;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class EntitySummaryResult
extends APIResult {
    @XmlElement
    private EntitySummary[] entitySummaries;

    public EntitySummaryResult() {
    }

    public EntitySummaryResult(String message, EntitySummary[] entitySummaries) {
        this(APIResult.Status.SUCCEEDED, message, entitySummaries);
    }

    public EntitySummaryResult(APIResult.Status status, String message, EntitySummary[] entitySummaries) {
        super(status, message);
        this.entitySummaries = entitySummaries;
    }

    public EntitySummaryResult(APIResult.Status status, String message) {
        super(status, message);
    }

    public EntitySummary[] getEntitySummaries() {
        return this.entitySummaries;
    }

    public void setEntitySummaries(EntitySummary[] entitySummaries) {
        this.entitySummaries = entitySummaries;
    }

    @XmlRootElement(name="instances")
    public static class Instance {
        @XmlElement
        public String instance;
        @XmlElement
        public WorkflowStatus status;
        @XmlElement
        public String logFile;
        @XmlElement
        public String cluster;
        @XmlElement
        public String sourceCluster;
        @XmlElement
        public Date startTime;
        @XmlElement
        public Date endTime;

        public Instance() {
        }

        public Instance(String cluster, String instance, WorkflowStatus status) {
            this.cluster = cluster;
            this.instance = instance;
            this.status = status;
        }

        public String getInstance() {
            return this.instance;
        }

        public WorkflowStatus getStatus() {
            return this.status;
        }

        public String getLogFile() {
            return this.logFile;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSourceCluster() {
            return this.sourceCluster;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            return "{instance: " + (this.instance == null ? "" : this.instance) + ", status: " + (this.status == null ? "" : this.status) + (this.logFile == null ? "" : ", log: " + this.logFile) + (this.sourceCluster == null ? "" : ", source-cluster: " + this.sourceCluster) + (this.cluster == null ? "" : ", cluster: " + this.cluster) + (this.startTime == null ? "" : ", startTime: " + this.startTime) + (this.endTime == null ? "" : ", endTime: " + this.endTime) + "}";
        }
    }

    @XmlRootElement(name="entitySummary")
    public static class EntitySummary {
        @XmlElement
        public String type;
        @XmlElement
        public String name;
        @XmlElement
        public String status;
        @XmlElement
        public String[] tags;
        @XmlElement
        public String[] pipelines;
        @XmlElement
        public Instance[] instances;

        public EntitySummary() {
        }

        public EntitySummary(String entityName, String entityType) {
            this.name = entityName;
            this.type = entityType;
        }

        public EntitySummary(String name, String type, String status, String[] tags, String[] pipelines, Instance[] instances) {
            this.name = name;
            this.type = type;
            this.status = status;
            this.pipelines = pipelines;
            this.tags = tags;
            this.instances = instances;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getStatus() {
            return this.status;
        }

        public String[] getTags() {
            return this.tags;
        }

        public String[] getPipelines() {
            return this.pipelines;
        }

        public Instance[] getInstances() {
            return this.instances;
        }

        public String toString() {
            return "{Entity: " + (this.name == null ? "" : this.name) + ", Type: " + (this.type == null ? "" : this.type) + ", Status: " + (this.status == null ? "" : this.status) + ", Tags: " + (this.tags == null ? "[]" : Arrays.toString(this.tags)) + ", Pipelines: " + (this.pipelines == null ? "[]" : Arrays.toString(this.pipelines)) + ", InstanceSummary: " + (this.instances == null ? "[]" : Arrays.toString(this.instances)) + "}";
        }
    }

    public static enum WorkflowStatus {
        WAITING,
        RUNNING,
        SUSPENDED,
        KILLED,
        FAILED,
        SUCCEEDED,
        ERROR;

    }
}

