/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.recipe.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.entity.v0.process.ACL;
import org.apache.falcon.entity.v0.process.Cluster;
import org.apache.falcon.entity.v0.process.Notification;
import org.apache.falcon.entity.v0.process.PolicyType;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.entity.v0.process.Property;
import org.apache.falcon.entity.v0.process.Retry;
import org.apache.falcon.entity.v0.process.Workflow;
import org.apache.falcon.recipe.RecipeToolOptions;

public final class RecipeProcessBuilderUtils {
    private static final Pattern RECIPE_VAR_PATTERN = Pattern.compile("##[A-Za-z0-9_.]*##");

    private RecipeProcessBuilderUtils() {
    }

    public static String createProcessFromTemplate(String processTemplateFile, Properties recipeProperties, String processFilename) throws Exception {
        Process process = RecipeProcessBuilderUtils.bindAttributesInTemplate(processTemplateFile, recipeProperties);
        String recipeProcessFilename = RecipeProcessBuilderUtils.createProcessXmlFile(processFilename, process);
        RecipeProcessBuilderUtils.validateProcessXmlFile(recipeProcessFilename);
        return recipeProcessFilename;
    }

    private static Process bindAttributesInTemplate(String templateFile, Properties recipeProperties) throws Exception {
        if (templateFile == null || recipeProperties == null) {
            throw new IllegalArgumentException("Invalid arguments passed");
        }
        Unmarshaller unmarshaller = EntityType.PROCESS.getUnmarshaller();
        unmarshaller.setSchema(null);
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        URL processResourceUrl = new File(templateFile).toURI().toURL();
        Process process = (Process)unmarshaller.unmarshal(processResourceUrl);
        String processName = recipeProperties.getProperty(RecipeToolOptions.RECIPE_NAME.getName());
        if (StringUtils.isNotEmpty((CharSequence)processName)) {
            process.setName(processName);
        }
        RecipeProcessBuilderUtils.bindClusterProperties(process.getClusters().getClusters().get(0), recipeProperties);
        String processFrequency = recipeProperties.getProperty(RecipeToolOptions.PROCESS_FREQUENCY.getName());
        if (StringUtils.isNotEmpty((CharSequence)processFrequency)) {
            process.setFrequency(Frequency.fromString(processFrequency));
        }
        RecipeProcessBuilderUtils.bindWorkflowProperties(process.getWorkflow(), recipeProperties);
        RecipeProcessBuilderUtils.bindRetryProperties(process.getRetry(), recipeProperties);
        RecipeProcessBuilderUtils.bindNotificationProperties(process.getNotification(), recipeProperties);
        RecipeProcessBuilderUtils.bindACLProperties(process.getACL(), recipeProperties);
        RecipeProcessBuilderUtils.bindTagsProperties(process, recipeProperties);
        RecipeProcessBuilderUtils.bindCustomProperties(process.getProperties(), recipeProperties);
        return process;
    }

    private static void bindClusterProperties(Cluster cluster, Properties recipeProperties) {
        String clusterEndValidity;
        String clusterStartValidity;
        String clusterName = recipeProperties.getProperty(RecipeToolOptions.CLUSTER_NAME.getName());
        if (StringUtils.isNotEmpty((CharSequence)clusterName)) {
            cluster.setName(clusterName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(clusterStartValidity = recipeProperties.getProperty(RecipeToolOptions.CLUSTER_VALIDITY_START.getName())))) {
            cluster.getValidity().setStart(SchemaHelper.parseDateUTC(clusterStartValidity));
        }
        if (StringUtils.isNotEmpty((CharSequence)(clusterEndValidity = recipeProperties.getProperty(RecipeToolOptions.CLUSTER_VALIDITY_END.getName())))) {
            cluster.getValidity().setEnd(SchemaHelper.parseDateUTC(clusterEndValidity));
        }
    }

    private static void bindWorkflowProperties(Workflow wf, Properties recipeProperties) {
        String wfLibPath;
        String wfName = recipeProperties.getProperty(RecipeToolOptions.WORKFLOW_NAME.getName());
        if (StringUtils.isNotEmpty((CharSequence)wfName)) {
            wf.setName(wfName);
        }
        if (StringUtils.isNotEmpty((CharSequence)(wfLibPath = recipeProperties.getProperty(RecipeToolOptions.WORKFLOW_LIB_PATH.getName())))) {
            wf.setLib(wfLibPath);
        } else if (wf.getLib().startsWith("##")) {
            wf.setLib("");
        }
        String wfPath = recipeProperties.getProperty(RecipeToolOptions.WORKFLOW_PATH.getName());
        if (StringUtils.isNotEmpty((CharSequence)wfPath)) {
            wf.setPath(wfPath);
        }
    }

    private static void bindRetryProperties(Retry processRetry, Properties recipeProperties) {
        String retryDelay;
        String retryAttempts;
        String retryPolicy = recipeProperties.getProperty(RecipeToolOptions.RETRY_POLICY.getName());
        if (StringUtils.isNotEmpty((CharSequence)retryPolicy)) {
            processRetry.setPolicy(PolicyType.fromValue(retryPolicy));
        }
        if (StringUtils.isNotEmpty((CharSequence)(retryAttempts = recipeProperties.getProperty(RecipeToolOptions.RETRY_ATTEMPTS.getName())))) {
            processRetry.setAttempts(Integer.parseInt(retryAttempts));
        }
        if (StringUtils.isNotEmpty((CharSequence)(retryDelay = recipeProperties.getProperty(RecipeToolOptions.RETRY_DELAY.getName())))) {
            processRetry.setDelay(Frequency.fromString(retryDelay));
        }
    }

    private static void bindNotificationProperties(Notification processNotification, Properties recipeProperties) {
        processNotification.setType(recipeProperties.getProperty(RecipeToolOptions.RECIPE_NOTIFICATION_TYPE.getName()));
        String notificationAddress = recipeProperties.getProperty(RecipeToolOptions.RECIPE_NOTIFICATION_ADDRESS.getName());
        if (StringUtils.isNotBlank((CharSequence)notificationAddress)) {
            processNotification.setTo(notificationAddress);
        } else {
            processNotification.setTo("NA");
        }
    }

    private static void bindACLProperties(ACL acl, Properties recipeProperties) {
        String aclPermission;
        String aclGroup;
        String aclowner = recipeProperties.getProperty(RecipeToolOptions.RECIPE_ACL_OWNER.getName());
        if (StringUtils.isNotEmpty((CharSequence)aclowner)) {
            acl.setOwner(aclowner);
        }
        if (StringUtils.isNotEmpty((CharSequence)(aclGroup = recipeProperties.getProperty(RecipeToolOptions.RECIPE_ACL_GROUP.getName())))) {
            acl.setGroup(aclGroup);
        }
        if (StringUtils.isNotEmpty((CharSequence)(aclPermission = recipeProperties.getProperty(RecipeToolOptions.RECIPE_ACL_PERMISSION.getName())))) {
            acl.setPermission(aclPermission);
        }
    }

    private static void bindTagsProperties(Process process, Properties recipeProperties) {
        String falconSystemTags = process.getTags();
        String tags = recipeProperties.getProperty(RecipeToolOptions.RECIPE_TAGS.getName());
        if (StringUtils.isNotEmpty((CharSequence)tags)) {
            if (StringUtils.isNotEmpty((CharSequence)falconSystemTags)) {
                tags = tags + ", " + falconSystemTags;
            }
            process.setTags(tags);
        }
    }

    private static void bindCustomProperties(org.apache.falcon.entity.v0.process.Properties customProperties, Properties recipeProperties) {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        for (Map.Entry<Object, Object> recipeProperty : recipeProperties.entrySet()) {
            if (RecipeToolOptions.OPTIONSMAP.get(recipeProperty.getKey().toString()) != null) continue;
            RecipeProcessBuilderUtils.addProperty(propertyList, (String)recipeProperty.getKey(), (String)recipeProperty.getValue());
        }
        customProperties.getProperties().addAll(propertyList);
    }

    private static void addProperty(List<Property> propertyList, String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        propertyList.add(prop);
    }

    private static String createProcessXmlFile(String outFilename, Entity entity) throws Exception {
        if (outFilename == null || entity == null) {
            throw new IllegalArgumentException("Invalid arguments passed");
        }
        EntityType type = EntityType.PROCESS;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFilename);
            type.getMarshaller().marshal((Object)entity, (OutputStream)out);
        }
        catch (JAXBException e) {
            try {
                throw new Exception("Unable to serialize the entity object " + (Object)((Object)type) + "/" + entity.getName(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return outFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateProcessXmlFile(String processFileName) throws Exception {
        if (processFileName == null) {
            throw new IllegalArgumentException("Invalid arguments passed");
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(processFileName));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = RECIPE_VAR_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                String variable = line.substring(matcher.start(), matcher.end());
                throw new Exception("Match not found for the template: " + variable + " in recipe template file. Please add it in recipe properties file");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

