/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.recipe;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public enum RecipeToolArgs {
    RECIPE_FILE_ARG("file", "recipe template file path"),
    RECIPE_PROPERTIES_FILE_ARG("propertiesFile", "recipe properties file path"),
    RECIPE_PROCESS_XML_FILE_PATH_ARG("recipeProcessFilePath", "file path of recipe process to be submitted"),
    RECIPE_OPERATION_ARG("recipeOperation", "recipe operation");

    private final String name;
    private final String description;
    private final boolean isRequired;

    private RecipeToolArgs(String name, String description) {
        this(name, description, true);
    }

    private RecipeToolArgs(String name, String description, boolean isRequired) {
        this.name = name;
        this.description = description;
        this.isRequired = isRequired;
    }

    public Option getOption() {
        return new Option(this.name, true, this.description);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getOptionValue(CommandLine cmd) {
        return cmd.getOptionValue(this.name);
    }

    public String toString() {
        return this.getName();
    }
}

