/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.recipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.recipe.Recipe;
import org.apache.falcon.recipe.RecipeFactory;
import org.apache.falcon.recipe.RecipeToolArgs;
import org.apache.falcon.recipe.RecipeToolOptions;
import org.apache.falcon.recipe.util.RecipeProcessBuilderUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class RecipeTool
extends Configured
implements Tool {
    private static final String HDFS_WF_PATH = "falcon" + File.separator + "recipes" + File.separator;
    private static final FsPermission FS_PERMISSION = new FsPermission(FsAction.ALL, FsAction.READ, FsAction.NONE);
    private static final String FS_DEFAULT_NAME_KEY = "fs.defaultFS";
    private static final String NN_PRINCIPAL = "dfs.namenode.kerberos.principal";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RecipeTool(), (String[])args);
    }

    public int run(String[] arguments) throws Exception {
        Map<RecipeToolArgs, String> argMap = this.setupArgs(arguments);
        if (argMap == null || argMap.isEmpty()) {
            throw new Exception("Arguments passed to recipe is null");
        }
        Configuration conf = this.getConf();
        String recipePropertiesFilePath = argMap.get((Object)RecipeToolArgs.RECIPE_PROPERTIES_FILE_ARG);
        Properties recipeProperties = RecipeTool.loadProperties(recipePropertiesFilePath);
        RecipeTool.validateProperties(recipeProperties);
        String recipeOperation = argMap.get((Object)RecipeToolArgs.RECIPE_OPERATION_ARG);
        Recipe recipeType = RecipeFactory.getRecipeToolType(recipeOperation);
        if (recipeType != null) {
            recipeType.validate(recipeProperties);
            Properties props = recipeType.getAdditionalSystemProperties(recipeProperties);
            if (props != null && !props.isEmpty()) {
                recipeProperties.putAll((Map<?, ?>)props);
            }
        }
        FileSystem fs = this.getFileSystemForHdfs(recipeProperties, conf);
        RecipeTool.validateArtifacts(recipeProperties, fs);
        String recipeName = recipeProperties.getProperty(RecipeToolOptions.RECIPE_NAME.getName());
        RecipeTool.copyFilesToHdfsIfRequired(recipeProperties, fs, recipeName);
        String processFilename = RecipeProcessBuilderUtils.createProcessFromTemplate(argMap.get((Object)RecipeToolArgs.RECIPE_FILE_ARG), recipeProperties, argMap.get((Object)RecipeToolArgs.RECIPE_PROCESS_XML_FILE_PATH_ARG));
        System.out.println("Generated process file to be scheduled: ");
        System.out.println(FileUtils.readFileToString((File)new File(processFilename)));
        System.out.println("Completed recipe processing");
        return 0;
    }

    private Map<RecipeToolArgs, String> setupArgs(String[] arguments) throws ParseException {
        Options options = new Options();
        HashMap<RecipeToolArgs, String> argMap = new HashMap<RecipeToolArgs, String>();
        for (RecipeToolArgs arg : RecipeToolArgs.values()) {
            RecipeTool.addOption(options, arg, arg.isRequired());
        }
        CommandLine cmd = new GnuParser().parse(options, arguments);
        for (RecipeToolArgs arg : RecipeToolArgs.values()) {
            String optionValue = arg.getOptionValue(cmd);
            if (!StringUtils.isNotEmpty((CharSequence)optionValue)) continue;
            argMap.put(arg, optionValue);
        }
        return argMap;
    }

    private static void addOption(Options options, RecipeToolArgs arg, boolean isRequired) {
        Option option = arg.getOption();
        option.setRequired(isRequired);
        options.addOption(option);
    }

    private static void validateProperties(Properties recipeProperties) {
        for (RecipeToolOptions option : RecipeToolOptions.values()) {
            if (recipeProperties.getProperty(option.getName()) != null || !option.isRequired()) continue;
            throw new IllegalArgumentException("Missing argument: " + option.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propertiesFilePath) throws Exception {
        Properties properties;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertiesFilePath);
            Properties prop = new Properties();
            prop.load(inputStream);
            properties = prop;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return properties;
    }

    private static void validateArtifacts(Properties recipeProperties, FileSystem fs) throws Exception {
        String wfPath = recipeProperties.getProperty(RecipeToolOptions.WORKFLOW_PATH.getName());
        if (StringUtils.isNotEmpty((CharSequence)wfPath) && !fs.exists(new Path(wfPath)) && !RecipeTool.doesFileExist(wfPath)) {
            throw new Exception("Recipe workflow file does not exist : " + wfPath + " on local FS or HDFS");
        }
        String libPath = recipeProperties.getProperty(RecipeToolOptions.WORKFLOW_LIB_PATH.getName());
        if (StringUtils.isNotEmpty((CharSequence)libPath) && !fs.exists(new Path(libPath)) && !RecipeTool.doesFileExist(libPath)) {
            throw new Exception("Recipe lib file path does not exist : " + libPath + " on local FS or HDFS");
        }
    }

    private static void copyFilesToHdfsIfRequired(Properties recipeProperties, FileSystem fs, String recipeName) throws Exception {
        String recipeWfLibPathName;
        String libPath;
        boolean isLibPathEmpty;
        String hdfsPath = HDFS_WF_PATH + recipeName + File.separator;
        String recipeWfPathName = RecipeToolOptions.WORKFLOW_PATH.getName();
        String wfPath = recipeProperties.getProperty(recipeWfPathName);
        if (StringUtils.isNotEmpty((CharSequence)wfPath) && !fs.exists(new Path(wfPath))) {
            String wfPathValue;
            RecipeTool.createDirOnHdfs(hdfsPath, fs);
            if (new File(wfPath).isDirectory()) {
                wfPathValue = hdfsPath + RecipeTool.getLastPartOfPath(wfPath);
                RecipeTool.copyFileFromLocalToHdfs(wfPath, hdfsPath, true, wfPathValue, fs);
            } else {
                wfPathValue = hdfsPath + new File(wfPath).getName();
                RecipeTool.copyFileFromLocalToHdfs(wfPath, hdfsPath, false, null, fs);
            }
            recipeProperties.setProperty(recipeWfPathName, fs.getFileStatus(new Path(wfPathValue)).getPath().toString());
            System.out.println("Copied WF to: " + recipeProperties.getProperty(recipeWfPathName));
        }
        if (!(isLibPathEmpty = StringUtils.isEmpty((CharSequence)(libPath = recipeProperties.getProperty(recipeWfLibPathName = RecipeToolOptions.WORKFLOW_LIB_PATH.getName())))) && !fs.exists(new Path(libPath))) {
            String libPathValue;
            if (new File(libPath).isDirectory()) {
                libPathValue = hdfsPath + RecipeTool.getLastPartOfPath(libPath);
                RecipeTool.copyFileFromLocalToHdfs(libPath, hdfsPath, true, libPathValue, fs);
            } else {
                libPathValue = hdfsPath + "lib" + File.separator + new File(libPath).getName();
                RecipeTool.copyFileFromLocalToHdfs(libPath, libPathValue, false, null, fs);
            }
            recipeProperties.setProperty(recipeWfLibPathName, fs.getFileStatus(new Path(libPathValue)).getPath().toString());
            System.out.println("Copied WF libs to: " + recipeProperties.getProperty(recipeWfLibPathName));
        } else if (isLibPathEmpty) {
            recipeProperties.setProperty(recipeWfLibPathName, "");
        }
    }

    private static String getLastPartOfPath(String path) {
        String normalizedWfPath = FilenameUtils.normalizeNoEndSeparator((String)path);
        return normalizedWfPath == null ? FilenameUtils.getName((String)path) : FilenameUtils.getName((String)normalizedWfPath);
    }

    private static void createDirOnHdfs(String path, FileSystem fs) throws IOException {
        Path hdfsPath = new Path(path);
        if (!fs.exists(hdfsPath)) {
            FileSystem.mkdirs((FileSystem)fs, (Path)hdfsPath, (FsPermission)FS_PERMISSION);
        }
    }

    private static boolean doesFileExist(String filename) {
        return new File(filename).exists();
    }

    private static void copyFileFromLocalToHdfs(String localFilePath, String hdfsFilePath, boolean copyDir, String hdfsFileDirPath, FileSystem fs) throws IOException {
        if (copyDir) {
            Path hdfsPath = new Path(hdfsFileDirPath);
            fs.delete(hdfsPath, true);
        }
        fs.copyFromLocalFile(false, true, new Path(localFilePath), new Path(hdfsFilePath));
    }

    private FileSystem getFileSystemForHdfs(Properties recipeProperties, Configuration conf) throws Exception {
        String storageEndpoint = RecipeToolOptions.CLUSTER_HDFS_WRITE_ENDPOINT.getName();
        String nameNode = recipeProperties.getProperty(storageEndpoint);
        conf.set(FS_DEFAULT_NAME_KEY, nameNode);
        if (UserGroupInformation.isSecurityEnabled()) {
            String nameNodePrincipal = recipeProperties.getProperty(RecipeToolOptions.RECIPE_NN_PRINCIPAL.getName());
            conf.set(NN_PRINCIPAL, nameNodePrincipal);
        }
        return this.createFileSystem(UserGroupInformation.getLoginUser(), new URI(nameNode), conf);
    }

    private FileSystem createFileSystem(UserGroupInformation ugi, final URI uri, final Configuration conf) throws Exception {
        try {
            String proxyUserName = ugi.getShortUserName();
            if (proxyUserName.equals(UserGroupInformation.getLoginUser().getShortUserName())) {
                return FileSystem.get((URI)uri, (Configuration)conf);
            }
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((URI)uri, (Configuration)conf);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new IOException("Exception creating FileSystem:" + ex.getMessage(), ex);
        }
    }
}

