/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.recipe;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.recipe.HdfsReplicationRecipeToolOptions;
import org.apache.falcon.recipe.Recipe;

public class HdfsReplicationRecipeTool
implements Recipe {
    private static final String COMMA_SEPARATOR = ",";

    @Override
    public void validate(Properties recipeProperties) {
        for (HdfsReplicationRecipeToolOptions option : HdfsReplicationRecipeToolOptions.values()) {
            if (recipeProperties.getProperty(option.getName()) != null || !option.isRequired()) continue;
            throw new IllegalArgumentException("Missing argument: " + option.getName());
        }
    }

    @Override
    public Properties getAdditionalSystemProperties(Properties recipeProperties) {
        Properties additionalProperties = new Properties();
        String srcPaths = recipeProperties.getProperty(HdfsReplicationRecipeToolOptions.REPLICATION_SOURCE_DIR.getName());
        StringBuilder absoluteSrcPaths = new StringBuilder();
        String srcFsPath = recipeProperties.getProperty(HdfsReplicationRecipeToolOptions.REPLICATION_SOURCE_CLUSTER_FS_WRITE_ENDPOINT.getName());
        if (StringUtils.isNotEmpty((CharSequence)srcFsPath)) {
            srcFsPath = StringUtils.removeEnd((String)srcFsPath, (String)File.separator);
        }
        if (StringUtils.isNotEmpty((CharSequence)srcPaths)) {
            String[] paths;
            for (String path : paths = srcPaths.split(COMMA_SEPARATOR)) {
                StringBuilder srcpath = new StringBuilder(srcFsPath);
                srcpath.append(path.trim());
                srcpath.append(COMMA_SEPARATOR);
                absoluteSrcPaths.append((CharSequence)srcpath);
            }
        }
        additionalProperties.put(HdfsReplicationRecipeToolOptions.REPLICATION_SOURCE_DIR.getName(), StringUtils.removeEnd((String)absoluteSrcPaths.toString(), (String)COMMA_SEPARATOR));
        return additionalProperties;
    }
}

