/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.process.Process;

public enum EntityType {
    FEED(Feed.class, "/feed-0.1.xsd", "name"),
    PROCESS(Process.class, "/process-0.1.xsd", "name"),
    CLUSTER(Cluster.class, "/cluster-0.1.xsd", "name");

    private static final String NS = "http://www.w3.org/2001/XMLSchema";
    private final Class<? extends Entity> clazz;
    private JAXBContext jaxbContext;
    private Schema schema;
    private String[] immutableProperties;
    private String schemaFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityType(Class<? extends Entity> typeClass, String schemaFile, String ... immutableProperties) {
        this.clazz = typeClass;
        this.immutableProperties = immutableProperties;
        this.schemaFile = schemaFile;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{typeClass});
            EntityType entityType = this;
            synchronized (entityType) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance(NS);
                this.schema = schemaFactory.newSchema(((Object)((Object)this)).getClass().getResource(schemaFile));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends Entity> getEntityClass() {
        return this.clazz;
    }

    public String getSchemaFile() {
        return this.schemaFile;
    }

    public Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        unmarshaller.setSchema(this.schema);
        unmarshaller.setEventHandler((ValidationEventHandler)new EventHandler());
        return unmarshaller;
    }

    public boolean isSchedulable() {
        return this != CLUSTER;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getImmutableProperties() {
        return this.immutableProperties;
    }

    public static EntityType getEnum(String type) {
        try {
            return EntityType.valueOf(type.toUpperCase().trim());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid entity type: " + type + ". Expected " + Arrays.toString((Object[])EntityType.values()).toLowerCase() + ".");
        }
    }

    private static class EventHandler
    implements ValidationEventHandler {
        private EventHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            return false;
        }
    }
}

