/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureRandom;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.falcon.LifeCycle;
import org.apache.falcon.client.AbstractFalconClient;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.recipe.RecipeTool;
import org.apache.falcon.recipe.RecipeToolArgs;
import org.apache.falcon.resource.APIResult;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.EntitySummaryResult;
import org.apache.falcon.resource.FeedInstanceResult;
import org.apache.falcon.resource.FeedLookupResult;
import org.apache.falcon.resource.InstanceDependencyResult;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;
import org.apache.falcon.resource.LineageGraphResult;
import org.apache.falcon.resource.SchedulableEntityInstanceResult;
import org.apache.falcon.resource.TriageResult;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;

public class FalconClient
extends AbstractFalconClient {
    public static final AtomicReference<PrintStream> OUT = new AtomicReference<PrintStream>(System.out);
    public static final String WS_HEADER_PREFIX = "header:";
    public static final String USER = System.getProperty("user.name");
    public static final String AUTH_URL = "api/options?user.name=" + USER;
    private static final String FALCON_INSTANCE_ACTION_CLUSTERS = "falcon.instance.action.clusters";
    private static final String FALCON_INSTANCE_SOURCE_CLUSTERS = "falcon.instance.source.clusters";
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static final KerberosAuthenticator AUTHENTICATOR = new KerberosAuthenticator();
    private static final String TEMPLATE_SUFFIX = "-template.xml";
    private static final String PROPERTIES_SUFFIX = ".properties";
    public static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private final WebResource service;
    private final AuthenticatedURL.Token authenticationToken;
    private boolean debugMode = false;
    private final Properties clientProperties;

    public FalconClient(String falconUrl) throws FalconCLIException {
        this(falconUrl, new Properties());
    }

    public FalconClient(String falconUrl, Properties properties) throws FalconCLIException {
        try {
            String baseUrl = this.notEmpty(falconUrl, "FalconUrl");
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            this.clientProperties = properties;
            SSLContext sslContext = FalconClient.getSslContext();
            DefaultClientConfig config = new DefaultClientConfig();
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(ALL_TRUSTING_HOSTNAME_VERIFIER, sslContext));
            Client client = Client.create((ClientConfig)config);
            client.setConnectTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.getProperty("falcon.connect.timeout", "180000"))));
            client.setReadTimeout(Integer.valueOf(Integer.parseInt(this.clientProperties.getProperty("falcon.read.timeout", "180000"))));
            this.service = client.resource(UriBuilder.fromUri((String)baseUrl).build(new Object[0]));
            client.resource(UriBuilder.fromUri((String)baseUrl).build(new Object[0]));
            this.authenticationToken = FalconClient.getToken(baseUrl);
        }
        catch (Exception e) {
            throw new FalconCLIException("Unable to initialize Falcon Client object", e);
        }
    }

    private static SSLContext getSslContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{TrustManagerUtils.getValidateServerCertificateTrustManager()}, new SecureRandom());
        return sslContext;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public Properties getClientProperties() {
        return this.clientProperties;
    }

    public static AuthenticatedURL.Token getToken(String baseUrl) throws FalconCLIException {
        AuthenticatedURL.Token currentToken = new AuthenticatedURL.Token();
        try {
            URL url = new URL(baseUrl + AUTH_URL);
            HttpsURLConnection.setDefaultSSLSocketFactory(FalconClient.getSslContext().getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(ALL_TRUSTING_HOSTNAME_VERIFIER);
            new AuthenticatedURL((Authenticator)AUTHENTICATOR).openConnection(url, currentToken);
        }
        catch (Exception ex) {
            throw new FalconCLIException("Could not authenticate, " + ex.getMessage(), ex);
        }
        return currentToken;
    }

    public String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    @Override
    public APIResult schedule(EntityType entityType, String entityName, String colo, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        return this.sendEntityRequest(Entities.SCHEDULE, entityType, entityName, colo, skipDryRun, doAsUser, properties);
    }

    @Override
    public APIResult suspend(EntityType entityType, String entityName, String colo, String doAsUser) throws FalconCLIException {
        return this.sendEntityRequest(Entities.SUSPEND, entityType, entityName, colo, null, doAsUser, null);
    }

    @Override
    public APIResult resume(EntityType entityType, String entityName, String colo, String doAsUser) throws FalconCLIException {
        return this.sendEntityRequest(Entities.RESUME, entityType, entityName, colo, null, doAsUser, null);
    }

    public APIResult delete(EntityType entityType, String entityName, String doAsUser) throws FalconCLIException {
        return this.sendEntityRequest(Entities.DELETE, entityType, entityName, null, null, doAsUser, null);
    }

    public APIResult validate(String entityType, String filePath, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        return this.sendEntityRequestWithObject(Entities.VALIDATE, entityType, entityStream, null, skipDryRun, doAsUser, null);
    }

    @Override
    public APIResult submit(String entityType, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        return this.sendEntityRequestWithObject(Entities.SUBMIT, entityType, entityStream, null, null, doAsUser, null);
    }

    public APIResult update(String entityType, String entityName, String filePath, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        Entities operation = Entities.UPDATE;
        WebResource resource = this.service.path(operation.path).path(entityType).path(entityName);
        if (null != skipDryRun) {
            resource = resource.queryParam("skipDryRun", String.valueOf(skipDryRun));
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{operation.mimeType})).type("text/xml")).method(operation.method, ClientResponse.class, (Object)entityStream);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return this.parseAPIResult(clientResponse);
    }

    public APIResult submitAndSchedule(String entityType, String filePath, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        return this.sendEntityRequestWithObject(Entities.SUBMITandSCHEDULE, entityType, entityStream, null, skipDryRun, doAsUser, properties);
    }

    @Override
    public APIResult getStatus(EntityType entityType, String entityName, String colo, String doAsUser) throws FalconCLIException {
        return this.sendEntityRequest(Entities.STATUS, entityType, entityName, colo, null, doAsUser, null);
    }

    public Entity getDefinition(String entityType, String entityName, String doAsUser) throws FalconCLIException {
        return this.sendDefinitionRequest(Entities.DEFINITION, entityType, entityName, doAsUser);
    }

    public EntityList getDependency(String entityType, String entityName, String doAsUser) throws FalconCLIException {
        return this.sendDependencyRequest(Entities.DEPENDENCY, entityType, entityName, doAsUser);
    }

    public SchedulableEntityInstanceResult getFeedSlaMissPendingAlerts(String entityType, String entityName, String startTime, String endTime, String colo) throws FalconCLIException {
        WebResource resource = this.service.path(Entities.SLA.path).path(entityType).queryParam("start", startTime).queryParam("colo", colo);
        if (endTime != null) {
            resource = resource.queryParam("end", endTime);
        }
        if (entityName != null) {
            resource = resource.queryParam("name", entityName);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{Entities.SLA.mimeType})).type("application/json")).method(Entities.SLA.method, ClientResponse.class);
        this.checkIfSuccessful(clientResponse);
        return (SchedulableEntityInstanceResult)clientResponse.getEntity(SchedulableEntityInstanceResult.class);
    }

    public TriageResult triage(String entityType, String entityName, String instanceTime, String colo) throws FalconCLIException {
        WebResource resource = this.service.path(Instances.TRIAGE.path).path(entityType).path(entityName).queryParam("start", instanceTime).queryParam("colo", colo);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{Instances.TRIAGE.mimeType})).type("text/xml")).method(Instances.TRIAGE.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (TriageResult)clientResponse.getEntity(TriageResult.class);
    }

    public EntityList getEntityList(String entityType, String fields, String nameSubsequence, String tagKeywords, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        return this.sendListRequest(Entities.LIST, entityType, fields, nameSubsequence, tagKeywords, filterBy, filterTags, orderBy, sortOrder, offset, numResults, doAsUser);
    }

    public EntitySummaryResult getEntitySummary(String entityType, String cluster, String start, String end, String fields, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, Integer numInstances, String doAsUser) throws FalconCLIException {
        return this.sendEntitySummaryRequest(Entities.SUMMARY, entityType, cluster, start, end, fields, filterBy, filterTags, orderBy, sortOrder, offset, numResults, numInstances, doAsUser);
    }

    public APIResult touch(String entityType, String entityName, String colo, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        Entities operation = Entities.TOUCH;
        WebResource resource = this.service.path(operation.path).path(entityType).path(entityName);
        if (colo != null) {
            resource = resource.queryParam("colo", colo);
        }
        if (null != skipDryRun) {
            resource = resource.queryParam("skipDryRun", String.valueOf(skipDryRun));
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{operation.mimeType})).type("text/xml")).method(operation.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return this.parseAPIResult(clientResponse);
    }

    public InstancesResult getRunningInstances(String type, String entity, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        return (InstancesResult)this.sendInstanceRequest(Instances.RUNNING, type, entity, null, null, null, null, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser).getEntity(InstancesResult.class);
    }

    @Override
    public InstancesResult getStatusOfInstances(String type, String entity, String start, String end, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        return (InstancesResult)this.sendInstanceRequest(Instances.STATUS, type, entity, start, end, null, null, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser).getEntity(InstancesResult.class);
    }

    public InstancesSummaryResult getSummaryOfInstances(String type, String entity, String start, String end, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, String doAsUser) throws FalconCLIException {
        return (InstancesSummaryResult)this.sendInstanceRequest(Instances.SUMMARY, type, entity, start, end, null, null, colo, lifeCycles, filterBy, orderBy, sortOrder, 0, null, doAsUser).getEntity(InstancesSummaryResult.class);
    }

    public FeedInstanceResult getFeedListing(String type, String entity, String start, String end, String colo, String doAsUser) throws FalconCLIException {
        return (FeedInstanceResult)this.sendInstanceRequest(Instances.LISTING, type, entity, start, end, null, null, colo, null, "", "", "", 0, null, doAsUser).getEntity(FeedInstanceResult.class);
    }

    public InstancesResult killInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        return this.sendInstanceRequest(Instances.KILL, type, entity, start, end, this.getServletInputStream(clusters, sourceClusters, null), null, colo, lifeCycles, doAsUser);
    }

    public InstancesResult suspendInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        return this.sendInstanceRequest(Instances.SUSPEND, type, entity, start, end, this.getServletInputStream(clusters, sourceClusters, null), null, colo, lifeCycles, doAsUser);
    }

    public InstancesResult resumeInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        return this.sendInstanceRequest(Instances.RESUME, type, entity, start, end, this.getServletInputStream(clusters, sourceClusters, null), null, colo, lifeCycles, doAsUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstancesResult rerunInstances(String type, String entity, String start, String end, String filePath, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, Boolean isForced, String doAsUser) throws FalconCLIException, IOException {
        StringBuilder buffer = new StringBuilder();
        if (filePath != null) {
            BufferedReader in = null;
            try {
                String str;
                in = new BufferedReader(new FileReader(filePath));
                while ((str = in.readLine()) != null) {
                    buffer.append(str).append("\n");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
        }
        String temp = buffer.length() == 0 ? null : buffer.toString();
        return this.sendInstanceRequest(Instances.RERUN, type, entity, start, end, this.getServletInputStream(clusters, sourceClusters, temp), null, colo, lifeCycles, isForced, doAsUser);
    }

    public InstancesResult getLogsOfInstances(String type, String entity, String start, String end, String colo, String runId, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        return (InstancesResult)this.sendInstanceRequest(Instances.LOG, type, entity, start, end, null, runId, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser).getEntity(InstancesResult.class);
    }

    public InstancesResult getParamsOfInstance(String type, String entity, String start, String colo, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        return this.sendInstanceRequest(Instances.PARAMS, type, entity, start, null, null, null, colo, lifeCycles, doAsUser);
    }

    public String getThreadDump(String doAsUser) throws FalconCLIException {
        return this.sendAdminRequest(AdminOperations.STACK, doAsUser);
    }

    public String getVersion(String doAsUser) throws FalconCLIException {
        return this.sendAdminRequest(AdminOperations.VERSION, doAsUser);
    }

    public int getStatus(String doAsUser) throws FalconCLIException {
        AdminOperations job = AdminOperations.VERSION;
        WebResource resource = this.service.path(job.path);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{job.mimeType})).type("text/plain")).method(job.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        return clientResponse.getStatus();
    }

    public String getDimensionList(String dimensionType, String cluster, String doAsUser) throws FalconCLIException {
        return this.sendMetadataDiscoveryRequest(MetadataOperations.LIST, dimensionType, null, cluster, doAsUser);
    }

    public LineageGraphResult getEntityLineageGraph(String pipelineName, String doAsUser) throws FalconCLIException {
        MetadataOperations operation = MetadataOperations.LINEAGE;
        WebResource resource = this.service.path(operation.path).queryParam("pipeline", pipelineName);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{operation.mimeType})).type(operation.mimeType)).method(operation.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (LineageGraphResult)clientResponse.getEntity(LineageGraphResult.class);
    }

    public String getDimensionRelations(String dimensionType, String dimensionName, String doAsUser) throws FalconCLIException {
        return this.sendMetadataDiscoveryRequest(MetadataOperations.RELATIONS, dimensionType, dimensionName, null, doAsUser);
    }

    private InputStream getServletInputStream(String filePath) throws FalconCLIException {
        FileInputStream stream;
        if (filePath == null) {
            return null;
        }
        try {
            stream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new FalconCLIException("File not found:", e);
        }
        return stream;
    }

    private InputStream getServletInputStream(String clusters, String sourceClusters, String properties) throws FalconCLIException, UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        if (clusters != null) {
            buffer.append(FALCON_INSTANCE_ACTION_CLUSTERS).append('=').append(clusters).append('\n');
        }
        if (sourceClusters != null) {
            buffer.append(FALCON_INSTANCE_SOURCE_CLUSTERS).append('=').append(sourceClusters).append('\n');
        }
        if (properties != null) {
            buffer.append(properties);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
        return buffer.length() == 0 ? null : stream;
    }

    private APIResult sendEntityRequest(Entities entities, EntityType entityType, String entityName, String colo, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType.toString().toLowerCase()).path(entityName);
        if (colo != null) {
            resource = resource.queryParam("colo", colo);
        }
        if (null != skipDryRun) {
            resource = resource.queryParam("skipDryRun", String.valueOf(skipDryRun));
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        if (StringUtils.isNotEmpty((CharSequence)properties)) {
            resource = resource.queryParam("properties", properties);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (APIResult)clientResponse.getEntity(APIResult.class);
    }

    private WebResource addParamsToResource(WebResource resource, String start, String end, String runId, String colo, String fields, String nameSubsequence, String tagKeywords, String filterBy, String tags, String orderBy, String sortOrder, Integer offset, Integer numResults, Integer numInstances, Boolean isForced, String doAsUser) {
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            resource = resource.queryParam("fields", fields);
        }
        if (StringUtils.isNotEmpty((CharSequence)nameSubsequence)) {
            resource = resource.queryParam("nameseq", nameSubsequence);
        }
        if (StringUtils.isNotEmpty((CharSequence)tagKeywords)) {
            resource = resource.queryParam("tagkeys", tagKeywords);
        }
        if (StringUtils.isNotEmpty((CharSequence)tags)) {
            resource = resource.queryParam("tags", tags);
        }
        if (StringUtils.isNotEmpty((CharSequence)filterBy)) {
            resource = resource.queryParam("filterBy", filterBy);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            resource = resource.queryParam("orderBy", orderBy);
        }
        if (StringUtils.isNotEmpty((CharSequence)sortOrder)) {
            resource = resource.queryParam("sortOrder", sortOrder);
        }
        if (StringUtils.isNotEmpty((CharSequence)start)) {
            resource = resource.queryParam("start", start);
        }
        if (StringUtils.isNotEmpty((CharSequence)end)) {
            resource = resource.queryParam("end", end);
        }
        if (runId != null) {
            resource = resource.queryParam("runid", runId);
        }
        if (colo != null) {
            resource = resource.queryParam("colo", colo);
        }
        if (offset != null) {
            resource = resource.queryParam("offset", offset.toString());
        }
        if (numResults != null) {
            resource = resource.queryParam("numResults", numResults.toString());
        }
        if (numInstances != null) {
            resource = resource.queryParam("numInstances", numInstances.toString());
        }
        if (isForced != null) {
            resource = resource.queryParam("force", String.valueOf(isForced));
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        return resource;
    }

    private EntitySummaryResult sendEntitySummaryRequest(Entities entities, String entityType, String cluster, String start, String end, String fields, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, Integer numInstances, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType);
        if (StringUtils.isNotEmpty((CharSequence)cluster)) {
            resource = resource.queryParam("cluster", cluster);
        }
        resource = this.addParamsToResource(resource, start, end, null, null, fields, null, null, filterBy, filterTags, orderBy, sortOrder, offset, numResults, numInstances, null, doAsUser);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (EntitySummaryResult)clientResponse.getEntity(EntitySummaryResult.class);
    }

    private Entity sendDefinitionRequest(Entities entities, String entityType, String entityName, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType).path(entityName);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        String entity = (String)clientResponse.getEntity(String.class);
        return Entity.fromString(EntityType.getEnum(entityType), entity);
    }

    private EntityList sendDependencyRequest(Entities entities, String entityType, String entityName, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType).path(entityName);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return this.parseEntityList(clientResponse);
    }

    private APIResult sendEntityRequestWithObject(Entities entities, String entityType, Object requestObject, String colo, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType);
        if (colo != null) {
            resource = resource.queryParam("colo", colo);
        }
        if (null != skipDryRun) {
            resource = resource.queryParam("skipDryRun", String.valueOf(skipDryRun));
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        if (StringUtils.isNotEmpty((CharSequence)properties)) {
            resource = resource.queryParam("properties", properties);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class, requestObject);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (APIResult)clientResponse.getEntity(APIResult.class);
    }

    public FeedLookupResult reverseLookUp(String type, String path, String doAsUser) throws FalconCLIException {
        Entities api = Entities.LOOKUP;
        WebResource resource = this.service.path(api.path).path(type);
        resource = resource.queryParam("path", path);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{api.mimeType})).method(api.method, ClientResponse.class);
        this.printClientResponse(response);
        this.checkIfSuccessful(response);
        return (FeedLookupResult)response.getEntity(FeedLookupResult.class);
    }

    private InstancesResult sendInstanceRequest(Instances instances, String type, String entity, String start, String end, InputStream props, String runid, String colo, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException {
        return (InstancesResult)this.sendInstanceRequest(instances, type, entity, start, end, props, runid, colo, lifeCycles, "", "", "", 0, null, doAsUser).getEntity(InstancesResult.class);
    }

    private InstancesResult sendInstanceRequest(Instances instances, String type, String entity, String start, String end, InputStream props, String runid, String colo, List<LifeCycle> lifeCycles, Boolean isForced, String doAsUser) throws FalconCLIException {
        return (InstancesResult)this.sendInstanceRequest(instances, type, entity, start, end, props, runid, colo, lifeCycles, "", "", "", 0, null, isForced, doAsUser).getEntity(InstancesResult.class);
    }

    private ClientResponse sendInstanceRequest(Instances instances, String type, String entity, String start, String end, InputStream props, String runid, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        return this.sendInstanceRequest(instances, type, entity, start, end, props, runid, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, null, doAsUser);
    }

    private ClientResponse sendInstanceRequest(Instances instances, String type, String entity, String start, String end, InputStream props, String runid, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, Boolean isForced, String doAsUser) throws FalconCLIException {
        this.checkType(type);
        WebResource resource = this.service.path(instances.path).path(type).path(entity);
        resource = this.addParamsToResource(resource, start, end, runid, colo, null, null, null, filterBy, null, orderBy, sortOrder, offset, numResults, null, isForced, doAsUser);
        if (lifeCycles != null) {
            this.checkLifeCycleOption(lifeCycles, type);
            for (LifeCycle lifeCycle : lifeCycles) {
                resource = resource.queryParam("lifecycle", lifeCycle.toString());
            }
        }
        ClientResponse clientResponse = props == null ? (ClientResponse)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{instances.mimeType})).method(instances.method, ClientResponse.class) : (ClientResponse)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{instances.mimeType})).method(instances.method, ClientResponse.class, (Object)props);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse;
    }

    public InstanceDependencyResult getInstanceDependencies(String entityType, String entityName, String instanceTime, String colo) throws FalconCLIException {
        this.checkType(entityType);
        Instances api = Instances.DEPENDENCY;
        WebResource resource = this.service.path(api.path).path(entityType).path(entityName);
        resource = resource.queryParam("instanceTime", instanceTime);
        resource = resource.queryParam("colo", colo);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{api.mimeType})).method(api.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (InstanceDependencyResult)clientResponse.getEntity(InstanceDependencyResult.class);
    }

    private void checkLifeCycleOption(List<LifeCycle> lifeCycles, String type) throws FalconCLIException {
        if (lifeCycles != null && !lifeCycles.isEmpty()) {
            EntityType entityType = EntityType.getEnum(type);
            for (LifeCycle lifeCycle : lifeCycles) {
                if (entityType == lifeCycle.getTag().getType()) continue;
                throw new FalconCLIException("Incorrect lifecycle: " + (Object)((Object)lifeCycle) + "for given type: " + type);
            }
        }
    }

    protected void checkType(String type) throws FalconCLIException {
        if (type == null || type.isEmpty()) {
            throw new FalconCLIException("entity type is empty");
        }
        EntityType entityType = EntityType.getEnum(type);
        if (entityType == EntityType.CLUSTER) {
            throw new FalconCLIException("Instance management functions don't apply to Cluster entities");
        }
    }

    private EntityList sendListRequest(Entities entities, String entityType, String fields, String nameSubsequence, String tagKeywords, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(entities.path).path(entityType);
        resource = this.addParamsToResource(resource, null, null, null, null, fields, nameSubsequence, tagKeywords, filterBy, filterTags, orderBy, sortOrder, offset, numResults, null, null, doAsUser);
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{entities.mimeType})).type("text/xml")).method(entities.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return this.parseEntityList(clientResponse);
    }

    private String sendAdminRequest(AdminOperations job, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(job.path);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{job.mimeType})).type(job.mimeType)).method(job.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        return (String)clientResponse.getEntity(String.class);
    }

    private String sendMetadataDiscoveryRequest(MetadataOperations operation, String dimensionType, String dimensionName, String cluster, String doAsUser) throws FalconCLIException {
        WebResource resource;
        switch (operation) {
            case LIST: {
                resource = this.service.path(operation.path).path(dimensionType).path("list");
                break;
            }
            case RELATIONS: {
                resource = this.service.path(operation.path).path(dimensionType).path(dimensionName).path("relations");
                break;
            }
            default: {
                throw new FalconCLIException("Invalid Metadata client Operation " + operation.toString());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)cluster)) {
            resource = resource.queryParam("cluster", cluster);
        }
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{operation.mimeType})).type(operation.mimeType)).method(operation.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return (String)clientResponse.getEntity(String.class);
    }

    private APIResult parseAPIResult(ClientResponse clientResponse) throws FalconCLIException {
        return (APIResult)clientResponse.getEntity(APIResult.class);
    }

    private EntityList parseEntityList(ClientResponse clientResponse) throws FalconCLIException {
        EntityList result = (EntityList)clientResponse.getEntity(EntityList.class);
        if (result == null || result.getElements() == null) {
            return null;
        }
        return result;
    }

    public String getVertex(String id, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.VERTICES, id, doAsUser);
    }

    public String getVertices(String key, String value, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.VERTICES, key, value, doAsUser);
    }

    public String getVertexEdges(String id, String direction, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequestForEdges(MetadataOperations.VERTICES, id, direction, doAsUser);
    }

    public String getEdge(String id, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.EDGES, id, doAsUser);
    }

    public APIResult submitRecipe(String recipeName, String recipeToolClassName, String recipeOperation, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        String recipePath = this.clientProperties.getProperty("falcon.recipe.path");
        if (StringUtils.isEmpty((CharSequence)recipePath)) {
            throw new FalconCLIException("falcon.recipe.path is not set in client.properties");
        }
        String recipeFilePath = recipePath + File.separator + recipeName + TEMPLATE_SUFFIX;
        File file = new File(recipeFilePath);
        if (!file.exists()) {
            throw new FalconCLIException("Recipe template file does not exist : " + recipeFilePath);
        }
        String propertiesFilePath = recipePath + File.separator + recipeName + PROPERTIES_SUFFIX;
        file = new File(propertiesFilePath);
        if (!file.exists()) {
            throw new FalconCLIException("Recipe properties file does not exist : " + propertiesFilePath);
        }
        try {
            String prefix = "falcon-recipe-" + System.currentTimeMillis();
            File tmpPath = new File("/tmp");
            if (!tmpPath.exists() && !tmpPath.mkdir()) {
                throw new FalconCLIException("Creating directory failed: " + tmpPath.getAbsolutePath());
            }
            File f = File.createTempFile(prefix, ".xml", tmpPath);
            f.deleteOnExit();
            String processFile = f.getAbsolutePath();
            Object[] args = new String[]{"-" + RecipeToolArgs.RECIPE_FILE_ARG.getName(), recipeFilePath, "-" + RecipeToolArgs.RECIPE_PROPERTIES_FILE_ARG.getName(), propertiesFilePath, "-" + RecipeToolArgs.RECIPE_PROCESS_XML_FILE_PATH_ARG.getName(), processFile, "-" + RecipeToolArgs.RECIPE_OPERATION_ARG.getName(), recipeOperation};
            if (recipeToolClassName != null) {
                Class<?> clz = Class.forName(recipeToolClassName);
                Method method = clz.getMethod("main", String[].class);
                method.invoke(null, args);
            } else {
                RecipeTool.main((String[])args);
            }
            this.validate(EntityType.PROCESS.toString(), processFile, skipDryRun, doAsUser);
            return this.submitAndSchedule(EntityType.PROCESS.toString(), processFile, skipDryRun, doAsUser, null);
        }
        catch (Exception e) {
            throw new FalconCLIException(e.getMessage(), e);
        }
    }

    private String sendMetadataLineageRequest(MetadataOperations job, String id, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(job.path).path(id);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{job.mimeType})).type(job.mimeType)).method(job.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        return (String)clientResponse.getEntity(String.class);
    }

    private String sendMetadataLineageRequest(MetadataOperations job, String key, String value, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(job.path);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.queryParam("key", key).queryParam("value", value).header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{job.mimeType})).type(job.mimeType)).method(job.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        return (String)clientResponse.getEntity(String.class);
    }

    private String sendMetadataLineageRequestForEdges(MetadataOperations job, String id, String direction, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(job.path).path(id).path(direction);
        if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
            resource = resource.queryParam("doAs", doAsUser);
        }
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", (Object)(AUTH_COOKIE_EQ + this.authenticationToken)).accept(new String[]{job.mimeType})).type(job.mimeType)).method(job.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        return (String)clientResponse.getEntity(String.class);
    }

    private void checkIfSuccessful(ClientResponse clientResponse) throws FalconCLIException {
        Response.Status.Family statusFamily = clientResponse.getClientResponseStatus().getFamily();
        if (statusFamily != Response.Status.Family.SUCCESSFUL && statusFamily != Response.Status.Family.INFORMATIONAL) {
            throw FalconCLIException.fromReponse(clientResponse);
        }
    }

    private void printClientResponse(ClientResponse clientResponse) {
        if (this.getDebugMode()) {
            OUT.get().println(clientResponse.toString());
        }
    }

    protected static enum AdminOperations {
        STACK("api/admin/stack", "GET", "text/plain"),
        VERSION("api/admin/version", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private AdminOperations(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum Instances {
        RUNNING("api/instance/running/", "GET", "application/json"),
        STATUS("api/instance/status/", "GET", "application/json"),
        LIST("api/instance/list", "GET", "application/json"),
        KILL("api/instance/kill/", "POST", "application/json"),
        SUSPEND("api/instance/suspend/", "POST", "application/json"),
        RESUME("api/instance/resume/", "POST", "application/json"),
        RERUN("api/instance/rerun/", "POST", "application/json"),
        LOG("api/instance/logs/", "GET", "application/json"),
        SUMMARY("api/instance/summary/", "GET", "application/json"),
        PARAMS("api/instance/params/", "GET", "application/json"),
        DEPENDENCY("api/instance/dependencies/", "GET", "application/json"),
        TRIAGE("api/instance/triage/", "GET", "application/json"),
        LISTING("api/instance/listing/", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private Instances(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum MetadataOperations {
        LIST("api/metadata/discovery/", "GET", "application/json"),
        RELATIONS("api/metadata/discovery/", "GET", "application/json"),
        VERTICES("api/metadata/lineage/vertices", "GET", "application/json"),
        EDGES("api/metadata/lineage/edges", "GET", "application/json"),
        LINEAGE("api/metadata/lineage/entities", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private MetadataOperations(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum Entities {
        VALIDATE("api/entities/validate/", "POST", "text/xml"),
        SUBMIT("api/entities/submit/", "POST", "text/xml"),
        UPDATE("api/entities/update/", "POST", "text/xml"),
        SUBMITandSCHEDULE("api/entities/submitAndSchedule/", "POST", "text/xml"),
        SCHEDULE("api/entities/schedule/", "POST", "text/xml"),
        SUSPEND("api/entities/suspend/", "POST", "text/xml"),
        RESUME("api/entities/resume/", "POST", "text/xml"),
        DELETE("api/entities/delete/", "DELETE", "text/xml"),
        STATUS("api/entities/status/", "GET", "text/xml"),
        DEFINITION("api/entities/definition/", "GET", "text/xml"),
        LIST("api/entities/list/", "GET", "text/xml"),
        SUMMARY("api/entities/summary", "GET", "application/json"),
        LOOKUP("api/entities/lookup/", "GET", "application/json"),
        DEPENDENCY("api/entities/dependencies/", "GET", "text/xml"),
        SLA("api/entities/sla-alert", "GET", "application/json"),
        TOUCH("api/entities/touch", "POST", "text/xml");

        private String path;
        private String method;
        private String mimeType;

        private Entities(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }
}

