/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.falcon.cli.FalconCLI;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;

public class FalconRecipeCLI
extends FalconCLI {
    private static final String RECIPE_NAME = "name";
    private static final String RECIPE_OPERATION = "operation";
    private static final String RECIPE_TOOL_CLASS_NAME = "tool";

    public Options createRecipeOptions() {
        Options recipeOptions = new Options();
        Option url = new Option("url", true, "Falcon URL");
        recipeOptions.addOption(url);
        Option recipeFileOpt = new Option(RECIPE_NAME, true, "recipe name");
        recipeOptions.addOption(recipeFileOpt);
        Option recipeToolClassName = new Option(RECIPE_TOOL_CLASS_NAME, true, "recipe class");
        recipeOptions.addOption(recipeToolClassName);
        Option recipeOperation = new Option(RECIPE_OPERATION, true, "recipe operation");
        recipeOptions.addOption(recipeOperation);
        Option skipDryRunOperation = new Option("skipDryRun", false, "skip dryrun operation");
        recipeOptions.addOption(skipDryRunOperation);
        Option doAs = new Option("doAs", true, "doAs user");
        recipeOptions.addOption(doAs);
        return recipeOptions;
    }

    public void recipeCommand(CommandLine commandLine, FalconClient client) throws FalconCLIException {
        HashSet<String> optionsList = new HashSet<String>();
        for (Option option : commandLine.getOptions()) {
            optionsList.add(option.getOpt());
        }
        String recipeName = commandLine.getOptionValue(RECIPE_NAME);
        String recipeToolClass = commandLine.getOptionValue(RECIPE_TOOL_CLASS_NAME);
        String recipeOperation = commandLine.getOptionValue(RECIPE_OPERATION);
        String doAsUser = commandLine.getOptionValue("doAs");
        this.validateNotEmpty(recipeName, RECIPE_NAME);
        this.validateNotEmpty(recipeOperation, RECIPE_OPERATION);
        FalconRecipeCLI.validateRecipeOperations(recipeOperation);
        Boolean skipDryRun = null;
        if (optionsList.contains("skipDryRun")) {
            skipDryRun = true;
        }
        String result = client.submitRecipe(recipeName, recipeToolClass, recipeOperation, skipDryRun, doAsUser).toString();
        ((PrintStream)OUT.get()).println(result);
    }

    private static void validateRecipeOperations(String recipeOperation) throws FalconCLIException {
        for (FalconCLI.RecipeOperation operation : FalconCLI.RecipeOperation.values()) {
            if (!operation.toString().equalsIgnoreCase(recipeOperation)) continue;
            return;
        }
        throw new FalconCLIException("Allowed Recipe operations: " + Arrays.asList(FalconCLI.RecipeOperation.values()));
    }
}

