/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.falcon.LifeCycle;
import org.apache.falcon.ResponseHelper;
import org.apache.falcon.cli.FalconCLI;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;
import org.apache.falcon.resource.InstanceDependencyResult;

public class FalconInstanceCLI
extends FalconCLI {
    private static final String FORCE_RERUN_FLAG = "force";
    private static final String INSTANCE_TIME_OPT = "instanceTime";
    private static final String RUNNING_OPT = "running";
    private static final String KILL_OPT = "kill";
    private static final String RERUN_OPT = "rerun";
    private static final String LOG_OPT = "logs";
    private static final String RUNID_OPT = "runid";
    private static final String CLUSTERS_OPT = "clusters";
    private static final String SOURCECLUSTER_OPT = "sourceClusters";
    private static final String LIFECYCLE_OPT = "lifecycle";
    private static final String PARARMS_OPT = "params";
    private static final String LISTING_OPT = "listing";
    private static final String TRIAGE_OPT = "triage";

    public Options createInstanceOptions() {
        Options instanceOptions = new Options();
        Option running = new Option(RUNNING_OPT, false, "Gets running process instances for a given process");
        Option list = new Option("list", false, "Gets all instances for a given process in the range start time and optional end time");
        Option status = new Option("status", false, "Gets status of process instances for a given process in the range start time and optional end time");
        Option summary = new Option("summary", false, "Gets summary of instances for a given process in the range start time and optional end time");
        Option kill = new Option(KILL_OPT, false, "Kills active process instances for a given process in the range start time and optional end time");
        Option suspend = new Option("suspend", false, "Suspends active process instances for a given process in the range start time and optional end time");
        Option resume = new Option("resume", false, "Resumes suspended process instances for a given process in the range start time and optional end time");
        Option rerun = new Option(RERUN_OPT, false, "Reruns process instances for a given process in the range start time and optional end time and overrides properties present in job.properties file");
        Option logs = new Option(LOG_OPT, false, "Logs print the logs for process instances for a given process in the range start time and optional end time");
        Option params = new Option(PARARMS_OPT, false, "Displays the workflow parameters for a given instance of specified nominal timestart time represents nominal time and end time is not considered");
        Option listing = new Option(LISTING_OPT, false, "Displays feed listing and their status between a start and end time range.");
        Option dependency = new Option("dependency", false, "Displays dependent instances for a specified instance.");
        Option triage = new Option(TRIAGE_OPT, false, "Triage a feed or process instance and find the failures in it's lineage.");
        OptionGroup group = new OptionGroup();
        group.addOption(running);
        group.addOption(list);
        group.addOption(status);
        group.addOption(summary);
        group.addOption(kill);
        group.addOption(resume);
        group.addOption(suspend);
        group.addOption(resume);
        group.addOption(rerun);
        group.addOption(logs);
        group.addOption(params);
        group.addOption(listing);
        group.addOption(dependency);
        group.addOption(triage);
        Option url = new Option("url", true, "Falcon URL");
        Option start = new Option("start", true, "Start time is required for commands, status, kill, suspend, resume and re-runand it is nominal time while displaying workflow params");
        Option end = new Option("end", true, "End time is optional for commands, status, kill, suspend, resume and re-run; if not specified then current time is considered as end time");
        Option runid = new Option(RUNID_OPT, true, "Instance runid  is optional and user can specify the runid, defaults to 0");
        Option clusters = new Option(CLUSTERS_OPT, true, "clusters is optional for commands kill, suspend and resume, should not be specified for other commands");
        Option sourceClusters = new Option(SOURCECLUSTER_OPT, true, " source cluster is optional for commands kill, suspend and resume, should not be specified for other commands (required for only feed)");
        Option filePath = new Option("file", true, "Path to job.properties file is required for rerun command, it should contain name=value pair for properties to override for rerun");
        Option entityType = new Option("type", true, "Entity type, can be feed or process xml");
        Option entityName = new Option("name", true, "Entity name, can be feed or process name");
        Option colo = new Option("colo", true, "Colo on which the cmd has to be executed");
        Option lifecycle = new Option(LIFECYCLE_OPT, true, "describes life cycle of entity , for feed it can be replication/retention and for process it can be execution");
        Option filterBy = new Option("filterBy", true, "Filter returned instances by the specified fields");
        Option orderBy = new Option("orderBy", true, "Order returned instances by this field");
        Option sortOrder = new Option("sortOrder", true, "asc or desc order for results");
        Option offset = new Option("offset", true, "Start returning instances from this offset");
        Option numResults = new Option("numResults", true, "Number of results to return per request");
        Option forceRerun = new Option(FORCE_RERUN_FLAG, false, "Flag to forcefully rerun entire workflow of an instance");
        Option doAs = new Option("doAs", true, "doAs user");
        Option debug = new Option("debug", false, "Use debug mode to see debugging statements on stdout");
        Option instanceTime = new Option(INSTANCE_TIME_OPT, true, "Time for an instance");
        instanceOptions.addOption(url);
        instanceOptions.addOptionGroup(group);
        instanceOptions.addOption(start);
        instanceOptions.addOption(end);
        instanceOptions.addOption(filePath);
        instanceOptions.addOption(entityType);
        instanceOptions.addOption(entityName);
        instanceOptions.addOption(runid);
        instanceOptions.addOption(clusters);
        instanceOptions.addOption(sourceClusters);
        instanceOptions.addOption(colo);
        instanceOptions.addOption(lifecycle);
        instanceOptions.addOption(filterBy);
        instanceOptions.addOption(offset);
        instanceOptions.addOption(orderBy);
        instanceOptions.addOption(sortOrder);
        instanceOptions.addOption(numResults);
        instanceOptions.addOption(forceRerun);
        instanceOptions.addOption(doAs);
        instanceOptions.addOption(debug);
        instanceOptions.addOption(instanceTime);
        return instanceOptions;
    }

    public void instanceCommand(CommandLine commandLine, FalconClient client) throws FalconCLIException, IOException {
        String result;
        HashSet<String> optionsList = new HashSet<String>();
        for (Option option : commandLine.getOptions()) {
            optionsList.add(option.getOpt());
        }
        String type = commandLine.getOptionValue("type");
        String entity = commandLine.getOptionValue("name");
        String instanceTime = commandLine.getOptionValue(INSTANCE_TIME_OPT);
        String start = commandLine.getOptionValue("start");
        String end = commandLine.getOptionValue("end");
        String filePath = commandLine.getOptionValue("file");
        String runId = commandLine.getOptionValue(RUNID_OPT);
        String colo = commandLine.getOptionValue("colo");
        String clusters = commandLine.getOptionValue(CLUSTERS_OPT);
        String sourceClusters = commandLine.getOptionValue(SOURCECLUSTER_OPT);
        List<LifeCycle> lifeCycles = this.getLifeCycle(commandLine.getOptionValue(LIFECYCLE_OPT));
        String filterBy = commandLine.getOptionValue("filterBy");
        String orderBy = commandLine.getOptionValue("orderBy");
        String sortOrder = commandLine.getOptionValue("sortOrder");
        String doAsUser = commandLine.getOptionValue("doAs");
        Integer offset = this.parseIntegerInput(commandLine.getOptionValue("offset"), 0, "offset");
        Integer numResults = this.parseIntegerInput(commandLine.getOptionValue("numResults"), null, "numResults");
        colo = this.getColo(colo);
        String instanceAction = "instance";
        this.validateSortOrder(sortOrder);
        this.validateInstanceCommands(optionsList, entity, type, colo);
        if (optionsList.contains(TRIAGE_OPT)) {
            this.validateNotEmpty(colo, "colo");
            this.validateNotEmpty(start, "start");
            this.validateNotEmpty(type, "type");
            this.validateEntityTypeForSummary(type);
            this.validateNotEmpty(entity, "name");
            result = client.triage(type, entity, start, colo).toString();
        } else if (optionsList.contains("dependency")) {
            this.validateNotEmpty(instanceTime, INSTANCE_TIME_OPT);
            InstanceDependencyResult response = client.getInstanceDependencies(type, entity, instanceTime, colo);
            result = ResponseHelper.getString(response);
        } else if (optionsList.contains(RUNNING_OPT)) {
            this.validateOrderBy(orderBy, instanceAction);
            this.validateFilterBy(filterBy, instanceAction);
            result = ResponseHelper.getString(client.getRunningInstances(type, entity, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser));
        } else if (optionsList.contains("status") || optionsList.contains("list")) {
            this.validateOrderBy(orderBy, instanceAction);
            this.validateFilterBy(filterBy, instanceAction);
            result = ResponseHelper.getString(client.getStatusOfInstances(type, entity, start, end, colo, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser));
        } else if (optionsList.contains("summary")) {
            this.validateOrderBy(orderBy, "summary");
            this.validateFilterBy(filterBy, "summary");
            result = ResponseHelper.getString(client.getSummaryOfInstances(type, entity, start, end, colo, lifeCycles, filterBy, orderBy, sortOrder, doAsUser));
        } else if (optionsList.contains(KILL_OPT)) {
            this.validateNotEmpty(start, "start");
            this.validateNotEmpty(end, "end");
            result = ResponseHelper.getString(client.killInstances(type, entity, start, end, colo, clusters, sourceClusters, lifeCycles, doAsUser));
        } else if (optionsList.contains("suspend")) {
            this.validateNotEmpty(start, "start");
            this.validateNotEmpty(end, "end");
            result = ResponseHelper.getString(client.suspendInstances(type, entity, start, end, colo, clusters, sourceClusters, lifeCycles, doAsUser));
        } else if (optionsList.contains("resume")) {
            this.validateNotEmpty(start, "start");
            this.validateNotEmpty(end, "end");
            result = ResponseHelper.getString(client.resumeInstances(type, entity, start, end, colo, clusters, sourceClusters, lifeCycles, doAsUser));
        } else if (optionsList.contains(RERUN_OPT)) {
            this.validateNotEmpty(start, "start");
            this.validateNotEmpty(end, "end");
            boolean isForced = false;
            if (optionsList.contains(FORCE_RERUN_FLAG)) {
                isForced = true;
            }
            result = ResponseHelper.getString(client.rerunInstances(type, entity, start, end, filePath, colo, clusters, sourceClusters, lifeCycles, isForced, doAsUser));
        } else if (optionsList.contains(LOG_OPT)) {
            this.validateOrderBy(orderBy, instanceAction);
            this.validateFilterBy(filterBy, instanceAction);
            result = ResponseHelper.getString(client.getLogsOfInstances(type, entity, start, end, colo, runId, lifeCycles, filterBy, orderBy, sortOrder, offset, numResults, doAsUser), runId);
        } else if (optionsList.contains(PARARMS_OPT)) {
            result = ResponseHelper.getString(client.getParamsOfInstance(type, entity, start, colo, lifeCycles, doAsUser));
        } else if (optionsList.contains(LISTING_OPT)) {
            result = ResponseHelper.getString(client.getFeedListing(type, entity, start, end, colo, doAsUser));
        } else {
            throw new FalconCLIException("Invalid command");
        }
        ((PrintStream)OUT.get()).println(result);
    }

    private void validateInstanceCommands(Set<String> optionsList, String entity, String type, String colo) throws FalconCLIException {
        this.validateNotEmpty(entity, "name");
        this.validateNotEmpty(type, "type");
        this.validateNotEmpty(colo, "colo");
        if (optionsList.contains(CLUSTERS_OPT) && (optionsList.contains(RUNNING_OPT) || optionsList.contains(LOG_OPT) || optionsList.contains("status") || optionsList.contains("summary"))) {
            throw new FalconCLIException("Invalid argument: clusters");
        }
        if (optionsList.contains(SOURCECLUSTER_OPT) && (optionsList.contains(RUNNING_OPT) || optionsList.contains(LOG_OPT) || optionsList.contains("status") || optionsList.contains("summary") || !type.equals("feed"))) {
            throw new FalconCLIException("Invalid argument: sourceClusters");
        }
        if (optionsList.contains(FORCE_RERUN_FLAG) && !optionsList.contains(RERUN_OPT)) {
            throw new FalconCLIException("Force option can be used only with instance rerun");
        }
    }

    private List<LifeCycle> getLifeCycle(String lifeCycleValue) throws FalconCLIException {
        if (lifeCycleValue != null) {
            String[] lifeCycleValues = lifeCycleValue.split(",");
            ArrayList<LifeCycle> lifeCycles = new ArrayList<LifeCycle>();
            try {
                for (String lifeCycle : lifeCycleValues) {
                    lifeCycles.add(LifeCycle.valueOf(lifeCycle.toUpperCase().trim()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new FalconCLIException("Invalid life cycle values: " + lifeCycles, e);
            }
            return lifeCycles;
        }
        return null;
    }
}

