/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.ResponseHelper;
import org.apache.falcon.cli.FalconCLI;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.FeedLookupResult;
import org.apache.falcon.resource.SchedulableEntityInstanceResult;

public class FalconEntityCLI
extends FalconCLI {
    private static final String SUBMIT_OPT = "submit";
    private static final String UPDATE_OPT = "update";
    private static final String DELETE_OPT = "delete";
    private static final String SUBMIT_AND_SCHEDULE_OPT = "submitAndSchedule";
    private static final String VALIDATE_OPT = "validate";
    private static final String DEFINITION_OPT = "definition";
    public static final String SLA_MISS_ALERT_OPT = "slaAlert";
    private static final String LOOKUP_OPT = "lookup";
    private static final String PATH_OPT = "path";
    private static final String TOUCH_OPT = "touch";
    private static final String PROPS_OPT = "properties";
    private static final String FIELDS_OPT = "fields";
    private static final String TAGS_OPT = "tags";
    private static final String NUM_INSTANCES_OPT = "numInstances";
    private static final String NAMESEQ_OPT = "nameseq";
    private static final String TAGKEYS_OPT = "tagkeys";

    public Options createEntityOptions() {
        Options entityOptions = new Options();
        Option submit = new Option(SUBMIT_OPT, false, "Submits an entity xml to Falcon");
        Option update = new Option(UPDATE_OPT, false, "Updates an existing entity xml");
        Option schedule = new Option("schedule", false, "Schedules a submited entity in Falcon");
        Option suspend = new Option("suspend", false, "Suspends a running entity in Falcon");
        Option resume = new Option("resume", false, "Resumes a suspended entity in Falcon");
        Option delete = new Option(DELETE_OPT, false, "Deletes an entity in Falcon, and kills its instance from workflow engine");
        Option submitAndSchedule = new Option(SUBMIT_AND_SCHEDULE_OPT, false, "Submits and entity to Falcon and schedules it immediately");
        Option validate = new Option(VALIDATE_OPT, false, "Validates an entity based on the entity type");
        Option status = new Option("status", false, "Gets the status of entity");
        Option definition = new Option(DEFINITION_OPT, false, "Gets the Definition of entity");
        Option dependency = new Option("dependency", false, "Gets the dependencies of entity");
        Option list = new Option("list", false, "List entities registered for a type");
        Option lookup = new Option(LOOKUP_OPT, false, "Lookup a feed given its instance's path");
        Option slaAlert = new Option(SLA_MISS_ALERT_OPT, false, "Get missing feed instances which missed SLA");
        Option entitySummary = new Option("summary", false, "Get summary of instances for list of entities");
        Option touch = new Option(TOUCH_OPT, false, "Force update the entity in workflow engine(even without any changes to entity)");
        OptionGroup group = new OptionGroup();
        group.addOption(submit);
        group.addOption(update);
        group.addOption(schedule);
        group.addOption(suspend);
        group.addOption(resume);
        group.addOption(delete);
        group.addOption(submitAndSchedule);
        group.addOption(validate);
        group.addOption(status);
        group.addOption(definition);
        group.addOption(dependency);
        group.addOption(list);
        group.addOption(lookup);
        group.addOption(slaAlert);
        group.addOption(entitySummary);
        group.addOption(touch);
        Option url = new Option("url", true, "Falcon URL");
        Option entityType = new Option("type", true, "Entity type, can be cluster, feed or process xml");
        Option filePath = new Option("file", true, "Path to entity xml file");
        Option entityName = new Option("name", true, "Entity type, can be cluster, feed or process xml");
        Option start = new Option("start", true, "Start time is optional for summary");
        Option end = new Option("end", true, "End time is optional for summary");
        Option colo = new Option("colo", true, "Colo name");
        Option cluster = new Option("cluster", true, "Cluster name");
        colo.setRequired(false);
        Option fields = new Option(FIELDS_OPT, true, "Entity fields to show for a request");
        Option filterBy = new Option("filterBy", true, "Filter returned entities by the specified status");
        Option filterTags = new Option(TAGS_OPT, true, "Filter returned entities by the specified tags");
        Option nameSubsequence = new Option(NAMESEQ_OPT, true, "Subsequence of entity name");
        Option tagKeywords = new Option(TAGKEYS_OPT, true, "Keywords in tags");
        Option orderBy = new Option("orderBy", true, "Order returned entities by this field");
        Option sortOrder = new Option("sortOrder", true, "asc or desc order for results");
        Option offset = new Option("offset", true, "Start returning entities from this offset");
        Option numResults = new Option("numResults", true, "Number of results to return per request");
        Option numInstances = new Option(NUM_INSTANCES_OPT, true, "Number of instances to return per entity summary request");
        Option path = new Option(PATH_OPT, true, "Path for a feed's instance");
        Option skipDryRun = new Option("skipDryRun", false, "skip dry run in workflow engine");
        Option doAs = new Option("doAs", true, "doAs user");
        Option userProps = new Option(PROPS_OPT, true, "User supplied comma separated key value properties");
        Option debug = new Option("debug", false, "Use debug mode to see debugging statements on stdout");
        entityOptions.addOption(url);
        entityOptions.addOption(path);
        entityOptions.addOptionGroup(group);
        entityOptions.addOption(entityType);
        entityOptions.addOption(entityName);
        entityOptions.addOption(filePath);
        entityOptions.addOption(colo);
        entityOptions.addOption(cluster);
        entityOptions.addOption(start);
        entityOptions.addOption(end);
        entityOptions.addOption(fields);
        entityOptions.addOption(filterBy);
        entityOptions.addOption(filterTags);
        entityOptions.addOption(nameSubsequence);
        entityOptions.addOption(tagKeywords);
        entityOptions.addOption(orderBy);
        entityOptions.addOption(sortOrder);
        entityOptions.addOption(offset);
        entityOptions.addOption(numResults);
        entityOptions.addOption(numInstances);
        entityOptions.addOption(skipDryRun);
        entityOptions.addOption(doAs);
        entityOptions.addOption(userProps);
        entityOptions.addOption(debug);
        return entityOptions;
    }

    public void entityCommand(CommandLine commandLine, FalconClient client) throws FalconCLIException, IOException {
        HashSet<String> optionsList = new HashSet<String>();
        for (Option option : commandLine.getOptions()) {
            optionsList.add(option.getOpt());
        }
        String result = null;
        String entityType = commandLine.getOptionValue("type");
        String entityName = commandLine.getOptionValue("name");
        String filePath = commandLine.getOptionValue("file");
        String colo = commandLine.getOptionValue("colo");
        colo = this.getColo(colo);
        String cluster = commandLine.getOptionValue("cluster");
        String start = commandLine.getOptionValue("start");
        String end = commandLine.getOptionValue("end");
        String orderBy = commandLine.getOptionValue("orderBy");
        String sortOrder = commandLine.getOptionValue("sortOrder");
        String filterBy = commandLine.getOptionValue("filterBy");
        String filterTags = commandLine.getOptionValue(TAGS_OPT);
        String nameSubsequence = commandLine.getOptionValue(NAMESEQ_OPT);
        String tagKeywords = commandLine.getOptionValue(TAGKEYS_OPT);
        String fields = commandLine.getOptionValue(FIELDS_OPT);
        String feedInstancePath = commandLine.getOptionValue(PATH_OPT);
        Integer offset = this.parseIntegerInput(commandLine.getOptionValue("offset"), 0, "offset");
        Integer numResults = this.parseIntegerInput(commandLine.getOptionValue("numResults"), null, "numResults");
        String doAsUser = commandLine.getOptionValue("doAs");
        Integer numInstances = this.parseIntegerInput(commandLine.getOptionValue(NUM_INSTANCES_OPT), 7, NUM_INSTANCES_OPT);
        Boolean skipDryRun = null;
        if (optionsList.contains("skipDryRun")) {
            skipDryRun = true;
        }
        String userProps = commandLine.getOptionValue(PROPS_OPT);
        EntityType entityTypeEnum = null;
        if (optionsList.contains("list")) {
            if (entityType == null) {
                entityType = "";
            }
            if (StringUtils.isNotEmpty((CharSequence)entityType)) {
                String[] types;
                for (String type : types = entityType.split(",")) {
                    EntityType.getEnum(type);
                }
            }
        } else {
            this.validateNotEmpty(entityType, "type");
            entityTypeEnum = EntityType.getEnum(entityType);
        }
        this.validateSortOrder(sortOrder);
        String entityAction = "entity";
        if (optionsList.contains(SLA_MISS_ALERT_OPT)) {
            this.validateNotEmpty(entityType, "type");
            this.validateNotEmpty(start, "start");
            this.parseDateString(start);
            this.parseDateString(end);
            SchedulableEntityInstanceResult response = client.getFeedSlaMissPendingAlerts(entityType, entityName, start, end, colo);
            result = ResponseHelper.getString(response);
        } else if (optionsList.contains(SUBMIT_OPT)) {
            this.validateNotEmpty(filePath, "file");
            this.validateColo(optionsList);
            result = client.submit(entityType, filePath, doAsUser).getMessage();
        } else if (optionsList.contains(LOOKUP_OPT)) {
            this.validateNotEmpty(feedInstancePath, PATH_OPT);
            FeedLookupResult resp = client.reverseLookUp(entityType, feedInstancePath, doAsUser);
            result = ResponseHelper.getString(resp);
        } else if (optionsList.contains(UPDATE_OPT)) {
            this.validateNotEmpty(filePath, "file");
            this.validateColo(optionsList);
            this.validateNotEmpty(entityName, "name");
            result = client.update(entityType, entityName, filePath, skipDryRun, doAsUser).getMessage();
        } else if (optionsList.contains(SUBMIT_AND_SCHEDULE_OPT)) {
            this.validateNotEmpty(filePath, "file");
            this.validateColo(optionsList);
            result = client.submitAndSchedule(entityType, filePath, skipDryRun, doAsUser, userProps).getMessage();
        } else if (optionsList.contains(VALIDATE_OPT)) {
            this.validateNotEmpty(filePath, "file");
            this.validateColo(optionsList);
            result = client.validate(entityType, filePath, skipDryRun, doAsUser).getMessage();
        } else if (optionsList.contains("schedule")) {
            this.validateNotEmpty(entityName, "name");
            colo = this.getColo(colo);
            result = client.schedule(entityTypeEnum, entityName, colo, skipDryRun, doAsUser, userProps).getMessage();
        } else if (optionsList.contains("suspend")) {
            this.validateNotEmpty(entityName, "name");
            colo = this.getColo(colo);
            result = client.suspend(entityTypeEnum, entityName, colo, doAsUser).getMessage();
        } else if (optionsList.contains("resume")) {
            this.validateNotEmpty(entityName, "name");
            colo = this.getColo(colo);
            result = client.resume(entityTypeEnum, entityName, colo, doAsUser).getMessage();
        } else if (optionsList.contains(DELETE_OPT)) {
            this.validateColo(optionsList);
            this.validateNotEmpty(entityName, "name");
            result = client.delete(entityTypeEnum, entityName, doAsUser).getMessage();
        } else if (optionsList.contains("status")) {
            this.validateNotEmpty(entityName, "name");
            colo = this.getColo(colo);
            result = client.getStatus(entityTypeEnum, entityName, colo, doAsUser).getMessage();
        } else if (optionsList.contains(DEFINITION_OPT)) {
            this.validateColo(optionsList);
            this.validateNotEmpty(entityName, "name");
            result = client.getDefinition(entityType, entityName, doAsUser).toString();
        } else if (optionsList.contains("dependency")) {
            this.validateColo(optionsList);
            this.validateNotEmpty(entityName, "name");
            result = client.getDependency(entityType, entityName, doAsUser).toString();
        } else if (optionsList.contains("list")) {
            this.validateColo(optionsList);
            this.validateEntityFields(fields);
            this.validateOrderBy(orderBy, entityAction);
            this.validateFilterBy(filterBy, entityAction);
            EntityList entityList = client.getEntityList(entityType, fields, nameSubsequence, tagKeywords, filterBy, filterTags, orderBy, sortOrder, offset, numResults, doAsUser);
            result = entityList != null ? entityList.toString() : "No entity of type (" + entityType + ") found.";
        } else if (optionsList.contains("summary")) {
            this.validateEntityTypeForSummary(entityType);
            this.validateNotEmpty(cluster, "cluster");
            this.validateEntityFields(fields);
            this.validateFilterBy(filterBy, entityAction);
            this.validateOrderBy(orderBy, entityAction);
            result = ResponseHelper.getString(client.getEntitySummary(entityType, cluster, start, end, fields, filterBy, filterTags, orderBy, sortOrder, offset, numResults, numInstances, doAsUser));
        } else if (optionsList.contains(TOUCH_OPT)) {
            this.validateNotEmpty(entityName, "name");
            colo = this.getColo(colo);
            result = client.touch(entityType, entityName, colo, skipDryRun, doAsUser).getMessage();
        } else if (optionsList.contains("help")) {
            ((PrintStream)OUT.get()).println("Falcon Help");
        } else {
            throw new FalconCLIException("Invalid command");
        }
        ((PrintStream)OUT.get()).println(result);
    }

    private void validateColo(Set<String> optionsList) throws FalconCLIException {
        if (optionsList.contains("colo")) {
            throw new FalconCLIException("Invalid argument : colo");
        }
    }

    private void validateEntityFields(String fields) throws FalconCLIException {
        String[] fieldsList;
        if (StringUtils.isEmpty((CharSequence)fields)) {
            return;
        }
        for (String s : fieldsList = fields.split(",")) {
            try {
                EntityList.EntityFieldList.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException ie) {
                throw new FalconCLIException("Invalid fields argument : fields");
            }
        }
    }

    private Date parseDateString(String time) throws FalconCLIException {
        if (time != null && !time.isEmpty()) {
            try {
                return SchemaHelper.parseDateUTC(time);
            }
            catch (Exception e) {
                throw new FalconCLIException("Time " + time + " is not valid", e);
            }
        }
        return null;
    }
}

