/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.falcon.cli.FalconCLI;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;

public class FalconAdminCLI
extends FalconCLI {
    private static final String STACK_OPTION = "stack";

    public Options createAdminOptions() {
        Options adminOptions = new Options();
        Option url = new Option("url", true, "Falcon URL");
        adminOptions.addOption(url);
        OptionGroup group = new OptionGroup();
        Option status = new Option("status", false, "show the current system status");
        Option version = new Option("version", false, "show Falcon server build version");
        Option stack = new Option(STACK_OPTION, false, "show the thread stack dump");
        Option doAs = new Option("doAs", true, "doAs user");
        Option help = new Option("help", false, "show Falcon help");
        Option debug = new Option("debug", false, "Use debug mode to see debugging statements on stdout");
        group.addOption(status);
        group.addOption(version);
        group.addOption(stack);
        group.addOption(help);
        adminOptions.addOptionGroup(group);
        adminOptions.addOption(doAs);
        adminOptions.addOption(debug);
        return adminOptions;
    }

    public int adminCommand(CommandLine commandLine, FalconClient client, String falconUrl) throws FalconCLIException, IOException {
        int exitValue;
        block10: {
            String result;
            HashSet<String> optionsList = new HashSet<String>();
            for (Option option : commandLine.getOptions()) {
                optionsList.add(option.getOpt());
            }
            String doAsUser = commandLine.getOptionValue("doAs");
            if (optionsList.contains(STACK_OPTION)) {
                result = client.getThreadDump(doAsUser);
                ((PrintStream)OUT.get()).println(result);
            }
            exitValue = 0;
            if (optionsList.contains("status")) {
                try {
                    int status = client.getStatus(doAsUser);
                    if (status != 200) {
                        ((PrintStream)ERR.get()).println("Falcon server is not fully operational (on " + falconUrl + "). " + "Please check log files.");
                        exitValue = status;
                        break block10;
                    }
                    ((PrintStream)OUT.get()).println("Falcon server is running (on " + falconUrl + ")");
                }
                catch (Exception e) {
                    ((PrintStream)ERR.get()).println("Falcon server doesn't seem to be running on " + falconUrl);
                    exitValue = -1;
                }
            } else if (optionsList.contains("version")) {
                result = client.getVersion(doAsUser);
                ((PrintStream)OUT.get()).println("Falcon server build version: " + result);
            } else if (optionsList.contains("help")) {
                ((PrintStream)OUT.get()).println("Falcon Help");
            }
        }
        return exitValue;
    }
}

