/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaslCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslCallbackHandler.class);
    private static final MutableControl[] EMPTY = new MutableControl[0];
    private String username;
    private String realm;
    protected LdapSession ldapSession;
    protected CoreSession adminSession;
    protected final DirectoryService directoryService;
    protected final BindRequest bindRequest;

    protected AbstractSaslCallbackHandler(DirectoryService directoryService, BindRequest bindRequest) {
        this.directoryService = directoryService;
        this.bindRequest = bindRequest;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getRealm() {
        return this.realm;
    }

    protected abstract EntryAttribute lookupPassword(String var1, String var2);

    protected abstract void authorize(AuthorizeCallback var1) throws Exception;

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing callback {} of {}: {}" + callback.getClass(), (Object)(i + 1), (Object)callbacks.length);
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCB = (NameCallback)callback;
                LOG.debug("NameCallback default name:  {}", (Object)nameCB.getDefaultName());
                this.username = nameCB.getDefaultName();
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCB = (RealmCallback)callback;
                LOG.debug("RealmCallback default text:  {}", (Object)realmCB.getDefaultText());
                this.realm = realmCB.getDefaultText();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCB = (PasswordCallback)callback;
                EntryAttribute userPassword = this.lookupPassword(this.getUsername(), this.getRealm());
                if (userPassword == null) continue;
                byte[] password = (byte[])userPassword.get().get();
                String strPassword = StringTools.utf8ToString((byte[])password);
                passwordCB.setPassword(strPassword.toCharArray());
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            AuthorizeCallback authorizeCB = (AuthorizeCallback)callback;
            LOG.debug("AuthorizeCallback authnID:  {}", (Object)authorizeCB.getAuthenticationID());
            LOG.debug("AuthorizeCallback authzID:  {}", (Object)authorizeCB.getAuthorizationID());
            LOG.debug("AuthorizeCallback authorizedID:  {}", (Object)authorizeCB.getAuthorizedID());
            LOG.debug("AuthorizeCallback isAuthorized:  {}", (Object)authorizeCB.isAuthorized());
            try {
                this.authorize(authorizeCB);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed authorization in callback handler.", e);
            }
        }
    }

    protected LdapContext getContext(IoSession session, BindRequest bindRequest, Hashtable<String, Object> env) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        InitialLdapContext ctx = null;
        try {
            MutableControl[] connCtls = bindRequest.getControls().values().toArray(EMPTY);
            env.put(DirectoryService.JNDI_KEY, this.directoryService);
            ctx = new InitialLdapContext(env, (Control[])connCtls);
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)bindRequest.getResultResponse());
            ctx = null;
        }
        return ctx;
    }

    protected Hashtable<String, Object> getEnvironment(IoSession session) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", session.getAttribute("baseDn"));
        env.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", AuthenticationLevel.SIMPLE.toString());
        return env;
    }
}

