/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponseRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferralAwareRequestHandler<T extends ResultResponseRequest>
extends LdapRequestHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralAwareRequestHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    @Override
    public final void handle(LdapSession session, T req) throws Exception {
        LOG.debug("Handling single reply request: {}", req);
        LdapDN reqTargetDn = null;
        switch (req.getType()) {
            case ADD_REQUEST: {
                reqTargetDn = ((AddRequest)req).getEntryDn();
                break;
            }
            case BIND_REQUEST: {
                reqTargetDn = ((BindRequest)req).getName();
                break;
            }
            case COMPARE_REQUEST: {
                reqTargetDn = ((CompareRequest)req).getName();
                break;
            }
            case DEL_REQUEST: {
                reqTargetDn = ((DeleteRequest)req).getName();
                break;
            }
            case EXTENDED_REQ: {
                throw new IllegalStateException("Although ExtendedRequests are SingleReplyRequests they're not handled using this base class.  They have no target entry unlike the rest of the SingleReplyRequests");
            }
            case MOD_DN_REQUEST: {
                if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                    LOG.debug("ManageDsaITControl detected.");
                    this.handleIgnoringReferrals(session, ((ModifyDnRequest)req).getName(), null, req);
                } else {
                    LOG.debug("ManageDsaITControl NOT detected.");
                    if (((ModifyDnRequest)req).getNewSuperior() == null) {
                        this.handleWithReferrals(session, ((ModifyDnRequest)req).getName(), req);
                    } else {
                        this.handleModifyDnWithReferrals(session, req);
                    }
                }
                return;
            }
            case MODIFY_REQUEST: {
                reqTargetDn = ((ModifyRequest)req).getName();
                break;
            }
            case SEARCH_REQUEST: {
                reqTargetDn = ((SearchRequest)req).getBase();
                break;
            }
            default: {
                throw new IllegalStateException("Unidentified single reply request/response type: " + req);
            }
        }
        if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            LOG.debug("ManageDsaITControl detected.");
            this.handleIgnoringReferrals(session, reqTargetDn, null, req);
        } else {
            LOG.debug("ManageDsaITControl NOT detected.");
            this.handleWithReferrals(session, reqTargetDn, req);
        }
    }

    public static final boolean isEntryReferral(ClonedServerEntry entry) throws Exception {
        return entry.getOriginalEntry().contains("objectClass", new String[]{"referral"});
    }

    public static final ClonedServerEntry getFarthestReferralAncestor(LdapSession session, LdapDN target) throws Exception {
        ClonedServerEntry farthestReferralAncestor = null;
        LdapDN dn = (LdapDN)target.clone();
        try {
            dn.remove(dn.size() - 1);
        }
        catch (InvalidNameException e2) {
            // empty catch block
        }
        while (!dn.isEmpty()) {
            LOG.debug("Walking ancestors of {} to find referrals.", (Object)dn);
            try {
                ClonedServerEntry entry = session.getCoreSession().lookup(dn);
                if (ReferralAwareRequestHandler.isEntryReferral(entry)) {
                    farthestReferralAncestor = entry;
                }
                dn.remove(dn.size() - 1);
            }
            catch (NameNotFoundException e) {
                LOG.debug("Entry for {} not found.", (Object)dn);
                try {
                    dn.remove(dn.size() - 1);
                }
                catch (InvalidNameException e1) {}
            }
        }
        return farthestReferralAncestor;
    }

    private void handleModifyDnWithReferrals(LdapSession session, T modifyDnRequest) {
        ClonedServerEntry referralAncestor;
        ModifyDnRequest req = (ModifyDnRequest)modifyDnRequest;
        LdapResult result = req.getResultResponse().getLdapResult();
        ClonedServerEntry entry = null;
        ClonedServerEntry superiorEntry = null;
        try {
            entry = session.getCoreSession().lookup(req.getName());
            LOG.debug("Entry for {} was found: ", (Object)req.getName(), (Object)entry);
        }
        catch (NameNotFoundException e) {
            LOG.debug("Entry for {} not found.", (Object)req.getName());
        }
        catch (Exception e) {
            this.handleException(session, modifyDnRequest, e);
            return;
        }
        try {
            superiorEntry = session.getCoreSession().lookup(req.getNewSuperior());
            LOG.debug("New superior entry for {} was found: ", (Object)req.getName(), (Object)entry);
        }
        catch (NameNotFoundException e) {
            LOG.debug("New superior entry for {} not found.", (Object)req.getName());
        }
        catch (Exception e) {
            this.handleException(session, modifyDnRequest, e);
            return;
        }
        if (entry != null) {
            try {
                if (ReferralAwareRequestHandler.isEntryReferral(entry)) {
                    LOG.debug("Entry is a referral: {}", (Object)entry);
                    this.handleReferralEntry(session, req.getName(), modifyDnRequest, entry);
                    return;
                }
                if (superiorEntry != null && ReferralAwareRequestHandler.isEntryReferral(superiorEntry)) {
                    result.setErrorMessage("Superior entry is a referral.");
                    result.setMatchedDn(req.getNewSuperior());
                    result.setResultCode(ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                    session.getIoSession().write((Object)req.getResultResponse());
                    return;
                }
                if (superiorEntry == null) {
                    referralAncestor = ReferralAwareRequestHandler.getFarthestReferralAncestor(session, req.getNewSuperior());
                    if (referralAncestor != null) {
                        result.setErrorMessage("Superior entry does has referral ancestor.");
                        result.setResultCode(ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                        session.getIoSession().write((Object)req.getResultResponse());
                        return;
                    }
                    result.setErrorMessage("Superior entry does not exist.");
                    result.setResultCode(ResultCodeEnum.NO_SUCH_OBJECT);
                    session.getIoSession().write((Object)req.getResultResponse());
                    return;
                }
                LOG.debug("Entry is NOT a referral: {}", (Object)entry);
                this.handleIgnoringReferrals(session, req.getName(), entry, modifyDnRequest);
                return;
            }
            catch (Exception e) {
                this.handleException(session, modifyDnRequest, e);
            }
        }
        if (entry == null) {
            referralAncestor = null;
            try {
                referralAncestor = ReferralAwareRequestHandler.getFarthestReferralAncestor(session, req.getName());
            }
            catch (Exception e) {
                this.handleException(session, modifyDnRequest, e);
                return;
            }
            if (referralAncestor == null && !(req instanceof AddRequest)) {
                result.setErrorMessage("Entry not found.");
                result.setResultCode(ResultCodeEnum.NO_SUCH_OBJECT);
                session.getIoSession().write((Object)req.getResultResponse());
                return;
            }
            if (req instanceof AddRequest && referralAncestor == null) {
                this.handleIgnoringReferrals(session, req.getName(), entry, modifyDnRequest);
                return;
            }
            try {
                Referral referral = this.getReferralOnAncestor(session, req.getName(), modifyDnRequest, referralAncestor);
                result.setResultCode(ResultCodeEnum.REFERRAL);
                result.setReferral(referral);
                session.getIoSession().write((Object)req.getResultResponse());
            }
            catch (Exception e) {
                this.handleException(session, modifyDnRequest, e);
            }
        }
    }

    private void handleWithReferrals(LdapSession session, LdapDN reqTargetDn, T req) {
        LdapResult result = req.getResultResponse().getLdapResult();
        ClonedServerEntry entry = null;
        if (!(req instanceof AddRequest)) {
            try {
                entry = session.getCoreSession().lookup(reqTargetDn);
                LOG.debug("Entry for {} was found: ", (Object)reqTargetDn, (Object)entry);
            }
            catch (NameNotFoundException e) {
                LOG.debug("Entry for {} not found.", (Object)reqTargetDn);
            }
            catch (Exception e) {
                this.handleException(session, req, e);
                return;
            }
        }
        if (entry != null) {
            try {
                if (ReferralAwareRequestHandler.isEntryReferral(entry)) {
                    LOG.debug("Entry is a referral: {}", (Object)entry);
                    if (req instanceof SearchRequest) {
                        this.handleReferralEntryForSearch(session, (SearchRequest)req, entry);
                    } else {
                        this.handleReferralEntry(session, reqTargetDn, req, entry);
                    }
                    return;
                }
                LOG.debug("Entry is NOT a referral: {}", (Object)entry);
                this.handleIgnoringReferrals(session, reqTargetDn, entry, req);
                return;
            }
            catch (Exception e) {
                this.handleException(session, req, e);
            }
        }
        if (entry == null) {
            ClonedServerEntry referralAncestor = null;
            try {
                referralAncestor = ReferralAwareRequestHandler.getFarthestReferralAncestor(session, reqTargetDn);
            }
            catch (Exception e) {
                this.handleException(session, req, e);
                return;
            }
            if (referralAncestor == null && !(req instanceof AddRequest)) {
                result.setErrorMessage("Entry not found.");
                result.setResultCode(ResultCodeEnum.NO_SUCH_OBJECT);
                session.getIoSession().write((Object)req.getResultResponse());
                return;
            }
            if (req instanceof AddRequest && referralAncestor == null) {
                this.handleIgnoringReferrals(session, reqTargetDn, entry, req);
                return;
            }
            try {
                Referral referral = null;
                referral = req instanceof SearchRequest ? this.getReferralOnAncestorForSearch(session, (SearchRequest)req, referralAncestor) : this.getReferralOnAncestor(session, reqTargetDn, req, referralAncestor);
                result.setResultCode(ResultCodeEnum.REFERRAL);
                result.setReferral(referral);
                session.getIoSession().write((Object)req.getResultResponse());
            }
            catch (Exception e) {
                this.handleException(session, req, e);
            }
        }
    }

    private void handleReferralEntry(LdapSession session, LdapDN reqTargetDn, T req, ClonedServerEntry entry) {
        LdapResult result = req.getResultResponse().getLdapResult();
        ReferralImpl refs = new ReferralImpl();
        result.setReferral((Referral)refs);
        result.setResultCode(ResultCodeEnum.REFERRAL);
        result.setErrorMessage("Encountered referral attempting to handle request.");
        result.setMatchedDn(reqTargetDn);
        EntryAttribute refAttr = entry.getOriginalEntry().get("ref");
        for (Value refval : refAttr) {
            refs.addLdapUrl((String)refval.get());
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }

    private void handleReferralEntryForSearch(LdapSession session, SearchRequest req, ClonedServerEntry entry) throws Exception {
        LdapResult result = req.getResultResponse().getLdapResult();
        ReferralImpl referral = new ReferralImpl();
        result.setReferral((Referral)referral);
        result.setResultCode(ResultCodeEnum.REFERRAL);
        result.setErrorMessage("Encountered referral attempting to handle request.");
        result.setMatchedDn(req.getBase());
        EntryAttribute refAttr = entry.getOriginalEntry().get("ref");
        for (Value refval : refAttr) {
            String refstr = (String)refval.get();
            if (!refstr.startsWith("ldap")) {
                referral.addLdapUrl(refstr);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(refstr.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)refstr, (Object)entry);
                continue;
            }
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getJndiScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }

    public Referral getReferralOnAncestor(LdapSession session, LdapDN reqTargetDn, T req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        ServerAttribute refAttr = (ServerAttribute)referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = (String)value.get();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)ref, (Object)referralAncestor);
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().getUpName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            if (urlDn.getNormName().equals(referralAncestor.getDn().getNormName())) {
                StringBuilder buf = new StringBuilder();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                referral.addLdapUrl(buf.toString());
                continue;
            }
            int diff = reqTargetDn.size() - referralAncestor.getDn().size();
            LdapDN extra = new LdapDN();
            LdapDN reqUnnormalizedDn = new LdapDN(reqTargetDn.getUpName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            urlDn.addAll((Name)extra);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)urlDn.getUpName(), (boolean)false));
            referral.addLdapUrl(buf.toString());
        }
        return referral;
    }

    public Referral getReferralOnAncestorForSearch(LdapSession session, SearchRequest req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        ServerAttribute refAttr = (ServerAttribute)referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = (String)value.get();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)ref, (Object)referralAncestor);
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().getUpName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            if (urlDn.getNormName().equals(req.getBase().getNormName())) {
                ldapUrl.setForceScopeRendering(true);
                ldapUrl.setAttributes(req.getAttributes());
                ldapUrl.setScope(req.getScope().getJndiScope());
                referral.addLdapUrl(ldapUrl.toString());
                continue;
            }
            int diff = req.getBase().size() - referralAncestor.getDn().size();
            LdapDN extra = new LdapDN();
            LdapDN reqUnnormalizedDn = new LdapDN(req.getBase().getUpName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            ldapUrl.getDn().addAll((Name)extra);
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getJndiScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        return referral;
    }

    public void handleException(LdapSession session, T req, Exception e) {
        LdapResult result = req.getResultResponse().getLdapResult();
        ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + e.getMessage();
        LOG.error(msg, (Throwable)e);
        if (IS_DEBUG) {
            msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        result.setErrorMessage(msg);
        if (e instanceof NamingException) {
            boolean setMatchedDn;
            NamingException ne = (NamingException)e;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedName() != null && setMatchedDn) {
                result.setMatchedDn((LdapDN)ne.getResolvedName());
            }
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }

    public abstract void handleIgnoringReferrals(LdapSession var1, LdapDN var2, ClonedServerEntry var3, T var4);
}

