/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.xml;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static Cipher initCipherWithCert(String keyEncAlgo, int mode, X509Certificate cert) throws WSSecurityException {
        Cipher cipher = WSSecurityUtil.getCipherInstance((String)keyEncAlgo);
        try {
            cipher.init(mode, cert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(9, null, null, (Throwable)e);
        }
        return cipher;
    }

    public static Cipher initCipherWithKey(String keyEncAlgo, int mode, Key key) throws WSSecurityException {
        Cipher cipher = WSSecurityUtil.getCipherInstance((String)keyEncAlgo);
        try {
            cipher.init(mode, key);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(9, null, null, (Throwable)e);
        }
        return cipher;
    }

    public static XMLCipher initXMLCipher(String symEncAlgo, int mode, Key key) throws WSSecurityException {
        try {
            XMLCipher cipher = XMLCipher.getInstance((String)symEncAlgo);
            cipher.init(mode, key);
            return cipher;
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, (Throwable)ex);
        }
    }
}

