/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import java.util.Date;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;

public final class JwtUtils {
    private JwtUtils() {
    }

    public static String claimsToJson(JwtClaims claims) {
        return JwtUtils.claimsToJson(claims, null);
    }

    public static String claimsToJson(JwtClaims claims, JwtTokenReaderWriter writer) {
        if (writer == null) {
            writer = new JwtTokenReaderWriter();
        }
        return writer.claimsToJson(claims);
    }

    public static JwtClaims jsonToClaims(String json) {
        return new JwtTokenReaderWriter().fromJsonClaims(json);
    }

    public static void validateJwtExpiry(JwtClaims claims, int clockOffset, boolean claimRequired) {
        Long expiryTime = claims.getExpiryTime();
        if (expiryTime == null) {
            if (claimRequired) {
                throw new JwtException("The token has expired");
            }
            return;
        }
        Date rightNow = new Date();
        Date expiresDate = new Date(expiryTime * 1000L);
        if (clockOffset != 0) {
            expiresDate.setTime(expiresDate.getTime() + (long)clockOffset * 1000L);
        }
        if (expiresDate.before(rightNow)) {
            throw new JwtException("The token has expired");
        }
    }

    public static void validateJwtNotBefore(JwtClaims claims, int clockOffset, boolean claimRequired) {
        Date notBeforeDate;
        Long notBeforeTime = claims.getNotBefore();
        if (notBeforeTime == null) {
            if (claimRequired) {
                throw new JwtException("The token cannot be accepted yet");
            }
            return;
        }
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (clockOffset != 0) {
            validCreation.setTime(currentTime + (long)clockOffset * 1000L);
        }
        if ((notBeforeDate = new Date(notBeforeTime * 1000L)).after(validCreation)) {
            throw new JwtException("The token cannot be accepted yet");
        }
    }

    public static void validateJwtIssuedAt(JwtClaims claims, int timeToLive, int clockOffset, boolean claimRequired) {
        Long issuedAtInSecs = claims.getIssuedAt();
        if (issuedAtInSecs == null) {
            if (claimRequired) {
                throw new JwtException("Invalid issuedAt");
            }
            return;
        }
        Date createdDate = new Date(issuedAtInSecs * 1000L);
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (clockOffset > 0) {
            validCreation.setTime(currentTime + (long)clockOffset * 1000L);
        }
        if (createdDate.after(validCreation)) {
            throw new JwtException("Invalid issuedAt");
        }
        if (timeToLive > 0) {
            validCreation.setTime(currentTime -= (long)timeToLive * 1000L);
            if (createdDate.before(validCreation)) {
                throw new JwtException("Invalid issuedAt");
            }
        }
    }

    public static void validateJwtTimeClaims(JwtClaims claims, int clockOffset, int issuedAtRange, boolean claimsRequired) {
        Long currentTimeInSecs = System.currentTimeMillis() / 1000L;
        Long expiryTimeInSecs = claims.getExpiryTime();
        if (expiryTimeInSecs == null && claimsRequired || expiryTimeInSecs != null && currentTimeInSecs > expiryTimeInSecs) {
            throw new JwtException("The token expired");
        }
        Long issuedAtInSecs = claims.getIssuedAt();
        if (clockOffset <= 0) {
            clockOffset = 0;
        }
        if (issuedAtInSecs == null && claimsRequired || issuedAtInSecs != null && (issuedAtInSecs - (long)clockOffset > currentTimeInSecs || issuedAtRange > 0 && issuedAtInSecs < currentTimeInSecs - (long)issuedAtRange)) {
            throw new JwtException("Invalid issuedAt");
        }
    }

    public static void validateJwtTimeClaims(JwtClaims claims) {
        JwtUtils.validateJwtTimeClaims(claims, 0, 0, false);
    }

    public static void validateJwtAudienceRestriction(JwtClaims claims, Message message) {
        String requestURL = null;
        if (message.getContextualProperty("org.apache.cxf.request.url") != null) {
            requestURL = (String)message.getContextualProperty("org.apache.cxf.request.url");
        }
        if (requestURL != null) {
            boolean match = false;
            for (String audience : claims.getAudiences()) {
                if (!requestURL.equals(audience)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new JwtException("Invalid audience restriction");
            }
        }
    }

    public static void validateTokenClaims(JwtClaims claims, int timeToLive, int clockOffset, boolean validateAudienceRestriction) {
        boolean expiredRequired = claims.getIssuedAt() == null;
        JwtUtils.validateJwtExpiry(claims, clockOffset, expiredRequired);
        JwtUtils.validateJwtNotBefore(claims, clockOffset, false);
        boolean issuedAtRequired = claims.getExpiryTime() == null;
        JwtUtils.validateJwtIssuedAt(claims, timeToLive, clockOffset, issuedAtRequired);
        if (validateAudienceRestriction) {
            JwtUtils.validateJwtAudienceRestriction(claims, PhaseInterceptorChain.getCurrentMessage());
        }
    }
}

