/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public abstract class AbstractContentEncryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentEncryptionProvider {
    private static final int DEFAULT_IV_SIZE = 128;
    private byte[] cek;
    private byte[] iv;
    private AtomicInteger providedIvUsageCount;

    protected AbstractContentEncryptionAlgorithm(byte[] cek, byte[] iv, ContentAlgorithm algo) {
        super(algo);
        this.cek = cek;
        this.iv = iv;
        if (iv != null && iv.length > 0) {
            this.providedIvUsageCount = new AtomicInteger();
        }
    }

    @Override
    public byte[] getContentEncryptionKey(JweHeaders headers) {
        return this.cek;
    }

    @Override
    public byte[] getInitVector() {
        if (this.iv == null) {
            return CryptoUtils.generateSecureRandomBytes((int)(this.getIvSize() / 8));
        }
        if (this.iv.length > 0 && this.providedIvUsageCount.addAndGet(1) > 1) {
            LOG.warning("Custom IV is recommeded to be used once");
            throw new JweException(JweException.Error.CUSTOM_IV_REUSED);
        }
        return this.iv;
    }

    protected int getIvSize() {
        return 128;
    }
}

