/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerRequestResourceProvider
implements ResourceProvider {
    private Constructor<?> c;

    public PerRequestResourceProvider(Class<?> clazz) {
        this.c = ResourceUtils.findResourceConstructor(clazz, true);
        if (this.c == null) {
            throw new RuntimeException("Resource class " + clazz + " has no valid constructor");
        }
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object getInstance(Message m) {
        return this.createInstance(m);
    }

    @Override
    public Object getInstance() {
        if (this.c.getParameterTypes().length > 0) {
            throw new RuntimeException("Resource class constructor has context parameters but no request message is available");
        }
        return this.createInstance(null);
    }

    protected Object createInstance(Message m) {
        String msg;
        Class<?>[] params = this.c.getParameterTypes();
        Annotation[][] anns = this.c.getParameterAnnotations();
        Type[] genericTypes = this.c.getGenericParameterTypes();
        MultivaluedMap templateValues = (MultivaluedMap)m.get((Object)"jaxrs.template.parameters");
        Object[] values = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (AnnotationUtils.isContextClass(params[i])) {
                values[i] = JAXRSUtils.createContextValue(m, genericTypes[i], params[i]);
                continue;
            }
            Parameter p = ResourceUtils.getParameter(i, anns[i]);
            values[i] = JAXRSUtils.createHttpParameterValue(p, params[i], genericTypes[i], m, (MultivaluedMap<String, String>)templateValues, null);
        }
        try {
            return params.length > 0 ? this.c.newInstance(values) : this.c.newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
        catch (IllegalAccessException ex) {
            msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to IllegalAccessException";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
        catch (InvocationTargetException ex) {
            msg = "Resource class " + this.c.getDeclaringClass().getName() + " can not be instantiated" + " due to InvocationTargetException";
            throw new WebApplicationException(Response.serverError().entity((Object)msg).build());
        }
    }
}

