/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.wadl.WadlGenerator;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPreprocessor {
    private static final String ACCEPT_QUERY = "_type";
    private static final String METHOD_QUERY = "_method";
    private static final String METHOD_HEADER = "X-HTTP-Method-Override";
    private static final Map<String, String> SHORTCUTS = new HashMap<String, String>();
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;

    public RequestPreprocessor() {
        this(null, null);
    }

    public RequestPreprocessor(Map<Object, Object> languageMappings, Map<Object, Object> extensionMappings) {
        this.languageMappings = languageMappings == null ? Collections.emptyMap() : languageMappings;
        this.extensionMappings = extensionMappings == null ? Collections.emptyMap() : extensionMappings;
    }

    public String preprocess(Message m, UriInfo u) {
        this.handleExtensionMappings(m, u);
        this.handleLanguageMappings(m, u);
        MultivaluedMap queries = u.getQueryParameters();
        this.handleTypeQuery(m, (MultivaluedMap<String, String>)queries);
        this.handleMethod(m, (MultivaluedMap<String, String>)queries, new HttpHeadersImpl(m));
        this.checkMetadataRequest(m);
        return new UriInfoImpl(m, null).getPath();
    }

    private void handleLanguageMappings(Message m, UriInfo uriInfo) {
        String path = uriInfo.getPath(false);
        for (Map.Entry<Object, Object> entry : this.languageMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey())) continue;
            this.updateAcceptLanguageHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString());
            break;
        }
    }

    private void handleExtensionMappings(Message m, UriInfo uriInfo) {
        String path = uriInfo.getPath(false);
        for (Map.Entry<Object, Object> entry : this.extensionMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey().toString())) continue;
            this.updateAcceptTypeHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString());
            break;
        }
    }

    private void updateAcceptLanguageHeader(Message m, String anotherValue) {
        ArrayList<String> acceptLanguage = (ArrayList<String>)((Map)m.get((Object)Message.PROTOCOL_HEADERS)).get("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = new ArrayList<String>();
        }
        acceptLanguage.add(anotherValue);
        ((Map)m.get((Object)Message.PROTOCOL_HEADERS)).put("Accept-Language", acceptLanguage);
    }

    private void updatePath(Message m, String path, String suffix) {
        String newPath = path.substring(0, path.length() - (suffix.length() + 1));
        HttpUtils.updatePath(m, newPath);
    }

    private void handleMethod(Message m, MultivaluedMap<String, String> queries, HttpHeaders headers) {
        List values;
        String method = (String)queries.getFirst((Object)METHOD_QUERY);
        if (method == null && (values = headers.getRequestHeader(METHOD_HEADER)).size() == 1) {
            method = (String)values.get(0);
        }
        if (method != null) {
            m.put((Object)Message.HTTP_REQUEST_METHOD, (Object)method);
        }
    }

    private void handleTypeQuery(Message m, MultivaluedMap<String, String> queries) {
        String type = (String)queries.getFirst((Object)ACCEPT_QUERY);
        if (type != null) {
            if (SHORTCUTS.containsKey(type)) {
                type = SHORTCUTS.get(type);
            }
            this.updateAcceptTypeHeader(m, type);
        }
    }

    private void updateAcceptTypeHeader(Message m, String acceptValue) {
        m.put((Object)"Accept", (Object)acceptValue);
        ((Map)m.get((Object)Message.PROTOCOL_HEADERS)).put("Accept", Collections.singletonList(acceptValue));
    }

    public void checkMetadataRequest(Message m) {
        String query = (String)m.get((Object)Message.QUERY_STRING);
        if (query != null && query.contains("_wadl")) {
            Response r;
            String requestURI = (String)m.get((Object)Message.REQUEST_URI);
            String baseAddress = HttpUtils.getBaseAddress(m);
            if (baseAddress.equals(requestURI) && (r = new WadlGenerator().handleRequest(m, null)) != null) {
                m.getExchange().put(Response.class, (Object)r);
            }
        }
    }

    static {
        SHORTCUTS.put("json", "application/json");
        SHORTCUTS.put("text", "text/*");
        SHORTCUTS.put("xml", "application/xml");
    }
}

