/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;

public class Servlet3ContinuationProvider
implements ContinuationProvider {
    HttpServletRequest req;
    HttpServletResponse resp;
    Message inMessage;
    Servlet3Continuation continuation;

    public Servlet3ContinuationProvider(HttpServletRequest req, HttpServletResponse resp, Message inMessage) {
        this.inMessage = inMessage;
        this.req = req;
        this.resp = resp;
    }

    @Override
    public Continuation getContinuation() {
        if (this.inMessage.getExchange().isOneWay()) {
            return null;
        }
        if (this.continuation == null) {
            this.continuation = new Servlet3Continuation();
        } else {
            this.continuation.startAsyncAgain();
        }
        return this.continuation;
    }

    public class Servlet3Continuation
    implements Continuation,
    AsyncListener {
        AsyncContext context;
        volatile boolean isNew = true;
        volatile boolean isResumed;
        volatile boolean isPending;
        volatile Object obj;
        private ContinuationCallback callback;

        public Servlet3Continuation() {
            Servlet3ContinuationProvider.this.req.setAttribute("cxf.continuation.message", (Object)Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage());
            this.callback = Servlet3ContinuationProvider.this.inMessage.getExchange().get(ContinuationCallback.class);
            this.context = Servlet3ContinuationProvider.this.req.startAsync((ServletRequest)Servlet3ContinuationProvider.this.req, (ServletResponse)Servlet3ContinuationProvider.this.resp);
            this.context.addListener((AsyncListener)this);
        }

        void startAsyncAgain() {
            AsyncContext old = this.context;
            try {
                this.context = Servlet3ContinuationProvider.this.req.startAsync();
            }
            catch (IllegalStateException ex) {
                this.context = old;
            }
            this.context.addListener((AsyncListener)this);
        }

        @Override
        public boolean suspend(long timeout) {
            if (this.isPending && timeout != 0L) {
                long currentTimeout = this.context.getTimeout();
                timeout = currentTimeout + timeout;
            } else {
                this.isPending = true;
            }
            this.isNew = false;
            this.context.setTimeout(timeout);
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().getInterceptorChain().suspend();
            return true;
        }

        public void redispatch() {
            this.context.dispatch();
        }

        @Override
        public void resume() {
            this.isResumed = true;
            this.isPending = false;
            this.redispatch();
        }

        @Override
        public void reset() {
            this.context.complete();
            this.obj = null;
        }

        @Override
        public boolean isNew() {
            return this.isNew;
        }

        @Override
        public boolean isPending() {
            return this.isPending;
        }

        @Override
        public boolean isResumed() {
            return this.isResumed;
        }

        @Override
        public Object getObject() {
            return this.obj;
        }

        @Override
        public void setObject(Object o) {
            this.obj = o;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().remove("cxf.continuation.message");
            this.isPending = false;
            if (this.callback != null) {
                this.callback.onComplete();
            }
        }

        public void onError(AsyncEvent event) throws IOException {
            if (this.callback != null) {
                this.callback.onError(event.getThrowable());
            }
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.isPending = false;
            this.redispatch();
        }
    }
}

