/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.jaxb.JAXBBeanInfo;
import org.apache.cxf.common.jaxb.JAXBContextProxy;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XmlSchemaPrimitiveUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.cxf.jaxrs.model.wadl.ElementQNameResolver;
import org.apache.cxf.jaxrs.model.wadl.XMLName;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WadlGenerator
implements RequestHandler {
    public static final String WADL_QUERY = "_wadl";
    public static final MediaType WADL_TYPE = JAXRSUtils.toMediaType("application/vnd.sun.wadl+xml");
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.APPLICATION_XML_TYPE;
    private static final Logger LOG = LogUtils.getL7dLogger(WadlGenerator.class);
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String DEFAULT_NS_PREFIX = "prefix";
    private String wadlNamespace;
    private boolean ignoreMessageWriters = true;
    private boolean singleResourceMultipleMethods = true;
    private boolean useSingleSlashResource;
    private boolean ignoreForwardSlash;
    private boolean addResourceAndMethodIds;
    private boolean ignoreRequests;
    private boolean linkJsonToXmlSchema;
    private boolean useJaxbContextForQnames = true;
    private boolean supportCollections = true;
    private List<String> externalSchemasCache;
    private List<URI> externalSchemaLinks;
    private Map<String, List<String>> externalQnamesMap;
    private ConcurrentHashMap<String, String> docLocationMap = new ConcurrentHashMap();
    private ElementQNameResolver resolver;
    private List<String> privateAddresses;
    private String applicationTitle;
    private String nsPrefix = "prefix";
    private MediaType defaultMediaType = DEFAULT_MEDIA_TYPE;

    public WadlGenerator() {
    }

    public WadlGenerator(WadlGenerator other) {
        this.wadlNamespace = other.wadlNamespace;
        this.externalQnamesMap = other.externalQnamesMap;
        this.externalSchemaLinks = other.externalSchemaLinks;
        this.externalSchemasCache = other.externalSchemasCache;
        this.ignoreMessageWriters = other.ignoreMessageWriters;
        this.privateAddresses = other.privateAddresses;
        this.resolver = other.resolver;
        this.addResourceAndMethodIds = other.addResourceAndMethodIds;
        this.singleResourceMultipleMethods = other.singleResourceMultipleMethods;
        this.useJaxbContextForQnames = other.useJaxbContextForQnames;
        this.useSingleSlashResource = other.useSingleSlashResource;
    }

    @Override
    public Response handleRequest(Message m, ClassResourceInfo resource) {
        if (!"GET".equals(m.get("org.apache.cxf.request.method"))) {
            return null;
        }
        UriInfoImpl ui = new UriInfoImpl(m);
        if (!ui.getQueryParameters().containsKey((Object)WADL_QUERY)) {
            if (!this.docLocationMap.isEmpty()) {
                String path = ui.getPath(false);
                if (path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (this.docLocationMap.containsKey(path)) {
                    return this.getExistingResource(m, ui, path);
                }
            }
            return null;
        }
        if (this.ignoreRequests) {
            return Response.status((int)404).build();
        }
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        List accepts = headers.getAcceptableMediaTypes();
        MediaType type = accepts.contains(WADL_TYPE) ? WADL_TYPE : (accepts.contains(MediaType.APPLICATION_JSON_TYPE) ? MediaType.APPLICATION_JSON_TYPE : this.defaultMediaType);
        Response response = this.getExistingWadl(m, ui, type);
        if (response != null) {
            return response;
        }
        boolean isJson = type == MediaType.APPLICATION_JSON_TYPE;
        StringBuilder sbMain = new StringBuilder();
        sbMain.append("<application");
        if (!isJson) {
            sbMain.append(" xmlns=\"").append(this.getNamespace()).append("\" xmlns:xs=\"").append("http://www.w3.org/2001/XMLSchema").append("\"");
        }
        StringBuilder sbGrammars = new StringBuilder();
        sbGrammars.append("<grammars>");
        StringBuilder sbResources = new StringBuilder();
        sbResources.append("<resources base=\"").append(this.getBaseURI(m, ui)).append("\">");
        List<ClassResourceInfo> cris = this.getResourcesList(m, resource);
        ResourceTypes resourceTypes = ResourceUtils.getAllRequestResponseTypes(cris, this.useJaxbContextForQnames);
        Set<Class<?>> allTypes = resourceTypes.getAllTypes().keySet();
        JAXBContext jaxbContext = this.useJaxbContextForQnames ? ResourceUtils.createJaxbContext(new HashSet(allTypes), null, null) : null;
        SchemaWriter schemaWriter = this.createSchemaWriter(resourceTypes, jaxbContext, ui);
        ElementQNameResolver qnameResolver = schemaWriter == null ? null : this.createElementQNameResolver(jaxbContext);
        IdentityHashMap clsMap = new IdentityHashMap();
        LinkedHashSet<ClassResourceInfo> visitedResources = new LinkedHashSet<ClassResourceInfo>();
        for (ClassResourceInfo cri : cris) {
            Description ann;
            this.startResourceTag(sbResources, cri.getServiceClass(), cri.getURITemplate().getValue());
            Annotation[] anns = cri.getServiceClass().getAnnotations();
            if (anns.length == 0 && (ann = AnnotationUtils.getClassAnnotation(cri.getServiceClass(), Description.class)) != null) {
                anns = new Annotation[]{ann};
            }
            this.handleDocs(anns, sbResources, "resource", true, isJson);
            this.handleResource(sbResources, allTypes, qnameResolver, clsMap, cri, visitedResources, isJson);
            sbResources.append("</resource>");
        }
        sbResources.append("</resources>");
        this.handleGrammars(sbMain, sbGrammars, schemaWriter, clsMap);
        sbGrammars.append("</grammars>");
        sbMain.append(">");
        this.handleApplicationDocs(sbMain);
        sbMain.append(sbGrammars.toString());
        sbMain.append(sbResources.toString());
        sbMain.append("</application>");
        m.getExchange().put("ignore.message.writers", this.ignoreMessageWriters);
        return Response.ok().type(type).entity(this.createResponseEntity(sbMain.toString(), isJson)).build();
    }

    private Object createResponseEntity(String entity, boolean isJson) {
        if (!isJson) {
            return entity;
        }
        try {
            return StaxUtils.read(new StringReader(entity));
        }
        catch (Exception ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    private String getBaseURI(Message m, UriInfo ui) {
        EndpointInfo ei = m.getExchange().get(Endpoint.class).getEndpointInfo();
        String publishedEndpointUrl = (String)ei.getProperty("publishedEndpointUrl");
        if (publishedEndpointUrl == null) {
            return ui.getBaseUri().toString();
        }
        return publishedEndpointUrl;
    }

    protected void handleGrammars(StringBuilder sbApp, StringBuilder sbGrammars, SchemaWriter writer, Map<Class<?>, QName> clsMap) {
        if (writer == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (QName qName : clsMap.values()) {
            map.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        for (Map.Entry entry : map.entrySet()) {
            sbApp.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        writer.write(sbGrammars);
    }

    protected void handleResource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, ClassResourceInfo cri, Set<ClassResourceInfo> visitedResources, boolean isJson) {
        visitedResources.add(cri);
        Map<Parameter, Object> classParams = this.getClassParameters(cri);
        List<OperationResourceInfo> sortedOps = this.sortOperationsByPath(cri.getMethodDispatcher().getOperationResourceInfos());
        boolean resourceTagOpened = false;
        for (int i = 0; i < sortedOps.size(); ++i) {
            OperationResourceInfo ori = sortedOps.get(i);
            if (ori.getHttpMethod() == null) {
                Class<?> cls = this.getMethod(ori).getReturnType();
                ClassResourceInfo subcri = cri.findResource(cls, cls);
                if (subcri != null && !visitedResources.contains(subcri)) {
                    this.startResourceTag(sb, subcri.getServiceClass(), ori.getURITemplate().getValue());
                    this.handleDocs(subcri.getServiceClass().getAnnotations(), sb, "resource", true, isJson);
                    this.handlePathAndMatrixParams(sb, ori, isJson);
                    this.handleResource(sb, jaxbTypes, qnameResolver, clsMap, subcri, visitedResources, isJson);
                    sb.append("</resource>");
                    continue;
                }
                this.handleDynamicSubresource(sb, jaxbTypes, qnameResolver, clsMap, ori, subcri, isJson);
                continue;
            }
            OperationResourceInfo nextOp = i + 1 < sortedOps.size() ? sortedOps.get(i + 1) : null;
            resourceTagOpened = this.handleOperation(sb, jaxbTypes, qnameResolver, clsMap, ori, classParams, nextOp, resourceTagOpened, isJson, i);
        }
    }

    private Map<Parameter, Object> getClassParameters(ClassResourceInfo cri) {
        LinkedHashMap<Parameter, Object> classParams = new LinkedHashMap<Parameter, Object>();
        List<Method> paramMethods = cri.getParameterMethods();
        for (Method m : paramMethods) {
            classParams.put(ResourceUtils.getParameter(0, m.getAnnotations(), m.getParameterTypes()[0]), m);
        }
        List<Field> fieldParams = cri.getParameterFields();
        for (Field f : fieldParams) {
            classParams.put(ResourceUtils.getParameter(0, f.getAnnotations(), f.getType()), f);
        }
        return classParams;
    }

    private void startResourceTag(StringBuilder sb, Class<?> serviceClass, String path) {
        sb.append("<resource path=\"").append(this.getPath(path)).append("\"");
        if (this.addResourceAndMethodIds) {
            QName jaxbQname = null;
            if (this.useJaxbContextForQnames) {
                jaxbQname = this.getJaxbQName(null, serviceClass, new HashMap(0));
            }
            String pName = jaxbQname == null ? PackageUtils.getPackageName(serviceClass) : jaxbQname.getNamespaceURI();
            String localName = jaxbQname == null ? serviceClass.getSimpleName() : jaxbQname.getLocalPart();
            String finalName = jaxbQname == null ? pName + "." : "{" + pName + "}";
            sb.append(" id=\"").append(finalName + localName).append("\"");
        }
        sb.append(">");
    }

    protected String getPath(String path) {
        String thePath = null;
        thePath = this.ignoreForwardSlash && path.startsWith("/") && path.length() > 0 ? path.substring(1) : path;
        return this.xmlEncodeIfNeeded(thePath);
    }

    private String xmlEncodeIfNeeded(String value) {
        return XMLUtils.xmlEncode(value);
    }

    private void startMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("<method name=\"").append(ori.getHttpMethod()).append("\"");
        if (this.addResourceAndMethodIds) {
            sb.append(" id=\"").append(this.getMethod(ori).getName()).append("\"");
        }
        sb.append(">");
    }

    protected boolean handleOperation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Map<Parameter, Object> classParams, OperationResourceInfo nextOp, boolean resourceTagOpened, boolean isJson, int index) {
        boolean isVoid;
        Annotation[] anns = this.getMethod(ori).getAnnotations();
        boolean samePathOperationFollows = this.singleResourceMultipleMethods && this.compareOperations(ori, nextOp);
        String path = ori.getURITemplate().getValue();
        if (!resourceTagOpened && this.openResource(path)) {
            String parentPath;
            resourceTagOpened = true;
            URITemplate template = ori.getClassResourceInfo().getURITemplate();
            if (template != null && (parentPath = template.getValue()).endsWith("/") && path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            sb.append("<resource path=\"").append(this.getPath(path)).append("\">");
            this.handleDocs(anns, sb, "resource", false, isJson);
            this.handlePathAndMatrixClassParams(sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        } else if (index == 0) {
            this.handlePathAndMatrixClassParams(sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        }
        this.startMethodTag(sb, ori);
        this.handleDocs(anns, sb, "method", true, isJson);
        if (this.getMethod(ori).getParameterTypes().length != 0 || classParams.size() != 0) {
            sb.append("<request>");
            this.handleDocs(anns, sb, "request", false, isJson);
            boolean isForm = this.isFormRequest(ori);
            this.doHandleClassParams(sb, classParams, isJson, ParameterType.QUERY, ParameterType.HEADER);
            for (Parameter p : ori.getParameters()) {
                if (isForm && p.getType() == ParameterType.REQUEST_BODY) continue;
                this.handleParameter(sb, jaxbTypes, qnameResolver, clsMap, ori, p, isJson);
            }
            if (isForm) {
                this.handleFormRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, this.getFormClass(ori), isJson);
            }
            sb.append("</request>");
        }
        sb.append("<response");
        Class<?> returnType = this.getMethod(ori).getReturnType();
        boolean bl = isVoid = Void.TYPE == returnType;
        if (isVoid) {
            boolean oneway = this.getMethod(ori).getAnnotation(Oneway.class) != null;
            sb.append(" status=\"" + (oneway ? 202 : 204) + "\"");
        }
        sb.append(">");
        this.handleDocs(anns, sb, "response", false, isJson);
        if (!isVoid) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, returnType, isJson, false);
        }
        sb.append("</response>");
        sb.append("</method>");
        if (resourceTagOpened && !samePathOperationFollows) {
            sb.append("</resource>");
            resourceTagOpened = false;
        }
        return resourceTagOpened;
    }

    protected boolean compareOperations(OperationResourceInfo ori1, OperationResourceInfo ori2) {
        if (ori1 == null || ori2 == null || !ori1.getURITemplate().getValue().equals(ori2.getURITemplate().getValue()) || ori1.getHttpMethod() != null && ori2.getHttpMethod() == null || ori2.getHttpMethod() != null && ori1.getHttpMethod() == null) {
            return false;
        }
        int ori1PathParams = 0;
        int ori1MatrixParams = 0;
        for (Parameter p : ori1.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori1PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori1MatrixParams;
        }
        int ori2PathParams = 0;
        int ori2MatrixParams = 0;
        for (Parameter p : ori2.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori2PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori2MatrixParams;
        }
        return ori1PathParams == ori2PathParams && ori1MatrixParams == ori2MatrixParams;
    }

    private boolean openResource(String path) {
        if ("/".equals(path)) {
            return this.useSingleSlashResource;
        }
        return true;
    }

    protected void handleDynamicSubresource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, ClassResourceInfo subcri, boolean isJson) {
        if (!isJson) {
            if (subcri != null) {
                sb.append("<!-- Recursive subresource -->");
            } else {
                sb.append("<!-- Dynamic subresource -->");
            }
        }
        this.startResourceTag(sb, subcri != null ? subcri.getServiceClass() : Object.class, ori.getURITemplate().getValue());
        this.handlePathAndMatrixParams(sb, ori, isJson);
        sb.append("</resource>");
    }

    protected void handlePathAndMatrixClassParams(StringBuilder sb, Map<Parameter, Object> params, boolean isJson) {
        this.doHandleClassParams(sb, params, isJson, ParameterType.PATH);
        this.doHandleClassParams(sb, params, isJson, ParameterType.MATRIX);
    }

    protected void doHandleClassParams(StringBuilder sb, Map<Parameter, Object> params, boolean isJson, ParameterType ... pType) {
        LinkedHashSet<ParameterType> pTypes = new LinkedHashSet<ParameterType>(Arrays.asList(pType));
        for (Map.Entry<Parameter, Object> entry : params.entrySet()) {
            Parameter pm = entry.getKey();
            Object obj = entry.getValue();
            if (!pTypes.contains((Object)pm.getType())) continue;
            Class<?> cls = obj instanceof Method ? ((Method)obj).getParameterTypes()[0] : ((Field)obj).getType();
            Type type = obj instanceof Method ? ((Method)obj).getGenericParameterTypes()[0] : ((Field)obj).getGenericType();
            Annotation[] ann = obj instanceof Method ? ((Method)obj).getParameterAnnotations()[0] : ((Field)obj).getAnnotations();
            this.doWriteParam(sb, pm, cls, type, pm.getName(), ann, isJson);
        }
    }

    protected void handlePathAndMatrixParams(StringBuilder sb, OperationResourceInfo ori, boolean isJson) {
        this.handleParams(sb, ori, ParameterType.PATH, isJson);
        this.handleParams(sb, ori, ParameterType.MATRIX, isJson);
    }

    protected void handleParameter(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Parameter pm, boolean isJson) {
        Class<?> cls = this.getMethod(ori).getParameterTypes()[pm.getIndex()];
        if (pm.getType() == ParameterType.REQUEST_BODY) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, cls, isJson, true);
            return;
        }
        if (pm.getType() == ParameterType.PATH || pm.getType() == ParameterType.MATRIX) {
            return;
        }
        if (pm.getType() == ParameterType.HEADER || pm.getType() == ParameterType.QUERY) {
            this.writeParam(sb, pm, ori, isJson);
        }
    }

    protected void handleParams(StringBuilder sb, OperationResourceInfo ori, ParameterType type, boolean isJson) {
        for (Parameter pm : ori.getParameters()) {
            if (pm.getType() != type) continue;
            this.writeParam(sb, pm, ori, isJson);
        }
    }

    private Annotation[] getBodyAnnotations(OperationResourceInfo ori, boolean inbound) {
        Method opMethod = this.getMethod(ori);
        if (inbound) {
            for (Parameter pm : ori.getParameters()) {
                if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                return opMethod.getParameterAnnotations()[pm.getIndex()];
            }
            return new Annotation[0];
        }
        return opMethod.getDeclaredAnnotations();
    }

    private void writeParam(StringBuilder sb, Parameter pm, OperationResourceInfo ori, boolean isJson) {
        Method method = this.getMethod(ori);
        Class<?> type = method.getParameterTypes()[pm.getIndex()];
        if (!"".equals(pm.getName())) {
            this.doWriteParam(sb, pm, type, method.getGenericParameterTypes()[pm.getIndex()], pm.getName(), method.getParameterAnnotations()[pm.getIndex()], isJson);
        } else {
            LinkedList parentBeanClasses = new LinkedList();
            parentBeanClasses.add(type);
            this.doWriteBeanParam(sb, type, pm, null, parentBeanClasses, isJson);
        }
    }

    private void doWriteBeanParam(StringBuilder sb, Class<?> type, Parameter pm, String parentName, List<Class<?>> parentBeanClasses, boolean isJson) {
        Map<Parameter, Class<?>> pms = InjectionUtils.getParametersFromBeanClass(type, pm.getType(), true);
        for (Map.Entry<Parameter, Class<?>> entry : pms.entrySet()) {
            Class<?> paramCls;
            boolean isPrimitive;
            String name = entry.getKey().getName();
            if (parentName != null) {
                name = parentName + "." + name;
            }
            boolean bl = isPrimitive = InjectionUtils.isPrimitive(paramCls = entry.getValue()) || paramCls.isEnum();
            if (isPrimitive || InjectionUtils.isSupportedCollectionOrArray(paramCls)) {
                this.doWriteParam(sb, entry.getKey(), paramCls, paramCls, name, new Annotation[0], isJson);
                continue;
            }
            if (parentBeanClasses.contains(paramCls)) continue;
            parentBeanClasses.add(paramCls);
            this.doWriteBeanParam(sb, paramCls, entry.getKey(), name, parentBeanClasses, isJson);
        }
    }

    protected void doWriteParam(StringBuilder sb, Parameter pm, Class<?> type, Type genericType, String paramName, Annotation[] anns, boolean isJson) {
        String value;
        Multipart m;
        ParameterType pType = pm.getType();
        boolean isForm = this.isFormParameter(pm, type, anns);
        if (paramName == null && isForm && (m = AnnotationUtils.getAnnotation(anns, Multipart.class)) != null) {
            paramName = m.value();
        }
        sb.append("<param name=\"").append(paramName).append("\" ");
        String style = ParameterType.PATH == pType ? "template" : (isForm ? "query" : (ParameterType.REQUEST_BODY == pType ? "plain" : pType.toString().toLowerCase()));
        sb.append("style=\"").append(style).append("\"");
        if (pm.getDefaultValue() != null) {
            sb.append(" default=\"").append(this.xmlEncodeIfNeeded(pm.getDefaultValue())).append("\"");
        }
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType(genericType);
            sb.append(" repeating=\"true\"");
        }
        if ((value = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type)) == null && type.isEnum()) {
            value = "xs:string";
        }
        if (value != null) {
            if (isJson) {
                value = value.substring(3);
            }
            sb.append(" type=\"").append(value).append("\"");
        }
        if (type.isEnum()) {
            sb.append(">");
            this.handleDocs(anns, sb, "param", true, isJson);
            this.setEnumOptions(sb, type);
            sb.append("</param>");
        } else {
            this.addDocsAndCloseElement(sb, anns, "param", "param", true, isJson);
        }
    }

    private void setEnumOptions(StringBuilder sb, Class<?> enumClass) {
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            Object[] values = (Object[])m.invoke(null, new Object[0]);
            m = enumClass.getMethod("toString", new Class[0]);
            for (Object o : values) {
                String str = (String)m.invoke(o, new Object[0]);
                sb.append("<option value=\"" + str + "\"/>");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addDocsAndCloseElement(StringBuilder sb, Annotation[] anns, String elementName, String category, boolean allowDefault, boolean isJson) {
        if (this.isDocAvailable(anns)) {
            sb.append(">");
            this.handleDocs(anns, sb, category, allowDefault, isJson);
            sb.append("</" + elementName + ">");
        } else {
            sb.append("/>");
        }
    }

    private boolean isDocAvailable(Annotation[] anns) {
        return AnnotationUtils.getAnnotation(anns, Description.class) != null || AnnotationUtils.getAnnotation(anns, Descriptions.class) != null;
    }

    protected void handleRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson, boolean inbound) {
        List<MediaType> types;
        List<MediaType> list = types = inbound ? ori.getConsumeTypes() : ori.getProduceTypes();
        if (MultivaluedMap.class.isAssignableFrom(type)) {
            types = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else if (this.isWildcard(types)) {
            types = Collections.singletonList(MediaType.APPLICATION_OCTET_STREAM_TYPE);
        }
        Method opMethod = this.getMethod(ori);
        boolean isPrimitive = InjectionUtils.isPrimitive(type);
        for (MediaType mt : types) {
            String docCategory;
            Annotation[] anns;
            sb.append("<representation");
            sb.append(" mediaType=\"").append(JAXRSUtils.mediaTypeToString(mt, new String[0])).append("\"");
            if (isJson && !mt.getSubtype().contains("json")) {
                sb.append("/>");
                continue;
            }
            boolean allowDefault = true;
            if (inbound) {
                int index = this.getRequestBodyParam(ori).getIndex();
                anns = opMethod.getParameterAnnotations()[index];
                if (!this.isDocAvailable(anns)) {
                    anns = opMethod.getAnnotations();
                }
                docCategory = "param";
            } else {
                anns = opMethod.getAnnotations();
                docCategory = "return";
                allowDefault = false;
            }
            if (isPrimitive) {
                sb.append(">");
                Parameter p = inbound ? this.getRequestBodyParam(ori) : new Parameter(ParameterType.REQUEST_BODY, 0, "result");
                this.doWriteParam(sb, p, type, type, p.getName() == null ? "request" : p.getName(), anns, isJson);
                sb.append("</representation>");
                continue;
            }
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            type = isCollection ? InjectionUtils.getActualType(!inbound ? opMethod.getGenericReturnType() : opMethod.getGenericParameterTypes()[this.getRequestBodyParam(ori).getIndex()]) : ResourceUtils.getActualJaxbType(type, opMethod, inbound);
            if (isJson) {
                sb.append(" element=\"").append(type.getSimpleName()).append("\"");
            } else if (qnameResolver != null && (mt.getSubtype().contains("xml") || this.linkJsonToXmlSchema && mt.getSubtype().contains("json")) && jaxbTypes.contains(type)) {
                this.generateQName(sb, qnameResolver, clsMap, type, isCollection, this.getBodyAnnotations(ori, inbound));
            }
            this.addDocsAndCloseElement(sb, anns, "representation", docCategory, allowDefault, isJson);
        }
    }

    private Parameter getRequestBodyParam(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.REQUEST_BODY) continue;
            return p;
        }
        throw new IllegalStateException();
    }

    private boolean isWildcard(List<MediaType> types) {
        return types.size() == 1 && types.get(0).equals((Object)MediaType.WILDCARD_TYPE);
    }

    private void handleFormRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson) {
        if (type != null) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, type, false, true);
        } else {
            List<MediaType> types = ori.getConsumeTypes();
            MediaType formType = this.isWildcard(types) ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : types.get(0);
            sb.append("<representation");
            sb.append(" mediaType=\"").append(formType).append("\"");
            if (isJson) {
                sb.append("/>");
            } else {
                sb.append(">");
                List<Parameter> params = ori.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    if (!this.isFormParameter(params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
                    this.writeParam(sb, params.get(i), ori, false);
                }
                sb.append("</representation>");
            }
        }
    }

    protected List<OperationResourceInfo> sortOperationsByPath(Set<OperationResourceInfo> ops) {
        LinkedList<OperationResourceInfo> opsWithSamePath = new LinkedList<OperationResourceInfo>(ops);
        Collections.sort(opsWithSamePath, new Comparator<OperationResourceInfo>(){

            @Override
            public int compare(OperationResourceInfo op1, OperationResourceInfo op2) {
                boolean sub2;
                boolean sub1 = op1.getHttpMethod() == null;
                boolean bl = sub2 = op2.getHttpMethod() == null;
                if (sub1 && !sub2) {
                    return 1;
                }
                if (!sub1 && sub2) {
                    return -1;
                }
                URITemplate ut1 = op1.getURITemplate();
                URITemplate ut2 = op2.getURITemplate();
                int result = ut1.getValue().compareTo(ut2.getValue());
                if (!(result != 0 || sub1 && sub2)) {
                    result = op1.getHttpMethod().compareTo(op2.getHttpMethod());
                }
                return result;
            }
        });
        return opsWithSamePath;
    }

    public List<ClassResourceInfo> getResourcesList(Message m, ClassResourceInfo cri) {
        return cri != null ? Collections.singletonList(cri) : ((JAXRSServiceImpl)m.getExchange().get(Service.class)).getClassResourceInfos();
    }

    public Response getExistingWadl(Message m, UriInfo ui, MediaType mt) {
        String loc;
        Endpoint ep = m.getExchange().get(Endpoint.class);
        if (ep != null && (loc = (String)ep.get("wadl.location")) != null) {
            try {
                InputStream is = ResourceUtils.getResourceStream(loc, (Bus)ep.get(Bus.class.getName()));
                if (is != null) {
                    List<Element> resourcesEls;
                    Element appEl = StaxUtils.read(is).getDocumentElement();
                    List<Element> grammarEls = DOMUtils.getChildrenWithName(appEl, WADL_NS, "grammars");
                    if (grammarEls.size() == 1) {
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName(grammarEls.get(0), WADL_NS, "include"), "href", loc, "", m, ui);
                    }
                    if ((resourcesEls = DOMUtils.getChildrenWithName(appEl, WADL_NS, "resources")).size() == 1) {
                        DOMUtils.setAttribute(resourcesEls.get(0), "base", this.getBaseURI(m, ui));
                        List<Element> resourceEls = DOMUtils.getChildrenWithName(resourcesEls.get(0), WADL_NS, "resource");
                        this.handleExistingDocRefs(resourceEls, "type", loc, "", m, ui);
                        return Response.ok().type(mt).entity((Object)new DOMSource(appEl)).build();
                    }
                }
            }
            catch (Exception ex) {
                throw new InternalServerErrorException((Throwable)ex);
            }
        }
        return null;
    }

    public Response getExistingResource(Message m, UriInfo ui, String href) {
        String loc = this.docLocationMap.get(href);
        Endpoint ep = m.getExchange().get(Endpoint.class);
        if (ep != null && loc != null) {
            try {
                InputStream is;
                int fragmentIndex = loc.lastIndexOf("#");
                if (fragmentIndex != -1) {
                    loc = loc.substring(0, fragmentIndex);
                }
                if ((is = ResourceUtils.getResourceStream(loc, (Bus)ep.get(Bus.class.getName()))) != null) {
                    Element docEl = StaxUtils.read(is).getDocumentElement();
                    if (fragmentIndex != -1) {
                        List<Element> grammarEls = DOMUtils.getChildrenWithName(docEl, WADL_NS, "grammars");
                        if (grammarEls.size() == 1) {
                            this.handleExistingDocRefs(DOMUtils.getChildrenWithName(grammarEls.get(0), WADL_NS, "include"), "href", loc, href, m, ui);
                        }
                    } else {
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName(docEl, "http://www.w3.org/2001/XMLSchema", "import"), "schemaLocation", loc, href, m, ui);
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName(docEl, "http://www.w3.org/2001/XMLSchema", "include"), "schemaLocation", loc, href, m, ui);
                    }
                    return Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)new DOMSource(docEl)).build();
                }
            }
            catch (Exception ex) {
                throw new BadRequestException();
            }
        }
        return null;
    }

    private void handleExistingDocRefs(List<Element> elements, String attrName, String parentDocLoc, String parentRef, Message m, UriInfo ui) {
        int index = parentDocLoc.lastIndexOf(47);
        parentDocLoc = index == -1 ? parentDocLoc : parentDocLoc.substring(0, index + 1);
        index = parentRef.lastIndexOf(47);
        parentRef = index == -1 ? "" : parentRef.substring(0, index + 1);
        for (Element element : elements) {
            String href;
            String originalRef = href = element.getAttribute(attrName);
            if (StringUtils.isEmpty(href) || href.startsWith("#")) continue;
            int fragmentIndex = href.lastIndexOf("#");
            String fragment = null;
            if (fragmentIndex != -1) {
                fragment = href.substring(fragmentIndex + 1);
                href = href.substring(0, fragmentIndex);
            }
            String actualRef = parentRef + href;
            this.docLocationMap.put(actualRef, parentDocLoc + originalRef);
            UriBuilder ub = UriBuilder.fromUri((String)this.getBaseURI(m, ui)).path(actualRef).fragment(fragment);
            URI schemaURI = ub.build(new Object[0]);
            DOMUtils.setAttribute(element, attrName, schemaURI.toString());
        }
    }

    private void generateQName(StringBuilder sb, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, Class<?> type, boolean isCollection, Annotation[] annotations) {
        QName typeQName;
        if (!isCollection && (typeQName = clsMap.get(type)) != null) {
            this.writeQName(sb, typeQName);
            return;
        }
        QName qname = qnameResolver.resolve(type, annotations, Collections.unmodifiableMap(clsMap));
        if (qname != null) {
            if (!isCollection) {
                this.writeQName(sb, qname);
                clsMap.put(type, qname);
            } else {
                XMLName name = AnnotationUtils.getAnnotation(annotations, XMLName.class);
                QName collectionName = null;
                if (name != null) {
                    QName tempQName = JAXRSUtils.convertStringToQName(name.value());
                    collectionName = new QName(qname.getNamespaceURI(), tempQName.getLocalPart(), qname.getPrefix());
                    this.writeQName(sb, collectionName);
                }
            }
        }
    }

    private void writeQName(StringBuilder sb, QName qname) {
        sb.append(" element=\"").append(qname.getPrefix()).append(':').append(qname.getLocalPart()).append("\"");
    }

    private SchemaCollection getSchemaCollection(ResourceTypes resourceTypes, JAXBContext context) {
        if (context == null) {
            return null;
        }
        SchemaCollection xmlSchemaCollection = new SchemaCollection();
        HashSet<DOMSource> schemas = new HashSet<DOMSource>();
        ArrayList<String> targetNamespaces = new ArrayList<String>();
        try {
            for (DOMResult r : JAXBUtils.generateJaxbSchemas(context, CastUtils.cast(Collections.emptyMap(), String.class, DOMResult.class))) {
                String tns;
                Document doc = (Document)r.getNode();
                if (this.supportCollections && !resourceTypes.getCollectionMap().isEmpty()) {
                    ElementQNameResolver theResolver = this.createElementQNameResolver(context);
                    tns = doc.getDocumentElement().getAttribute("targetNamespace");
                    for (Map.Entry<Class<?>, QName> entry : resourceTypes.getCollectionMap().entrySet()) {
                        QName typeName;
                        if (!tns.equals(entry.getValue().getNamespaceURI()) || (typeName = theResolver.resolve(entry.getKey(), new Annotation[0], Collections.<Class<?>, QName>emptyMap())) == null) continue;
                        Element newElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        newElement.setAttribute("name", entry.getValue().getLocalPart());
                        Element ctElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                        newElement.appendChild(ctElement);
                        Element seqElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                        ctElement.appendChild(seqElement);
                        Element xsElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        seqElement.appendChild(xsElement);
                        xsElement.setAttribute("ref", "tns:" + typeName.getLocalPart());
                        xsElement.setAttribute("minOccurs", "0");
                        xsElement.setAttribute("maxOccurs", "unbounded");
                        doc.getDocumentElement().appendChild(newElement);
                    }
                }
                DOMSource source = new DOMSource(doc, r.getSystemId());
                schemas.add(source);
                tns = ((Document)source.getNode()).getDocumentElement().getAttribute("targetNamespace");
                if (StringUtils.isEmpty(tns)) continue;
                targetNamespaces.add(tns);
            }
        }
        catch (IOException e) {
            LOG.fine("No schema can be generated");
            return null;
        }
        boolean hackAroundEmptyNamespaceIssue = false;
        for (DOMSource r : schemas) {
            hackAroundEmptyNamespaceIssue = this.addSchemaDocument(xmlSchemaCollection, targetNamespaces, (Document)r.getNode(), r.getSystemId(), hackAroundEmptyNamespaceIssue);
        }
        return xmlSchemaCollection;
    }

    private QName getJaxbQName(JAXBContextProxy jaxbProxy, Class<?> type, Map<Class<?>, QName> clsMap) {
        XmlRootElement root = type.getAnnotation(XmlRootElement.class);
        if (root != null) {
            QName qname = this.getQNameFromParts(root.name(), root.namespace(), type, clsMap);
            if (qname != null) {
                return qname;
            }
            String ns = JAXBUtils.getPackageNamespace(type);
            if (ns != null) {
                return this.getQNameFromParts(root.name(), ns, type, clsMap);
            }
            return null;
        }
        try {
            JAXBBeanInfo jaxbInfo;
            JAXBBeanInfo jAXBBeanInfo = jaxbInfo = jaxbProxy == null ? null : JAXBUtils.getBeanInfo(jaxbProxy, type);
            if (jaxbInfo == null) {
                return null;
            }
            Object instance = type.newInstance();
            return this.getQNameFromParts(jaxbInfo.getElementLocalName(instance), jaxbInfo.getElementNamespaceURI(instance), type, clsMap);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getPrefix(String ns, Map<Class<?>, QName> clsMap) {
        String prefix = null;
        for (QName name : clsMap.values()) {
            if (!name.getNamespaceURI().equals(ns)) continue;
            prefix = name.getPrefix();
            break;
        }
        if (prefix == null) {
            int size = new HashSet<QName>(clsMap.values()).size();
            prefix = this.nsPrefix + (size + 1);
        }
        return prefix;
    }

    private boolean isFormRequest(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.FORM && (p.getType() != ParameterType.REQUEST_BODY || this.getMethod(ori).getParameterTypes()[p.getIndex()] != MultivaluedMap.class && AnnotationUtils.getAnnotation(this.getMethod(ori).getParameterAnnotations()[p.getIndex()], Multipart.class) == null)) continue;
            return true;
        }
        return false;
    }

    private Class<?> getFormClass(OperationResourceInfo ori) {
        List<Parameter> params = ori.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            if (!this.isFormParameter(params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
            return null;
        }
        return MultivaluedMap.class;
    }

    private boolean isFormParameter(Parameter pm, Class<?> type, Annotation[] anns) {
        return ParameterType.FORM == pm.getType() || ParameterType.REQUEST_BODY == pm.getType() && AnnotationUtils.getAnnotation(anns, Multipart.class) != null && InjectionUtils.isPrimitive(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSchemaDocument(SchemaCollection col, List<String> tnsList, Document d, String systemId, boolean hackAroundEmptyNamespaceIssue) {
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty(ns)) {
            if (DOMUtils.getFirstElement(d.getDocumentElement()) == null) {
                hackAroundEmptyNamespaceIssue = true;
                return hackAroundEmptyNamespaceIssue;
            }
            d = this.copy(d);
            ns = tnsList.isEmpty() ? "" : tnsList.get(0);
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        if (hackAroundEmptyNamespaceIssue) {
            d = this.doEmptyNamespaceHack(d);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
        }
        Document document = d;
        synchronized (document) {
            col.read(d, systemId);
        }
        return hackAroundEmptyNamespaceIssue;
    }

    private Document doEmptyNamespaceHack(Document d) {
        boolean hasStuffToRemove = false;
        Element el = DOMUtils.getFirstElement(d.getDocumentElement());
        while (el != null) {
            if ("import".equals(el.getLocalName()) && StringUtils.isEmpty(el.getAttribute("targetNamespace"))) {
                hasStuffToRemove = true;
                break;
            }
            el = DOMUtils.getNextElement(el);
        }
        if (hasStuffToRemove) {
            d = this.copy(d);
            el = DOMUtils.getFirstElement(d.getDocumentElement());
            while (el != null) {
                if ("import".equals(el.getLocalName()) && StringUtils.isEmpty(el.getAttribute("targetNamespace"))) {
                    d.getDocumentElement().removeChild(el);
                    el = DOMUtils.getFirstElement(d.getDocumentElement());
                    continue;
                }
                el = DOMUtils.getNextElement(el);
            }
        }
        return d;
    }

    private Document copy(Document doc) {
        try {
            return StaxUtils.copy(doc);
        }
        catch (XMLStreamException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    private QName getQNameFromParts(String name, String namespace, Class<?> type, Map<Class<?>, QName> clsMap) {
        if (namespace == null || "##default".equals(namespace) || namespace.length() == 0) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        if ("##default".equals(name)) {
            name = type.getSimpleName();
            StringBuilder sb = new StringBuilder();
            sb.append(Character.toLowerCase(name.charAt(0)));
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            name = sb.toString();
        }
        String prefix = this.getPrefix(namespace, clsMap);
        return new QName(namespace, name, prefix);
    }

    public void setIgnoreMessageWriters(boolean ignoreMessageWriters) {
        this.ignoreMessageWriters = ignoreMessageWriters;
    }

    private void handleApplicationDocs(StringBuilder sbApp) {
        if (this.applicationTitle != null) {
            sbApp.append("<doc title=\"" + this.xmlEncodeIfNeeded(this.applicationTitle) + "\"/>");
        }
    }

    protected void handleDocs(Annotation[] anns, StringBuilder sb, String category, boolean allowDefault, boolean isJson) {
        for (Annotation a : anns) {
            Description d;
            if (a.annotationType() == Descriptions.class) {
                Descriptions ds = (Descriptions)a;
                this.handleDocs(ds.value(), sb, category, allowDefault, isJson);
                return;
            }
            if (a.annotationType() != Description.class || (d = (Description)a).target().length() == 0 && !allowDefault || d.target().length() > 0 && !d.target().equals(category)) continue;
            sb.append("<doc");
            if (!isJson && d.lang().length() > 0) {
                sb.append(" xml:lang=\"" + d.lang() + "\"");
            }
            if (d.title().length() > 0) {
                sb.append(" title=\"" + this.xmlEncodeIfNeeded(d.title()) + "\"");
            }
            sb.append(">");
            if (d.value().length() > 0) {
                sb.append(this.xmlEncodeIfNeeded(d.value()));
            } else if (d.docuri().length() > 0) {
                String path;
                InputStream is = null;
                if (d.docuri().startsWith(CLASSPATH_PREFIX) && (is = ResourceUtils.getClasspathResourceStream(path = d.docuri().substring(CLASSPATH_PREFIX.length()), SchemaHandler.class, BusFactory.getDefaultBus())) != null) {
                    try {
                        sb.append(IOUtils.toString(is));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            sb.append("</doc>");
        }
    }

    private String getNamespace() {
        return this.wadlNamespace != null ? this.wadlNamespace : WADL_NS;
    }

    public void setWadlNamespace(String namespace) {
        this.wadlNamespace = namespace;
    }

    public void setSingleResourceMultipleMethods(boolean singleResourceMultipleMethods) {
        this.singleResourceMultipleMethods = singleResourceMultipleMethods;
    }

    public void setUseSingleSlashResource(boolean useSingleSlashResource) {
        this.useSingleSlashResource = useSingleSlashResource;
    }

    public void setLinkJsonToXmlSchema(boolean link) {
        this.linkJsonToXmlSchema = link;
    }

    public void setSchemaLocations(List<String> locations) {
        this.externalQnamesMap = new HashMap<String, List<String>>();
        this.externalSchemasCache = new ArrayList<String>(locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            String loc = locations.get(i);
            try {
                this.loadSchemasIntoCache(loc);
                continue;
            }
            catch (Exception ex) {
                LOG.warning("No schema resource " + loc + " can be loaded : " + ex.getMessage());
                this.externalSchemasCache = null;
                this.externalQnamesMap = null;
                return;
            }
        }
    }

    private void loadSchemasIntoCache(String loc) throws Exception {
        InputStream is = ResourceUtils.getResourceStream(loc, BusFactory.getDefaultBus());
        if (is == null) {
            return;
        }
        ByteArrayInputStream bis = IOUtils.loadIntoBAIS(is);
        XMLSource source = new XMLSource(bis);
        source.setBuffering();
        String targetNs = source.getValue("/*/@targetNamespace");
        Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
        String[] elementNames = source.getValues("/*/xs:element/@name", nsMap);
        this.externalQnamesMap.put(targetNs, Arrays.asList(elementNames));
        String schemaValue = source.getNode("/xs:schema", nsMap, String.class);
        this.externalSchemasCache.add(schemaValue);
    }

    public void setUseJaxbContextForQnames(boolean checkJaxbOnly) {
        this.useJaxbContextForQnames = checkJaxbOnly;
    }

    protected ElementQNameResolver createElementQNameResolver(JAXBContext context) {
        if (this.resolver != null) {
            return this.resolver;
        }
        if (this.useJaxbContextForQnames) {
            if (context != null) {
                JAXBContextProxy proxy = JAXBUtils.createJAXBContextProxy(context);
                return new JaxbContextQNameResolver(proxy);
            }
            return null;
        }
        if (this.externalQnamesMap != null) {
            return new SchemaQNameResolver(this.externalQnamesMap);
        }
        return new XMLNameQNameResolver();
    }

    protected SchemaWriter createSchemaWriter(ResourceTypes resourceTypes, JAXBContext context, UriInfo ui) {
        SchemaCollection coll;
        if (this.externalSchemaLinks != null && this.externalSchemasCache == null) {
            return new ExternalSchemaWriter(this.externalSchemaLinks, ui);
        }
        if (this.externalSchemasCache != null) {
            return new StringSchemaWriter(this.externalSchemasCache, this.externalSchemaLinks, ui);
        }
        if (context != null && (coll = this.getSchemaCollection(resourceTypes, context)) != null) {
            return new SchemaCollectionWriter(coll);
        }
        return null;
    }

    public void setExternalLinks(List<String> externalLinks) {
        this.externalSchemaLinks = new LinkedList<URI>();
        for (String s : externalLinks) {
            try {
                String href = s;
                if (href.startsWith(CLASSPATH_PREFIX)) {
                    int index = href.lastIndexOf(47);
                    href = index == -1 ? href.substring(9) : href.substring(index + 1);
                    this.docLocationMap.put(href, s);
                }
                this.externalSchemaLinks.add(URI.create(href));
            }
            catch (Exception ex) {
                LOG.warning("Not a valid URI : " + s);
                this.externalSchemaLinks = null;
                break;
            }
        }
    }

    public void setResolver(ElementQNameResolver resolver) {
        this.resolver = resolver;
    }

    public void setPrivateAddresses(List<String> privateAddresses) {
        this.privateAddresses = privateAddresses;
    }

    public List<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    public void setAddResourceAndMethodIds(boolean addResourceAndMethodIds) {
        this.addResourceAndMethodIds = addResourceAndMethodIds;
    }

    private Method getMethod(OperationResourceInfo ori) {
        Method annMethod = ori.getAnnotatedMethod();
        return annMethod != null ? annMethod : ori.getMethodToInvoke();
    }

    public void setApplicationTitle(String applicationTitle) {
        this.applicationTitle = applicationTitle;
    }

    public void setNamespacePrefix(String prefix) {
        this.nsPrefix = prefix;
    }

    public void setIgnoreForwardSlash(boolean ignoreForwardSlash) {
        this.ignoreForwardSlash = ignoreForwardSlash;
    }

    public void setIgnoreRequests(boolean ignoreRequests) {
        this.ignoreRequests = ignoreRequests;
    }

    public void setSupportCollections(boolean support) {
        this.supportCollections = support;
    }

    public void setDefaultMediaType(String mt) {
        this.defaultMediaType = JAXRSUtils.toMediaType(mt);
    }

    private static class SchemaConverter
    extends DelegatingXMLStreamWriter {
        private static final String SCHEMA_LOCATION = "schemaLocation";
        private Map<String, String> locsMap;

        public SchemaConverter(XMLStreamWriter writer, Map<String, String> locsMap) {
            super(writer);
            this.locsMap = locsMap;
        }

        @Override
        public void writeAttribute(String local, String value) throws XMLStreamException {
            if (SCHEMA_LOCATION.equals(local) && this.locsMap.containsKey(value)) {
                value = this.locsMap.get(value);
            }
            super.writeAttribute(local, value);
        }
    }

    private class SchemaQNameResolver
    implements ElementQNameResolver {
        private Map<String, List<String>> map;

        public SchemaQNameResolver(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            String name = type.getSimpleName();
            for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
                String elementName = null;
                if (entry.getValue().contains(name)) {
                    elementName = name;
                } else if (entry.getValue().contains(name.toLowerCase())) {
                    elementName = name.toLowerCase();
                }
                if (elementName == null) continue;
                return WadlGenerator.this.getQNameFromParts(elementName, entry.getKey(), type, clsMap);
            }
            return null;
        }
    }

    private class XMLNameQNameResolver
    implements ElementQNameResolver {
        private XMLNameQNameResolver() {
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XMLName name = AnnotationUtils.getAnnotation(annotations, XMLName.class);
            if (name == null) {
                name = type.getAnnotation(XMLName.class);
            }
            if (name != null) {
                QName qname = XMLUtils.convertStringToQName(name.value(), name.prefix());
                if (qname.getPrefix().length() > 0) {
                    return qname;
                }
                return WadlGenerator.this.getQNameFromParts(qname.getLocalPart(), qname.getNamespaceURI(), type, clsMap);
            }
            return null;
        }
    }

    private class JaxbContextQNameResolver
    implements ElementQNameResolver {
        private JAXBContextProxy proxy;

        public JaxbContextQNameResolver(JAXBContextProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            return WadlGenerator.this.getJaxbQName(this.proxy, type, clsMap);
        }
    }

    private class ExternalSchemaWriter
    implements SchemaWriter {
        private List<URI> links;
        private UriInfo uriInfo;

        public ExternalSchemaWriter(List<URI> links, UriInfo ui) {
            this.links = links;
            this.uriInfo = ui;
        }

        @Override
        public void write(StringBuilder sb) {
            for (URI link : this.links) {
                try {
                    URI value = link.isAbsolute() ? link : this.uriInfo.getBaseUriBuilder().path(link.toString()).build(new Object[0]);
                    sb.append("<include href=\"").append(value.toString()).append("\"/>");
                }
                catch (Exception ex) {
                    LOG.warning("WADL grammar section will be incomplete, this link is not a valid URI : " + link.toString());
                }
            }
        }
    }

    private class SchemaCollectionWriter
    implements SchemaWriter {
        private SchemaCollection coll;

        public SchemaCollectionWriter(SchemaCollection coll) {
            this.coll = coll;
        }

        @Override
        public void write(StringBuilder sb) {
            for (XmlSchema xs : this.coll.getXmlSchemas()) {
                if (xs.getItems().isEmpty() || "http://www.w3.org/2001/XMLSchema".equals(xs.getTargetNamespace())) continue;
                StringWriter writer = new StringWriter();
                xs.write((Writer)writer);
                sb.append(writer.toString());
            }
        }
    }

    private class StringSchemaWriter
    implements SchemaWriter {
        private List<String> theSchemas = new LinkedList<String>();

        public StringSchemaWriter(List<String> schemas, List<URI> links, UriInfo ui) {
            for (String s : schemas) {
                XMLSource source = new XMLSource(new ByteArrayInputStream(s.getBytes()));
                source.setBuffering();
                Map<String, String> locs = this.getLocationsMap(source, "import", links, ui);
                locs.putAll(this.getLocationsMap(source, "include", links, ui));
                String actualSchema = !locs.isEmpty() ? this.transformSchema(s, locs) : s;
                this.theSchemas.add(actualSchema);
            }
        }

        private Map<String, String> getLocationsMap(XMLSource source, String elementName, List<URI> links, UriInfo ui) {
            Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
            String[] locations = source.getValues("/*/xs:" + elementName + "/@schemaLocation", nsMap);
            HashMap<String, String> locs = new HashMap<String, String>();
            if (locations == null) {
                return locs;
            }
            for (String loc : locations) {
                try {
                    URI uri = URI.create(loc);
                    if (uri.isAbsolute()) continue;
                    if (links != null) {
                        for (URI overwriteURI : links) {
                            if (!overwriteURI.toString().endsWith(loc)) continue;
                            if (overwriteURI.isAbsolute()) {
                                locs.put(loc, overwriteURI.toString());
                                break;
                            }
                            locs.put(loc, ui.getBaseUriBuilder().path(overwriteURI.toString()).build(new Object[0]).toString());
                            break;
                        }
                    }
                    if (locs.containsKey(loc)) continue;
                    locs.put(loc, ui.getBaseUriBuilder().path(loc).build(new Object[0]).toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return locs;
        }

        private String transformSchema(String schema, Map<String, String> locs) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SchemaConverter sc = new SchemaConverter(StaxUtils.createXMLStreamWriter(bos), locs);
            try {
                StaxUtils.copy((Source)new StreamSource(new StringReader(schema)), (XMLStreamWriter)sc);
                sc.flush();
                sc.close();
                return bos.toString();
            }
            catch (Exception ex) {
                return schema;
            }
        }

        @Override
        public void write(StringBuilder sb) {
            for (String s : this.theSchemas) {
                sb.append(s);
            }
        }
    }

    protected static interface SchemaWriter {
        public void write(StringBuilder var1);
    }
}

