/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public abstract class AbstractOutDatabindingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String DISABLE_OUTPUTSTREAM_OPTIMIZATION = "disable.outputstream.optimization";
    public static final String OUT_BUFFERING = "org.apache.cxf.output.buffering";

    public AbstractOutDatabindingInterceptor(String phase) {
        super(phase);
    }

    public AbstractOutDatabindingInterceptor(String id, String phase) {
        super(id, phase);
    }

    @Override
    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey("org.apache.cxf.client"));
    }

    protected void writeParts(Message message, Exchange exchange, BindingOperationInfo operation, MessageContentsList objs, List<MessagePartInfo> parts) {
        Object o;
        OutputStream out = message.getContent(OutputStream.class);
        XMLStreamWriter origXmlWriter = message.getContent(XMLStreamWriter.class);
        Service service = exchange.getService();
        XMLStreamWriter xmlWriter = origXmlWriter;
        CachingXmlEventWriter cache = null;
        Object en = message.getContextualProperty(OUT_BUFFERING);
        boolean allowBuffer = true;
        boolean buffer = false;
        if (en != null) {
            buffer = Boolean.TRUE.equals(en) || "true".equals(en);
            boolean bl = allowBuffer = !Boolean.FALSE.equals(en) && !"false".equals(en);
        }
        if (buffer || allowBuffer && this.shouldValidate(message) && !this.isRequestor(message)) {
            cache = new CachingXmlEventWriter();
            try {
                cache.setNamespaceContext(origXmlWriter.getNamespaceContext());
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            xmlWriter = cache;
            out = null;
        }
        if (out != null && this.writeToOutputStream(message, operation.getBinding(), service) && !MessageUtils.isTrue(message.getContextualProperty(DISABLE_OUTPUTSTREAM_OPTIMIZATION))) {
            if (xmlWriter != null) {
                try {
                    xmlWriter.writeCharacters("");
                    xmlWriter.flush();
                }
                catch (XMLStreamException e) {
                    throw new Fault(e);
                }
            }
            DataWriter<OutputStream> osWriter = this.getDataWriter(message, service, OutputStream.class);
            for (MessagePartInfo part : parts) {
                if (!objs.hasValue(part)) continue;
                o = objs.get(part);
                osWriter.write(o, part, out);
            }
        } else {
            DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
            for (MessagePartInfo part : parts) {
                if (!objs.hasValue(part)) continue;
                o = objs.get(part);
                dataWriter.write(o, part, xmlWriter);
            }
        }
        if (cache != null) {
            try {
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent(event, origXmlWriter);
                }
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
        }
    }

    protected boolean shouldValidate(Message m) {
        SchemaValidation.SchemaValidationType type = ServiceUtils.getSchemaValidationType(m);
        return type.equals((Object)SchemaValidation.SchemaValidationType.BOTH) || type.equals((Object)SchemaValidation.SchemaValidationType.OUT);
    }

    protected boolean writeToOutputStream(Message m, BindingInfo info, Service s) {
        if (s == null) {
            return false;
        }
        String enc = (String)m.get(Message.ENCODING);
        return info.getClass().getName().equals("org.apache.cxf.binding.soap.model.SoapBindingInfo") && s.getDataBinding().getClass().getName().equals("org.apache.cxf.jaxb.JAXBDataBinding") && !MessageUtils.isDOMPresent(m) && (enc == null || "UTF-8".equals(enc));
    }

    protected <T> DataWriter<T> getDataWriter(Message message, Service service, Class<T> output) {
        DataWriter<T> writer = service.getDataBinding().createWriter(output);
        Collection<Attachment> atts = message.getAttachments();
        if (MessageUtils.isTrue(message.getContextualProperty("mtom-enabled")) && atts == null) {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
        }
        writer.setAttachments(atts);
        writer.setProperty(DataWriter.ENDPOINT, message.getExchange().getEndpoint());
        writer.setProperty(Message.class.getName(), message);
        this.setSchemaOutMessage(service, message, writer);
        return writer;
    }

    private void setSchemaOutMessage(Service service, Message message, DataWriter<?> writer) {
        if (this.shouldValidate(message)) {
            Schema schema = EndpointReferenceUtils.getSchema(service.getServiceInfos().get(0), message.getExchange().getBus());
            writer.setSchema(schema);
        }
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return message.getContent(XMLStreamWriter.class);
    }
}

