/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.curator.test.InstanceSpec;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class QuorumConfigBuilder {
    private final ImmutableList<InstanceSpec> instanceSpecs;
    private final boolean fromRandom;

    public QuorumConfigBuilder(Collection<InstanceSpec> specs) {
        this(specs.toArray(new InstanceSpec[specs.size()]));
    }

    public QuorumConfigBuilder(InstanceSpec ... specs) {
        this.fromRandom = specs == null || specs.length == 0;
        this.instanceSpecs = this.fromRandom ? ImmutableList.of((Object)InstanceSpec.newInstanceSpec()) : ImmutableList.copyOf((Object[])specs);
    }

    public boolean isFromRandom() {
        return this.fromRandom;
    }

    public QuorumPeerConfig buildConfig() throws Exception {
        return this.buildConfig(0);
    }

    public InstanceSpec getInstanceSpec(int index) {
        return (InstanceSpec)this.instanceSpecs.get(index);
    }

    public List<InstanceSpec> getInstanceSpecs() {
        return this.instanceSpecs;
    }

    public int size() {
        return this.instanceSpecs.size();
    }

    public QuorumPeerConfig buildConfig(int instanceIndex) throws Exception {
        int maxClientCnxns;
        boolean isCluster = this.instanceSpecs.size() > 1;
        InstanceSpec spec = (InstanceSpec)this.instanceSpecs.get(instanceIndex);
        if (isCluster) {
            Files.write((byte[])Integer.toString(spec.getServerId()).getBytes(), (File)new File(spec.getDataDirectory(), "myid"));
        }
        Properties properties = new Properties();
        properties.setProperty("initLimit", "10");
        properties.setProperty("syncLimit", "5");
        properties.setProperty("dataDir", spec.getDataDirectory().getCanonicalPath());
        properties.setProperty("clientPort", Integer.toString(spec.getPort()));
        int tickTime = spec.getTickTime();
        if (tickTime >= 0) {
            properties.setProperty("tickTime", Integer.toString(tickTime));
        }
        if ((maxClientCnxns = spec.getMaxClientCnxns()) >= 0) {
            properties.setProperty("maxClientCnxns", Integer.toString(maxClientCnxns));
        }
        if (isCluster) {
            for (InstanceSpec thisSpec : this.instanceSpecs) {
                properties.setProperty("server." + thisSpec.getServerId(), String.format("localhost:%d:%d", thisSpec.getQuorumPort(), thisSpec.getElectionPort()));
            }
        }
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(properties);
        return config;
    }
}

