/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.AggregateFcts;
import org.apache.cassandra.cql3.functions.CastFcts;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.FieldSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.selection.TermSelector;
import org.apache.cassandra.cql3.selection.WritetimeOrTTLSelector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.commons.lang3.text.StrBuilder;

public interface Selectable
extends AssignmentTestable {
    public Selector.Factory newSelectorFactory(CFMetaData var1, AbstractType<?> var2, List<ColumnDefinition> var3, VariableSpecifications var4);

    public AbstractType<?> getExactTypeIfKnown(String var1);

    @Override
    default public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> type = this.getExactTypeIfKnown(keyspace);
        return type == null ? AssignmentTestable.TestResult.NOT_ASSIGNABLE : type.testAssignment(keyspace, receiver);
    }

    default public int addAndGetIndex(ColumnDefinition def, List<ColumnDefinition> l) {
        int idx = l.indexOf(def);
        if (idx < 0) {
            idx = l.size();
            l.add(def);
        }
        return idx;
    }

    public static class WithFieldSelection
    implements Selectable {
        public final Selectable selected;
        public final FieldIdentifier field;

        public WithFieldSelection(Selectable selected, FieldIdentifier field) {
            this.selected = selected;
            this.field = field;
        }

        public String toString() {
            return String.format("%s.%s", this.selected, this.field);
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) {
            Selector.Factory factory = this.selected.newSelectorFactory(cfm, null, defs, boundNames);
            AbstractType<?> type = factory.getColumnSpecification((CFMetaData)cfm).type;
            if (!type.isUDT()) {
                throw new InvalidRequestException(String.format("Invalid field selection: %s of type %s is not a user type", this.selected, type.asCQL3Type()));
            }
            UserType ut = (UserType)type;
            int fieldIndex = ut.fieldPosition(this.field);
            if (fieldIndex == -1) {
                throw new InvalidRequestException(String.format("%s of type %s has no field %s", this.selected, type.asCQL3Type(), this.field));
            }
            return FieldSelector.newFactory(ut, fieldIndex, factory);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            AbstractType<?> selectedType = this.selected.getExactTypeIfKnown(keyspace);
            if (selectedType == null || !(selectedType instanceof UserType)) {
                return null;
            }
            UserType ut = (UserType)selectedType;
            int fieldIndex = ut.fieldPosition(this.field);
            if (fieldIndex == -1) {
                return null;
            }
            return ut.fieldType(fieldIndex);
        }

        public static class Raw
        extends org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final org.apache.cassandra.cql3.selection.Selectable$Raw selected;
            private final FieldIdentifier field;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw selected, FieldIdentifier field) {
                this.selected = selected;
                this.field = field;
            }

            @Override
            public WithFieldSelection prepare(CFMetaData cfm) {
                return new WithFieldSelection(this.selected.prepare(cfm), this.field);
            }
        }
    }

    public static class WithCast
    implements Selectable {
        private final CQL3Type type;
        private final Selectable arg;

        public WithCast(Selectable arg, CQL3Type type) {
            this.arg = arg;
            this.type = type;
        }

        public String toString() {
            return String.format("cast(%s as %s)", this.arg, this.type.toString().toLowerCase());
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) {
            List<Selectable> args = Collections.singletonList(this.arg);
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(args, null, cfm, defs, boundNames);
            Selector.Factory factory = factories.get(0);
            if (this.type.getType().equals(factory.getReturnType())) {
                return factory;
            }
            FunctionName name = FunctionName.nativeFunction(CastFcts.getFunctionName(this.type));
            Function fun = FunctionResolver.get(cfm.ksName, name, args, cfm.ksName, cfm.cfName, null);
            if (fun == null) {
                throw new InvalidRequestException(String.format("%s cannot be cast to %s", defs.get((int)0).name, this.type));
            }
            return AbstractFunctionSelector.newFactory(fun, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.type.getType();
        }

        public static class Raw
        extends org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final CQL3Type type;
            private final org.apache.cassandra.cql3.selection.Selectable$Raw arg;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw arg, CQL3Type type) {
                this.arg = arg;
                this.type = type;
            }

            @Override
            public WithCast prepare(CFMetaData cfm) {
                return new WithCast(this.arg.prepare(cfm), this.type);
            }
        }
    }

    public static class WithToJSonFunction
    implements Selectable {
        public final List<Selectable> args;

        private WithToJSonFunction(List<Selectable> args) {
            this.args = args;
        }

        public String toString() {
            return new StrBuilder().append((Object)ToJsonFct.NAME).append("(").appendWithSeparators(this.args, ", ").append(")").toString();
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.args, null, cfm, defs, boundNames);
            ToJsonFct fun = ToJsonFct.getInstance(factories.getReturnTypes());
            return AbstractFunctionSelector.newFactory(fun, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return UTF8Type.instance;
        }
    }

    public static class WithFunction
    implements Selectable {
        public final Function function;
        public final List<Selectable> args;

        public WithFunction(Function function, List<Selectable> args) {
            this.function = function;
            this.args = args;
        }

        public String toString() {
            return new StrBuilder().append((Object)this.function.name()).append("(").appendWithSeparators(this.args, ", ").append(")").toString();
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.args, this.function.argTypes(), cfm, defs, boundNames);
            return AbstractFunctionSelector.newFactory(this.function, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.function.returnType();
        }

        public static class Raw
        extends org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final FunctionName functionName;
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> args;

            public Raw(FunctionName functionName, List<org.apache.cassandra.cql3.selection.Selectable$Raw> args) {
                this.functionName = functionName;
                this.args = args;
            }

            public static Raw newCountRowsFunction() {
                return new Raw(AggregateFcts.countRowsFunction.name(), Collections.emptyList());
            }

            @Override
            public Selectable prepare(CFMetaData cfm) {
                Function fun;
                List<Selectable> preparedArgs = new ArrayList<Selectable>(this.args.size());
                for (org.apache.cassandra.cql3.selection.Selectable$Raw arg : this.args) {
                    preparedArgs.add(arg.prepare(cfm));
                }
                FunctionName name = this.functionName;
                if (this.functionName.equalsNativeFunction(ToJsonFct.NAME)) {
                    return new WithToJSonFunction(preparedArgs);
                }
                if (this.functionName.equalsNativeFunction(FunctionName.nativeFunction("count")) && preparedArgs.size() == 1 && preparedArgs.get(0) instanceof WithTerm && ((WithTerm)preparedArgs.get(0)).rawTerm instanceof Constants.Literal) {
                    name = AggregateFcts.countRowsFunction.name();
                    preparedArgs = Collections.emptyList();
                }
                if ((fun = FunctionResolver.get(cfm.ksName, name, preparedArgs, cfm.ksName, cfm.cfName, null)) == null) {
                    throw new InvalidRequestException(String.format("Unknown function '%s'", this.functionName));
                }
                if (fun.returnType() == null) {
                    throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", this.functionName));
                }
                return new WithFunction(fun, preparedArgs);
            }
        }
    }

    public static class WritetimeOrTTL
    implements Selectable {
        public final ColumnDefinition column;
        public final boolean isWritetime;

        public WritetimeOrTTL(ColumnDefinition column, boolean isWritetime) {
            this.column = column;
            this.isWritetime = isWritetime;
        }

        public String toString() {
            return (this.isWritetime ? "writetime" : "ttl") + "(" + this.column.name + ")";
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) {
            if (this.column.isPrimaryKeyColumn()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", this.isWritetime ? "writeTime" : "ttl", this.column.name));
            }
            if (this.column.type.isCollection()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on collections", this.isWritetime ? "writeTime" : "ttl"));
            }
            return WritetimeOrTTLSelector.newFactory(this.column, this.addAndGetIndex(this.column, defs), this.isWritetime);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.isWritetime ? LongType.instance : Int32Type.instance;
        }

        public static class Raw
        extends org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final ColumnDefinition.Raw id;
            private final boolean isWritetime;

            public Raw(ColumnDefinition.Raw id, boolean isWritetime) {
                this.id = id;
                this.isWritetime = isWritetime;
            }

            @Override
            public WritetimeOrTTL prepare(CFMetaData cfm) {
                return new WritetimeOrTTL(this.id.prepare(cfm), this.isWritetime);
            }
        }
    }

    public static class WithTerm
    implements Selectable {
        private static final ColumnIdentifier bindMarkerNameInSelection = new ColumnIdentifier("[selection]", true);
        private final Term.Raw rawTerm;

        public WithTerm(Term.Raw rawTerm) {
            this.rawTerm = rawTerm;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return this.rawTerm.testAssignment(keyspace, receiver);
        }

        @Override
        public Selector.Factory newSelectorFactory(CFMetaData cfm, AbstractType<?> expectedType, List<ColumnDefinition> defs, VariableSpecifications boundNames) throws InvalidRequestException {
            AbstractType<?> type = this.getExactTypeIfKnown(cfm.ksName);
            if (type == null && (type = expectedType) == null) {
                throw new InvalidRequestException("Cannot infer type for term " + this + " in selection clause (try using a cast to force a type)");
            }
            Term term = this.rawTerm.prepare(cfm.ksName, new ColumnSpecification(cfm.ksName, cfm.cfName, bindMarkerNameInSelection, type));
            term.collectMarkerSpecification(boundNames);
            return TermSelector.newFactory(this.rawTerm.getText(), term, type);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.rawTerm.getExactTypeIfKnown(keyspace);
        }

        public String toString() {
            return this.rawTerm.toString();
        }

        public static class Raw
        extends org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final Term.Raw term;

            public Raw(Term.Raw term) {
                this.term = term;
            }

            @Override
            public Selectable prepare(CFMetaData cfm) {
                return new WithTerm(this.term);
            }
        }
    }

    public static abstract class Raw {
        public abstract Selectable prepare(CFMetaData var1);

        public boolean processesSelection() {
            return true;
        }
    }
}

