/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AuthKeyspace;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.PasswordAuthenticator;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraRoleManager
implements IRoleManager {
    private static final Logger logger = LoggerFactory.getLogger(CassandraRoleManager.class);
    static final String DEFAULT_SUPERUSER_NAME = "cassandra";
    static final String DEFAULT_SUPERUSER_PASSWORD = "cassandra";
    private static final Function<UntypedResultSet.Row, Role> ROW_TO_ROLE = new Function<UntypedResultSet.Row, Role>(){

        public Role apply(UntypedResultSet.Row row) {
            try {
                return new Role(row.getString("role"), row.getBoolean("is_superuser"), row.getBoolean("can_login"), row.has("member_of") ? row.getSet("member_of", UTF8Type.instance) : Collections.emptySet());
            }
            catch (NullPointerException e) {
                logger.warn("An invalid value has been detected in the {} table for role {}. If you are unable to login, you may need to disable authentication and confirm that values in that table are accurate", (Object)"roles", (Object)row.getString("role"));
                throw new RuntimeException(String.format("Invalid metadata has been detected for role %s", row.getString("role")), e);
            }
        }
    };
    public static final String LEGACY_USERS_TABLE = "users";
    private static final Function<UntypedResultSet.Row, Role> LEGACY_ROW_TO_ROLE = new Function<UntypedResultSet.Row, Role>(){

        public Role apply(UntypedResultSet.Row row) {
            return new Role(row.getString("name"), row.getBoolean("super"), true, Collections.emptySet());
        }
    };
    private static final String GENSALT_LOG2_ROUNDS_PROPERTY = "cassandra.auth_bcrypt_gensalt_log2_rounds";
    private static final int GENSALT_LOG2_ROUNDS = CassandraRoleManager.getGensaltLogRounds();
    private static final Role NULL_ROLE = new Role(null, false, false, Collections.emptySet());
    private SelectStatement loadRoleStatement;
    private SelectStatement legacySelectUserStatement;
    private final Set<IRoleManager.Option> supportedOptions = DatabaseDescriptor.getAuthenticator().getClass() == PasswordAuthenticator.class ? ImmutableSet.of((Object)((Object)IRoleManager.Option.LOGIN), (Object)((Object)IRoleManager.Option.SUPERUSER), (Object)((Object)IRoleManager.Option.PASSWORD)) : ImmutableSet.of((Object)((Object)IRoleManager.Option.LOGIN), (Object)((Object)IRoleManager.Option.SUPERUSER));
    private final Set<IRoleManager.Option> alterableOptions = DatabaseDescriptor.getAuthenticator().getClass().equals(PasswordAuthenticator.class) ? ImmutableSet.of((Object)((Object)IRoleManager.Option.PASSWORD)) : ImmutableSet.of();
    private volatile boolean isClusterReady = false;

    static int getGensaltLogRounds() {
        int rounds = Integer.getInteger(GENSALT_LOG2_ROUNDS_PROPERTY, 10);
        if (rounds < 4 || rounds > 31) {
            throw new ConfigurationException(String.format("Bad value for system property -D%s.Please use a value between 4 and 31 inclusively", GENSALT_LOG2_ROUNDS_PROPERTY));
        }
        return rounds;
    }

    @Override
    public void setup() {
        this.loadRoleStatement = (SelectStatement)this.prepare("SELECT * from %s.%s WHERE role = ?", "system_auth", "roles");
        if (Schema.instance.getCFMetaData("system_auth", LEGACY_USERS_TABLE) != null) {
            this.legacySelectUserStatement = this.prepareLegacySelectUserStatement();
            this.scheduleSetupTask(() -> {
                this.convertLegacyData();
                return null;
            });
        } else {
            this.scheduleSetupTask(() -> {
                CassandraRoleManager.setupDefaultRole();
                return null;
            });
        }
    }

    @Override
    public Set<IRoleManager.Option> supportedOptions() {
        return this.supportedOptions;
    }

    @Override
    public Set<IRoleManager.Option> alterableOptions() {
        return this.alterableOptions;
    }

    @Override
    public void createRole(AuthenticatedUser performer, RoleResource role, RoleOptions options) throws RequestValidationException, RequestExecutionException {
        String insertCql = options.getPassword().isPresent() ? String.format("INSERT INTO %s.%s (role, is_superuser, can_login, salted_hash) VALUES ('%s', %s, %s, '%s')", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName()), options.getSuperuser().or((Object)false), options.getLogin().or((Object)false), CassandraRoleManager.escape(CassandraRoleManager.hashpw((String)options.getPassword().get()))) : String.format("INSERT INTO %s.%s (role, is_superuser, can_login) VALUES ('%s', %s, %s)", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName()), options.getSuperuser().or((Object)false), options.getLogin().or((Object)false));
        this.process(insertCql, CassandraRoleManager.consistencyForRole(role.getRoleName()));
    }

    @Override
    public void dropRole(AuthenticatedUser performer, RoleResource role) throws RequestValidationException, RequestExecutionException {
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "roles", CassandraRoleManager.escape(role.getRoleName())), CassandraRoleManager.consistencyForRole(role.getRoleName()));
        this.removeAllMembers(role.getRoleName());
    }

    @Override
    public void alterRole(AuthenticatedUser performer, RoleResource role, RoleOptions options) {
        String assignments = Joiner.on((char)',').join(Iterables.filter(this.optionsToAssignments(options.getOptions()), (Predicate)Predicates.notNull()));
        if (!Strings.isNullOrEmpty((String)assignments)) {
            this.process(String.format("UPDATE %s.%s SET %s WHERE role = '%s'", "system_auth", "roles", assignments, CassandraRoleManager.escape(role.getRoleName())), CassandraRoleManager.consistencyForRole(role.getRoleName()));
        }
    }

    @Override
    public void grantRole(AuthenticatedUser performer, RoleResource role, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        if (this.getRoles(grantee, true).contains(role)) {
            throw new InvalidRequestException(String.format("%s is a member of %s", grantee.getRoleName(), role.getRoleName()));
        }
        if (this.getRoles(role, true).contains(grantee)) {
            throw new InvalidRequestException(String.format("%s is a member of %s", role.getRoleName(), grantee.getRoleName()));
        }
        this.modifyRoleMembership(grantee.getRoleName(), role.getRoleName(), "+");
        this.process(String.format("INSERT INTO %s.%s (role, member) values ('%s', '%s')", "system_auth", "role_members", CassandraRoleManager.escape(role.getRoleName()), CassandraRoleManager.escape(grantee.getRoleName())), CassandraRoleManager.consistencyForRole(role.getRoleName()));
    }

    @Override
    public void revokeRole(AuthenticatedUser performer, RoleResource role, RoleResource revokee) throws RequestValidationException, RequestExecutionException {
        if (!this.getRoles(revokee, false).contains(role)) {
            throw new InvalidRequestException(String.format("%s is not a member of %s", revokee.getRoleName(), role.getRoleName()));
        }
        this.modifyRoleMembership(revokee.getRoleName(), role.getRoleName(), "-");
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s' and member = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role.getRoleName()), CassandraRoleManager.escape(revokee.getRoleName())), CassandraRoleManager.consistencyForRole(role.getRoleName()));
    }

    @Override
    public Set<RoleResource> getRoles(RoleResource grantee, boolean includeInherited) throws RequestValidationException, RequestExecutionException {
        HashSet<RoleResource> roles = new HashSet<RoleResource>();
        Role role = this.getRole(grantee.getRoleName());
        if (!role.equals(NULL_ROLE)) {
            roles.add(RoleResource.role(role.name));
            this.collectRoles(role, roles, includeInherited);
        }
        return roles;
    }

    @Override
    public Set<RoleResource> getAllRoles() throws RequestValidationException, RequestExecutionException {
        UntypedResultSet rows = this.process(String.format("SELECT role from %s.%s", "system_auth", "roles"), ConsistencyLevel.QUORUM);
        Iterable roles = Iterables.transform((Iterable)rows, (Function)new Function<UntypedResultSet.Row, RoleResource>(){

            public RoleResource apply(UntypedResultSet.Row row) {
                return RoleResource.role(row.getString("role"));
            }
        });
        return ImmutableSet.builder().addAll(roles).build();
    }

    @Override
    public boolean isSuper(RoleResource role) {
        return this.getRole(role.getRoleName()).isSuper;
    }

    @Override
    public boolean canLogin(RoleResource role) {
        return this.getRole(role.getRoleName()).canLogin;
    }

    @Override
    public Map<String, String> getCustomOptions(RoleResource role) {
        return Collections.emptyMap();
    }

    @Override
    public boolean isExistingRole(RoleResource role) {
        return this.getRole(role.getRoleName()) != NULL_ROLE;
    }

    @Override
    public Set<? extends IResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table("system_auth", "roles"), (Object)DataResource.table("system_auth", "role_members"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    private static void setupDefaultRole() {
        try {
            if (!CassandraRoleManager.hasExistingRoles()) {
                QueryProcessor.process(String.format("INSERT INTO %s.%s (role, is_superuser, can_login, salted_hash) VALUES ('%s', true, true, '%s')", "system_auth", "roles", "cassandra", CassandraRoleManager.escape(CassandraRoleManager.hashpw("cassandra"))), CassandraRoleManager.consistencyForRole("cassandra"));
                logger.info("Created default superuser role '{}'", (Object)"cassandra");
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("CassandraRoleManager skipped default role setup: some nodes were not ready");
            throw e;
        }
    }

    private static boolean hasExistingRoles() throws RequestExecutionException {
        String defaultSUQuery = String.format("SELECT * FROM %s.%s WHERE role = '%s'", "system_auth", "roles", "cassandra");
        String allUsersQuery = String.format("SELECT * FROM %s.%s LIMIT 1", "system_auth", "roles");
        return !QueryProcessor.process(defaultSUQuery, ConsistencyLevel.ONE).isEmpty() || !QueryProcessor.process(defaultSUQuery, ConsistencyLevel.QUORUM).isEmpty() || !QueryProcessor.process(allUsersQuery, ConsistencyLevel.QUORUM).isEmpty();
    }

    private void scheduleSetupTask(final Callable<Void> setupTask) {
        ScheduledExecutors.optionalTasks.schedule(new Runnable(){

            @Override
            public void run() {
                if (!MessagingService.instance().areAllNodesAtLeast22()) {
                    logger.trace("Not all nodes are upgraded to a version that supports Roles yet, rescheduling setup task");
                    CassandraRoleManager.this.scheduleSetupTask(setupTask);
                    return;
                }
                CassandraRoleManager.this.isClusterReady = true;
                try {
                    setupTask.call();
                }
                catch (Exception e) {
                    logger.info("Setup task failed with error, rescheduling");
                    CassandraRoleManager.this.scheduleSetupTask(setupTask);
                }
            }
        }, AuthKeyspace.SUPERUSER_SETUP_DELAY, TimeUnit.MILLISECONDS);
    }

    private void convertLegacyData() throws Exception {
        try {
            if (Schema.instance.getCFMetaData("system_auth", LEGACY_USERS_TABLE) != null) {
                logger.info("Converting legacy users");
                UntypedResultSet users = QueryProcessor.process("SELECT * FROM system_auth.users", ConsistencyLevel.QUORUM);
                for (UntypedResultSet.Row row : users) {
                    RoleOptions options = new RoleOptions();
                    options.setOption(IRoleManager.Option.SUPERUSER, row.getBoolean("super"));
                    options.setOption(IRoleManager.Option.LOGIN, true);
                    this.createRole(null, RoleResource.role(row.getString("name")), options);
                }
                logger.info("Completed conversion of legacy users");
            }
            if (Schema.instance.getCFMetaData("system_auth", "credentials") != null) {
                logger.info("Migrating legacy credentials data to new system table");
                UntypedResultSet credentials = QueryProcessor.process("SELECT * FROM system_auth.credentials", ConsistencyLevel.QUORUM);
                for (UntypedResultSet.Row row : credentials) {
                    QueryProcessor.process(String.format("UPDATE %s.%s SET salted_hash = '%s' WHERE role = '%s'", "system_auth", "roles", row.getString("salted_hash"), row.getString("username")), CassandraRoleManager.consistencyForRole(row.getString("username")));
                }
                logger.info("Completed conversion of legacy credentials");
            }
        }
        catch (Exception e) {
            logger.info("Unable to complete conversion of legacy auth data (perhaps not enough nodes are upgraded yet). Conversion should not be considered complete");
            logger.trace("Conversion error", (Throwable)e);
            throw e;
        }
    }

    private SelectStatement prepareLegacySelectUserStatement() {
        return (SelectStatement)this.prepare("SELECT * FROM %s.%s WHERE name = ?", "system_auth", LEGACY_USERS_TABLE);
    }

    private CQLStatement prepare(String template, String keyspace, String table) {
        try {
            return QueryProcessor.parseStatement((String)String.format((String)template, (Object[])new Object[]{keyspace, table})).prepare().statement;
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void collectRoles(Role role, Set<RoleResource> collected, boolean includeInherited) throws RequestValidationException, RequestExecutionException {
        for (String memberOf : role.memberOf) {
            Role granted = this.getRole(memberOf);
            if (granted.equals(NULL_ROLE)) continue;
            collected.add(RoleResource.role(granted.name));
            if (!includeInherited) continue;
            this.collectRoles(granted, collected, true);
        }
    }

    private Role getRole(String name) {
        try {
            if (Schema.instance.getCFMetaData("system_auth", LEGACY_USERS_TABLE) == null) {
                return this.getRoleFromTable(name, this.loadRoleStatement, ROW_TO_ROLE);
            }
            if (this.legacySelectUserStatement == null) {
                this.legacySelectUserStatement = this.prepareLegacySelectUserStatement();
            }
            return this.getRoleFromTable(name, this.legacySelectUserStatement, LEGACY_ROW_TO_ROLE);
        }
        catch (RequestExecutionException | RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private Role getRoleFromTable(String name, SelectStatement statement, Function<UntypedResultSet.Row, Role> function) throws RequestExecutionException, RequestValidationException {
        ResultMessage.Rows rows = statement.execute(QueryState.forInternalCalls(), QueryOptions.forInternalCalls(CassandraRoleManager.consistencyForRole(name), Collections.singletonList(ByteBufferUtil.bytes(name))), System.nanoTime());
        if (rows.result.isEmpty()) {
            return NULL_ROLE;
        }
        return (Role)function.apply((Object)UntypedResultSet.create(rows.result).one());
    }

    private void modifyRoleMembership(String grantee, String role, String op) throws RequestExecutionException {
        this.process(String.format("UPDATE %s.%s SET member_of = member_of %s {'%s'} WHERE role = '%s'", "system_auth", "roles", op, CassandraRoleManager.escape(role), CassandraRoleManager.escape(grantee)), CassandraRoleManager.consistencyForRole(grantee));
    }

    private void removeAllMembers(String role) throws RequestValidationException, RequestExecutionException {
        UntypedResultSet rows = this.process(String.format("SELECT member FROM %s.%s WHERE role = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role)), CassandraRoleManager.consistencyForRole(role));
        if (rows.isEmpty()) {
            return;
        }
        for (UntypedResultSet.Row row : rows) {
            this.modifyRoleMembership(row.getString("member"), role, "-");
        }
        this.process(String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "role_members", CassandraRoleManager.escape(role)), CassandraRoleManager.consistencyForRole(role));
    }

    private Iterable<String> optionsToAssignments(Map<IRoleManager.Option, Object> options) {
        return Iterables.transform(options.entrySet(), (Function)new Function<Map.Entry<IRoleManager.Option, Object>, String>(){

            public String apply(Map.Entry<IRoleManager.Option, Object> entry) {
                switch (entry.getKey()) {
                    case LOGIN: {
                        return String.format("can_login = %s", entry.getValue());
                    }
                    case SUPERUSER: {
                        return String.format("is_superuser = %s", entry.getValue());
                    }
                    case PASSWORD: {
                        return String.format("salted_hash = '%s'", CassandraRoleManager.escape(CassandraRoleManager.hashpw((String)entry.getValue())));
                    }
                }
                return null;
            }
        });
    }

    protected static ConsistencyLevel consistencyForRole(String role) {
        if (role.equals("cassandra")) {
            return ConsistencyLevel.QUORUM;
        }
        return ConsistencyLevel.LOCAL_ONE;
    }

    private static String hashpw(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)GENSALT_LOG2_ROUNDS));
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private UntypedResultSet process(String query, ConsistencyLevel consistencyLevel) throws RequestValidationException, RequestExecutionException {
        if (!this.isClusterReady) {
            throw new InvalidRequestException("Cannot process role related query as the role manager isn't yet setup. This is likely because some of nodes in the cluster are on version 2.1 or earlier. You need to upgrade all nodes to Cassandra 2.2 or more to use roles.");
        }
        return QueryProcessor.process(query, consistencyLevel);
    }

    private static final class Role {
        private String name;
        private final boolean isSuper;
        private final boolean canLogin;
        private Set<String> memberOf;

        private Role(String name, boolean isSuper, boolean canLogin, Set<String> memberOf) {
            this.name = name;
            this.isSuper = isSuper;
            this.canLogin = canLogin;
            this.memberOf = memberOf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role r = (Role)o;
            return Objects.equal((Object)this.name, (Object)r.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }
    }
}

