/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="compact", description="Force a (major) compaction on one or more tables")
public class Compact
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="split_output", name={"-s", "--split-output"}, description="Use -s to not create a single big file")
    private boolean splitOutput = false;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] tableNames = this.parseOptionalTables(this.args);
        for (String keyspace : keyspaces) {
            try {
                probe.forceKeyspaceCompaction(this.splitOutput, keyspace, tableNames);
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred during compaction", e);
            }
        }
    }
}

