/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;

abstract class AbstractQueryPager
implements QueryPager {
    protected final ReadCommand command;
    protected final DataLimits limits;
    protected final int protocolVersion;
    private int remaining;
    private DecoratedKey lastKey;
    private int remainingInPartition;
    private boolean exhausted;

    protected AbstractQueryPager(ReadCommand command, int protocolVersion) {
        this.command = command;
        this.protocolVersion = protocolVersion;
        this.limits = command.limits();
        this.remaining = this.limits.count();
        this.remainingInPartition = this.limits.perPartitionCount();
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        return this.command.startOrderGroup();
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return EmptyIterators.partition();
        }
        pageSize = Math.min(pageSize, this.remaining);
        Pager pager = new Pager(this.limits.forPaging(pageSize), this.command.nowInSec());
        return Transformation.apply(this.nextPageReadCommand(pageSize).execute(consistency, clientState), pager);
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadOrderGroup orderGroup) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return EmptyIterators.partition();
        }
        pageSize = Math.min(pageSize, this.remaining);
        Pager pager = new Pager(this.limits.forPaging(pageSize), this.command.nowInSec());
        return Transformation.apply(this.nextPageReadCommand(pageSize).executeInternal(orderGroup), pager);
    }

    protected void restoreState(DecoratedKey lastKey, int remaining, int remainingInPartition) {
        this.lastKey = lastKey;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0 || this instanceof SinglePartitionPager && this.remainingInPartition == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    protected int remainingInPartition() {
        return this.remainingInPartition;
    }

    protected abstract ReadCommand nextPageReadCommand(int var1);

    protected abstract void recordLast(DecoratedKey var1, Row var2);

    protected abstract boolean isPreviouslyReturnedPartition(DecoratedKey var1);

    private class Pager
    extends Transformation<RowIterator> {
        private final DataLimits pageLimits;
        private final DataLimits.Counter counter;
        private Row lastRow;
        private boolean isFirstPartition = true;

        private Pager(DataLimits pageLimits, int nowInSec) {
            this.counter = pageLimits.newCounter(nowInSec, true);
            this.pageLimits = pageLimits;
        }

        @Override
        public RowIterator applyToPartition(RowIterator partition) {
            DecoratedKey key = partition.partitionKey();
            if (AbstractQueryPager.this.lastKey == null || !AbstractQueryPager.this.lastKey.equals(key)) {
                AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.limits.perPartitionCount();
            }
            AbstractQueryPager.this.lastKey = key;
            if (this.isFirstPartition) {
                this.isFirstPartition = false;
                if (AbstractQueryPager.this.isPreviouslyReturnedPartition(key) && !partition.hasNext()) {
                    partition.close();
                    return null;
                }
            }
            return Transformation.apply(this.counter.applyTo(partition), this);
        }

        @Override
        public void onClose() {
            AbstractQueryPager.this.recordLast(AbstractQueryPager.this.lastKey, this.lastRow);
            int counted = this.counter.counted();
            AbstractQueryPager.this.remaining = AbstractQueryPager.this.remaining - counted;
            if (this.lastRow != null && this.lastRow.clustering() == Clustering.STATIC_CLUSTERING) {
                AbstractQueryPager.this.remainingInPartition = 0;
            } else {
                AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.remainingInPartition - this.counter.countedInCurrentPartition();
            }
            AbstractQueryPager.this.exhausted = counted < this.pageLimits.count();
        }

        @Override
        public Row applyToStatic(Row row) {
            if (!row.isEmpty()) {
                this.lastRow = row;
            }
            return row;
        }

        @Override
        public Row applyToRow(Row row) {
            this.lastRow = row;
            return row;
        }
    }
}

