/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public final class Types
implements Iterable<UserType> {
    private static final Types NONE = new Types((Map<ByteBuffer, UserType>)ImmutableMap.of());
    private final Map<ByteBuffer, UserType> types;

    private Types(Builder builder) {
        this.types = builder.types.build();
    }

    private Types(Map<ByteBuffer, UserType> types) {
        this.types = types;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RawBuilder rawBuilder(String keyspace) {
        return new RawBuilder(keyspace);
    }

    public static Types none() {
        return NONE;
    }

    public static Types of(UserType ... types) {
        return Types.builder().add(types).build();
    }

    @Override
    public Iterator<UserType> iterator() {
        return this.types.values().iterator();
    }

    public Optional<UserType> get(ByteBuffer name) {
        return Optional.ofNullable(this.types.get(name));
    }

    @Nullable
    public UserType getNullable(ByteBuffer name) {
        return this.types.get(name);
    }

    public Types with(UserType type) {
        if (this.get(type.name).isPresent()) {
            throw new IllegalStateException(String.format("Type %s already exists", type.name));
        }
        return Types.builder().add(this).add(type).build();
    }

    public Types without(ByteBuffer name) {
        UserType type = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Type %s doesn't exists", name)));
        return Types.builder().add(Iterables.filter((Iterable)this, t -> t != type)).build();
    }

    MapDifference<ByteBuffer, UserType> diff(Types other) {
        return Maps.difference(this.types, other.types);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Types && this.types.equals(((Types)o).types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return this.types.values().toString();
    }

    public static final class RawBuilder {
        final String keyspace;
        final List<RawUDT> definitions;

        private RawBuilder(String keyspace) {
            this.keyspace = keyspace;
            this.definitions = new ArrayList<RawUDT>();
        }

        public Types build() {
            if (this.definitions.isEmpty()) {
                return Types.none();
            }
            DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
            this.definitions.forEach(arg_0 -> ((DefaultDirectedGraph)graph).addVertex(arg_0));
            for (RawUDT udt1 : this.definitions) {
                for (RawUDT udt2 : this.definitions) {
                    if (udt1 == udt2 || !udt1.referencesUserType(udt2.name)) continue;
                    graph.addEdge((Object)udt2, (Object)udt1);
                }
            }
            Types types = new Types(new HashMap());
            TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)graph);
            while (iterator.hasNext()) {
                UserType udt = ((RawUDT)iterator.next()).prepare(this.keyspace, types);
                types.types.put(udt.name, udt);
            }
            return Types.builder().add(types).build();
        }

        public void add(String name, List<String> fieldNames, List<String> fieldTypes) {
            List<CQL3Type.Raw> rawFieldTypes = fieldTypes.stream().map(CQLTypeParser::parseRaw).collect(Collectors.toList());
            this.definitions.add(new RawUDT(name, fieldNames, rawFieldTypes));
        }

        private static final class RawUDT {
            final String name;
            final List<String> fieldNames;
            final List<CQL3Type.Raw> fieldTypes;

            RawUDT(String name, List<String> fieldNames, List<CQL3Type.Raw> fieldTypes) {
                this.name = name;
                this.fieldNames = fieldNames;
                this.fieldTypes = fieldTypes;
            }

            boolean referencesUserType(String typeName) {
                return this.fieldTypes.stream().anyMatch(t -> t.referencesUserType(typeName));
            }

            UserType prepare(String keyspace, Types types) {
                List<ByteBuffer> preparedFieldNames = this.fieldNames.stream().map(ByteBufferUtil::bytes).collect(Collectors.toList());
                List<AbstractType<?>> preparedFieldTypes = this.fieldTypes.stream().map(t -> t.prepareInternal(keyspace, types).getType()).collect(Collectors.toList());
                return new UserType(keyspace, ByteBufferUtil.bytes(this.name), preparedFieldNames, preparedFieldTypes);
            }
        }
    }

    public static final class Builder {
        final ImmutableMap.Builder<ByteBuffer, UserType> types = ImmutableMap.builder();

        private Builder() {
        }

        public Types build() {
            return new Types(this);
        }

        public Builder add(UserType type) {
            this.types.put((Object)type.name, (Object)type);
            return this;
        }

        public Builder add(UserType ... types) {
            for (UserType type : types) {
                this.add(type);
            }
            return this;
        }

        public Builder add(Iterable<UserType> types) {
            types.forEach(this::add);
            return this;
        }
    }
}

