/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class SnapshotMessage
extends RepairMessage {
    public static final RepairMessage.MessageSerializer serializer = new SnapshotMessageSerializer();

    public SnapshotMessage(RepairJobDesc desc) {
        super(RepairMessage.Type.SNAPSHOT, desc);
    }

    public static class SnapshotMessageSerializer
    implements RepairMessage.MessageSerializer<SnapshotMessage> {
        @Override
        public void serialize(SnapshotMessage message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
        }

        @Override
        public SnapshotMessage deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            return new SnapshotMessage(desc);
        }

        @Override
        public long serializedSize(SnapshotMessage message, int version) {
            return RepairJobDesc.serializer.serializedSize(message.desc, version);
        }
    }
}

