/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintsBuffer;

final class HintsBufferPool {
    private volatile HintsBuffer currentBuffer;
    private final Queue<HintsBuffer> reserveBuffers = new ConcurrentLinkedQueue<HintsBuffer>();
    private final int bufferSize;
    private final FlushCallback flushCallback;

    HintsBufferPool(int bufferSize, FlushCallback flushCallback) {
        this.bufferSize = bufferSize;
        this.flushCallback = flushCallback;
    }

    void write(Iterable<UUID> hostIds, Hint hint) {
        int hintSize = (int)Hint.serializer.serializedSize(hint, 10);
        try (HintsBuffer.Allocation allocation = this.allocate(hintSize);){
            allocation.write(hostIds, hint);
        }
    }

    private HintsBuffer.Allocation allocate(int hintSize) {
        HintsBuffer current = this.currentBuffer();
        HintsBuffer.Allocation allocation;
        while ((allocation = current.allocate(hintSize)) == null) {
            if (this.switchCurrentBuffer(current)) {
                this.flushCallback.flush(current, this);
            }
            current = this.currentBuffer;
        }
        return allocation;
    }

    boolean offer(HintsBuffer buffer) {
        if (!this.reserveBuffers.isEmpty()) {
            return false;
        }
        this.reserveBuffers.offer(buffer);
        return true;
    }

    HintsBuffer currentBuffer() {
        if (this.currentBuffer == null) {
            this.initializeCurrentBuffer();
        }
        return this.currentBuffer;
    }

    private synchronized void initializeCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.createBuffer();
        }
    }

    private synchronized boolean switchCurrentBuffer(HintsBuffer previous) {
        if (this.currentBuffer != previous) {
            return false;
        }
        HintsBuffer buffer = this.reserveBuffers.poll();
        this.currentBuffer = buffer == null ? this.createBuffer() : buffer;
        return true;
    }

    private HintsBuffer createBuffer() {
        return HintsBuffer.create(this.bufferSize);
    }

    static interface FlushCallback {
        public void flush(HintsBuffer var1, HintsBufferPool var2);
    }
}

