/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.Pair;

public class Bounds<T extends RingPosition<T>>
extends AbstractBounds<T> {
    public Bounds(T left, T right) {
        super(left, right);
        assert (!Bounds.strictlyWrapsAround(left, right)) : "[" + left + "," + right + "]";
    }

    @Override
    public boolean contains(T position) {
        return this.left.equals(position) || (this.right.isMinimum() || !this.left.equals(this.right)) && Range.contains(this.left, this.right, position);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position));
        if (position.equals(this.right)) {
            return null;
        }
        Bounds<RingPosition> lb = new Bounds<RingPosition>(this.left, (RingPosition)position);
        Range<RingPosition> rb = new Range<RingPosition>((RingPosition)position, this.right);
        return Pair.create(lb, rb);
    }

    @Override
    public boolean inclusiveLeft() {
        return true;
    }

    @Override
    public boolean inclusiveRight() {
        return true;
    }

    public boolean intersects(Bounds<T> that) {
        return this.contains(that.left) || this.contains(that.right) || that.contains(this.left);
    }

    @Override
    public List<? extends AbstractBounds<T>> unwrap() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Bounds)) {
            return false;
        }
        Bounds rhs = (Bounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + "]";
    }

    @Override
    protected String getOpeningString() {
        return "[";
    }

    @Override
    protected String getClosingString() {
        return "]";
    }

    @Override
    public boolean isStartInclusive() {
        return true;
    }

    @Override
    public boolean isEndInclusive() {
        return true;
    }

    public static Bounds<PartitionPosition> makeRowBounds(Token left, Token right) {
        return new Bounds<PartitionPosition>(left.minKeyBound(), right.maxKeyBound());
    }

    @Override
    public AbstractBounds<T> withNewRight(T newRight) {
        return new Bounds<RingPosition>(this.left, (RingPosition)newRight);
    }
}

