/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.concurrent.Transactional;

public abstract class CompactionAwareWriter
extends Transactional.AbstractTransactional
implements Transactional {
    protected final ColumnFamilyStore cfs;
    protected final Directories directories;
    protected final Set<SSTableReader> nonExpiredSSTables;
    protected final long estimatedTotalKeys;
    protected final long maxAge;
    protected final long minRepairedAt;
    protected final LifecycleTransaction txn;
    protected final SSTableRewriter sstableWriter;
    private boolean isInitialized = false;

    public CompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline, boolean keepOriginals) {
        this.cfs = cfs;
        this.directories = directories;
        this.nonExpiredSSTables = nonExpiredSSTables;
        this.estimatedTotalKeys = SSTableReader.getApproximateKeyCount(nonExpiredSSTables);
        this.maxAge = CompactionTask.getMaxDataAge(nonExpiredSSTables);
        this.minRepairedAt = CompactionTask.getMinRepairedAt(nonExpiredSSTables);
        this.txn = txn;
        this.sstableWriter = SSTableRewriter.constructKeepingOriginals(txn, keepOriginals, this.maxAge, offline);
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.sstableWriter.abort(accumulate);
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.sstableWriter.commit(accumulate);
    }

    @Override
    protected void doPrepare() {
        this.sstableWriter.prepareToCommit();
    }

    @Override
    public Collection<SSTableReader> finish() {
        super.finish();
        return this.sstableWriter.finished();
    }

    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }

    public final boolean append(UnfilteredRowIterator partition) {
        this.maybeSwitchWriter(partition.partitionKey());
        return this.realAppend(partition);
    }

    @Override
    protected Throwable doPostCleanup(Throwable accumulate) {
        this.sstableWriter.close();
        return super.doPostCleanup(accumulate);
    }

    protected abstract boolean realAppend(UnfilteredRowIterator var1);

    protected void maybeSwitchWriter(DecoratedKey key) {
        if (!this.isInitialized) {
            this.switchCompactionLocation(this.getDirectories().getWriteableLocation(this.cfs.getExpectedCompactedFileSize(this.nonExpiredSSTables, this.txn.opType())));
        }
        this.isInitialized = true;
    }

    protected abstract void switchCompactionLocation(Directories.DataDirectory var1);

    public Directories getDirectories() {
        return this.directories;
    }

    public Directories.DataDirectory getWriteDirectory(long expectedWriteSize) {
        Directories.DataDirectory directory = this.getDirectories().getWriteableLocation(expectedWriteSize);
        if (directory == null) {
            throw new RuntimeException("Insufficient disk space to write " + expectedWriteSize + " bytes");
        }
        return directory;
    }
}

