/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.btree.BTreeSet;

public class MultiCBuilder {
    private final ClusteringComparator comparator;
    private final List<List<ByteBuffer>> elementsList = new ArrayList<List<ByteBuffer>>();
    private int size;
    private boolean built;
    private boolean containsNull;
    private boolean containsUnset;
    private boolean hasMissingElements;

    private MultiCBuilder(ClusteringComparator comparator) {
        this.comparator = comparator;
    }

    public static MultiCBuilder create(ClusteringComparator comparator) {
        return new MultiCBuilder(comparator);
    }

    private boolean isEmpty() {
        return this.elementsList.isEmpty();
    }

    public MultiCBuilder addElementToAll(ByteBuffer value) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            if (value == null) {
                this.containsNull = true;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                this.containsUnset = true;
            }
            this.elementsList.get(i).add(value);
        }
        ++this.size;
        return this;
    }

    public MultiCBuilder addEachElementToAll(List<ByteBuffer> values) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        if (values.isEmpty()) {
            this.hasMissingElements = true;
        } else {
            int m = this.elementsList.size();
            for (int i = 0; i < m; ++i) {
                List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                int n = values.size();
                for (int j = 0; j < n; ++j) {
                    ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                    this.elementsList.add(newComposite);
                    ByteBuffer value = values.get(j);
                    if (value == null) {
                        this.containsNull = true;
                    }
                    if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                        this.containsUnset = true;
                    }
                    newComposite.add(values.get(j));
                }
            }
        }
        ++this.size;
        return this;
    }

    public MultiCBuilder addAllElementsToAll(List<List<ByteBuffer>> values) {
        this.checkUpdateable();
        if (this.isEmpty()) {
            this.elementsList.add(new ArrayList());
        }
        if (values.isEmpty()) {
            this.hasMissingElements = true;
        } else {
            int m = this.elementsList.size();
            for (int i = 0; i < m; ++i) {
                List<ByteBuffer> oldComposite = this.elementsList.remove(0);
                int n = values.size();
                for (int j = 0; j < n; ++j) {
                    ArrayList<ByteBuffer> newComposite = new ArrayList<ByteBuffer>(oldComposite);
                    this.elementsList.add(newComposite);
                    List<ByteBuffer> value = values.get(j);
                    if (value.isEmpty()) {
                        this.hasMissingElements = true;
                    }
                    if (value.contains(null)) {
                        this.containsNull = true;
                    }
                    if (value.contains(ByteBufferUtil.UNSET_BYTE_BUFFER)) {
                        this.containsUnset = true;
                    }
                    newComposite.addAll(value);
                }
            }
            this.size += values.get(0).size();
        }
        return this;
    }

    public int remainingCount() {
        return this.comparator.size() - this.size;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean containsUnset() {
        return this.containsUnset;
    }

    public boolean hasMissingElements() {
        return this.hasMissingElements;
    }

    public NavigableSet<Clustering> build() {
        this.built = true;
        if (this.hasMissingElements) {
            return BTreeSet.empty(this.comparator);
        }
        CBuilder builder = CBuilder.create(this.comparator);
        if (this.elementsList.isEmpty()) {
            return BTreeSet.of(builder.comparator(), builder.build());
        }
        BTreeSet.Builder<Clusterable> set = BTreeSet.builder(builder.comparator());
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            List<ByteBuffer> elements = this.elementsList.get(i);
            set.add(builder.buildWith(elements));
        }
        return set.build();
    }

    public NavigableSet<Slice.Bound> buildBound(boolean isStart, boolean isInclusive) {
        this.built = true;
        if (this.hasMissingElements) {
            return BTreeSet.empty(this.comparator);
        }
        CBuilder builder = CBuilder.create(this.comparator);
        if (this.elementsList.isEmpty()) {
            return BTreeSet.of(this.comparator, builder.buildBound(isStart, isInclusive));
        }
        BTreeSet.Builder<Clusterable> set = BTreeSet.builder(this.comparator);
        int m = this.elementsList.size();
        for (int i = 0; i < m; ++i) {
            List<ByteBuffer> elements = this.elementsList.get(i);
            set.add(builder.buildBoundWith(elements, isStart, isInclusive));
        }
        return set.build();
    }

    public boolean hasRemaining() {
        return this.remainingCount() > 0;
    }

    private void checkUpdateable() {
        if (!this.hasRemaining() || this.built) {
            throw new IllegalStateException("this builder cannot be updated anymore");
        }
    }
}

