/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql.CQLStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;

public class ThriftClientState
extends ClientState {
    private static final int MAX_CACHE_PREPARED = 10000;
    private final QueryState queryState;
    private final Map<Integer, CQLStatement> prepared = new LinkedHashMap<Integer, CQLStatement>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, CQLStatement> eldest) {
            return this.size() > 10000;
        }
    };

    public ThriftClientState(SocketAddress remoteAddress) {
        super(remoteAddress);
        this.queryState = new QueryState(this);
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public Map<Integer, CQLStatement> getPrepared() {
        return this.prepared;
    }

    public String getSchedulingValue() {
        switch (DatabaseDescriptor.getRequestSchedulerId()) {
            case keyspace: {
                return this.getRawKeyspace();
            }
        }
        return "default";
    }
}

