/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.mqtt;

import java.nio.charset.StandardCharsets;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0001\u0002\u0001\t1\u0011\u0001#T)U)B\u000b\u0017N\u001d*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011\u0001B7riRT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001c\u0001\b\u0012'5\tqB\u0003\u0002\u0011\t\u0005A!/Z2fSZ,'/\u0003\u0002\u0013\u001f\tA!+Z2fSZ,'\u000f\u0005\u0003\u0015/eIR\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\rQ+\b\u000f\\33!\tQRD\u0004\u0002\u00157%\u0011A$F\u0001\u0007!J,G-\u001a4\n\u0005yy\"AB*ue&twM\u0003\u0002\u001d+!A\u0011\u0005\u0001B\u0001B\u0003%\u0011$A\u0005ce>\\WM]+sY\u000e\u0001\u0001\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\rQ|\u0007/[2t!\r!b%G\u0005\u0003OU\u0011Q!\u0011:sCfD\u0011\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0019\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0005-rS\"\u0001\u0017\u000b\u000552\u0011aB:u_J\fw-Z\u0005\u0003_1\u0012Ab\u0015;pe\u0006<W\rT3wK2L!!K\t\t\u0011I\u0002!\u0011!Q\u0001\nM\n\u0001b\u00197jK:$\u0018\n\u001a\t\u0004)QJ\u0012BA\u001b\u0016\u0005\u0019y\u0005\u000f^5p]\"Aq\u0007\u0001B\u0001B\u0003%1'\u0001\u0005vg\u0016\u0014h.Y7f\u0011!I\u0004A!A!\u0002\u0013\u0019\u0014\u0001\u00039bgN<xN\u001d3\t\u0011m\u0002!\u0011!Q\u0001\nq\nAb\u00197fC:\u001cVm]:j_:\u00042\u0001\u0006\u001b>!\t!b(\u0003\u0002@+\t9!i\\8mK\u0006t\u0007\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u0007E|7\u000fE\u0002\u0015i\r\u0003\"\u0001\u0006#\n\u0005\u0015+\"aA%oi\"Aq\t\u0001B\u0001B\u0003%!)A\td_:tWm\u0019;j_:$\u0016.\\3pkRD\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0012W\u0016,\u0007/\u00117jm\u0016Le\u000e^3sm\u0006d\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u00175\fH\u000f\u001e,feNLwN\u001c\u0005\u0006\u001b\u0002!\tAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019=\u000b&k\u0015+V-^C\u0016LW.\u0011\u0005A\u0003Q\"\u0001\u0002\t\u000b\u0005b\u0005\u0019A\r\t\u000b\u0011b\u0005\u0019A\u0013\t\u000b%b\u0005\u0019\u0001\u0016\t\u000bIb\u0005\u0019A\u001a\t\u000b]b\u0005\u0019A\u001a\t\u000beb\u0005\u0019A\u001a\t\u000bmb\u0005\u0019\u0001\u001f\t\u000b\u0005c\u0005\u0019\u0001\"\t\u000b\u001dc\u0005\u0019\u0001\"\t\u000b%c\u0005\u0019\u0001\"\t\u000b-c\u0005\u0019\u0001\"\t\u000bu\u0003A\u0011\u00010\u0002\r=t7\u000b^8q)\u0005y\u0006C\u0001\u000ba\u0013\t\tWC\u0001\u0003V]&$\b\"B2\u0001\t\u0003q\u0016aB8o'R\f'\u000f\u001e")
public class MQTTPairReceiver
extends Receiver<Tuple2<String, String>> {
    private final String brokerUrl;
    private final String[] topics;
    private final Option<String> clientId;
    private final Option<String> username;
    private final Option<String> password;
    private final Option<Object> cleanSession;
    public final Option<Object> org$apache$spark$streaming$mqtt$MQTTPairReceiver$$qos;
    private final Option<Object> connectionTimeout;
    private final Option<Object> keepAliveInterval;
    private final Option<Object> mqttVersion;

    public void onStop() {
    }

    public void onStart() {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(this.brokerUrl, (String)this.clientId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return MqttClient.generateClientId();
            }
        }), (MqttClientPersistence)persistence);
        MqttConnectOptions mqttConnectionOptions = new MqttConnectOptions();
        if (this.username.isDefined() && this.password.isDefined()) {
            mqttConnectionOptions.setUserName((String)this.username.get());
            mqttConnectionOptions.setPassword(((String)this.password.get()).toCharArray());
        }
        mqttConnectionOptions.setCleanSession(BoxesRunTime.unboxToBoolean((Object)this.cleanSession.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        if (this.connectionTimeout.isDefined()) {
            mqttConnectionOptions.setConnectionTimeout(BoxesRunTime.unboxToInt((Object)this.connectionTimeout.get()));
        }
        if (this.keepAliveInterval.isDefined()) {
            mqttConnectionOptions.setKeepAliveInterval(BoxesRunTime.unboxToInt((Object)this.keepAliveInterval.get()));
        }
        if (this.mqttVersion.isDefined()) {
            mqttConnectionOptions.setMqttVersion(BoxesRunTime.unboxToInt((Object)this.mqttVersion.get()));
        }
        MqttCallback callback = new MqttCallback(this){
            private final /* synthetic */ MQTTPairReceiver $outer;

            public void messageArrived(String topic, MqttMessage message) {
                this.$outer.store(new Tuple2((Object)topic, (Object)new String(message.getPayload(), StandardCharsets.UTF_8)));
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
                this.$outer.restart("Connection lost ", cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        client.setCallback(callback);
        client.connect(mqttConnectionOptions);
        boolean i = false;
        int[] qosArray = (int[])Array$.MODULE$.ofDim(this.topics.length, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), qosArray.length - 1).foreach$mVc$sp((Function1)new Serializable(this, qosArray){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MQTTPairReceiver $outer;
            private final int[] qosArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.qosArray$1[i] = BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$streaming$mqtt$MQTTPairReceiver$$qos.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.qosArray$1 = qosArray$1;
            }
        });
        client.subscribe(this.topics, qosArray);
    }

    public MQTTPairReceiver(String brokerUrl, String[] topics, StorageLevel storageLevel, Option<String> clientId, Option<String> username, Option<String> password, Option<Object> cleanSession, Option<Object> qos, Option<Object> connectionTimeout, Option<Object> keepAliveInterval, Option<Object> mqttVersion) {
        this.brokerUrl = brokerUrl;
        this.topics = topics;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.org$apache$spark$streaming$mqtt$MQTTPairReceiver$$qos = qos;
        this.connectionTimeout = connectionTimeout;
        this.keepAliveInterval = keepAliveInterval;
        this.mqttVersion = mqttVersion;
        super(storageLevel);
    }
}

