/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasRelationshipType {
    private AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
    private static final String EMPLOYEE_TYPE = "employee";
    private static final String DEPARTMENT_TYPE = "department";
    private static final String ADDRESS_TYPE = "address";
    private static final String PHONE_TYPE = "phone";
    private static final String DEPT_EMPLOYEE_RELATION_TYPE = "departmentEmployee";
    private static final String EMPLOYEE_ADDRESS_RELATION_TYPE = "employeeAddress";
    private static final String EMPLOYEE_PHONE_RELATION_TYPE = "employeePhone";

    @Test
    public void createTypesAndRelationships() throws AtlasBaseException {
        this.createEmployeeTypes();
        this.createRelationshipTypes();
    }

    @Test
    public void testvalidateAtlasRelationshipDef() throws AtlasBaseException {
        block17: {
            AtlasRelationshipDef relationshipDef;
            AtlasRelationshipEndDef ep_LIST;
            AtlasRelationshipEndDef ep_single;
            block16: {
                block15: {
                    AtlasRelationshipEndDef ep_SET_container;
                    AtlasRelationshipEndDef ep_SET;
                    block14: {
                        AtlasRelationshipEndDef ep_single_container;
                        block13: {
                            block12: {
                                ep_single = new AtlasRelationshipEndDef("typeA", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
                                ep_single_container = new AtlasRelationshipEndDef("typeB", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
                                AtlasRelationshipEndDef ep_single_container_2 = new AtlasRelationshipEndDef("typeC", "attr3", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, true);
                                AtlasRelationshipEndDef ep_single_container_3 = new AtlasRelationshipEndDef("typeD", "attr4", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, true);
                                ep_SET = new AtlasRelationshipEndDef("typeD", "attr4", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, false);
                                ep_LIST = new AtlasRelationshipEndDef("typeE", "attr5", AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, true);
                                ep_SET_container = new AtlasRelationshipEndDef("typeF", "attr6", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true);
                                AtlasRelationshipDef relationshipDef1 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_single, ep_SET);
                                AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef1);
                                AtlasRelationshipDef relationshipDef2 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.COMPOSITION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_SET_container, ep_single);
                                AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef2);
                                AtlasRelationshipDef relationshipDef3 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_SET_container, ep_single);
                                AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef3);
                                try {
                                    relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_single_container_2, ep_single_container);
                                    AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                                    Assert.fail((String)"This call is expected to fail");
                                }
                                catch (AtlasBaseException abe) {
                                    if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_ASSOCIATION_AND_CONTAINER)) break block12;
                                    Assert.fail((String)"This call expected a different error");
                                }
                            }
                            try {
                                relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.COMPOSITION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_single, ep_single_container);
                                AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                                Assert.fail((String)"This call is expected to fail");
                            }
                            catch (AtlasBaseException abe) {
                                if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_COMPOSITION_NO_CONTAINER)) break block13;
                                Assert.fail((String)"This call expected a different error");
                            }
                        }
                        try {
                            relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_single, ep_single_container);
                            AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                            Assert.fail((String)"This call is expected to fail");
                        }
                        catch (AtlasBaseException abe) {
                            if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_AGGREGATION_NO_CONTAINER)) break block14;
                            Assert.fail((String)"This call expected a different error");
                        }
                    }
                    try {
                        relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.COMPOSITION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_SET_container, ep_SET);
                        AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                        Assert.fail((String)"This call is expected to fail");
                    }
                    catch (AtlasBaseException abe) {
                        if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_COMPOSITION_MULTIPLE_PARENTS)) break block15;
                        Assert.fail((String)"This call expected a different error");
                    }
                }
                try {
                    relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.COMPOSITION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_single, ep_LIST);
                    AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                    Assert.fail((String)"This call is expected to fail");
                }
                catch (AtlasBaseException abe) {
                    if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_LIST_ON_END)) break block16;
                    Assert.fail((String)"This call expected a different error");
                }
            }
            try {
                relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.COMPOSITION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep_LIST, ep_single);
                AtlasRelationshipType.validateAtlasRelationshipDef((AtlasRelationshipDef)relationshipDef);
                Assert.fail((String)"This call is expected to fail");
            }
            catch (AtlasBaseException abe) {
                if (abe.getAtlasErrorCode().equals((Object)AtlasErrorCode.RELATIONSHIPDEF_LIST_ON_END)) break block17;
                Assert.fail((String)"This call expected a different error");
            }
        }
    }

    @Test(dependsOnMethods={"createTypesAndRelationships"})
    public void testRelationshipAttributes() throws Exception {
        Map<String, Map<String, AtlasStructType.AtlasAttribute>> employeeRelationAttrs = this.getRelationAttrsForType(EMPLOYEE_TYPE);
        Assert.assertNotNull(employeeRelationAttrs);
        Assert.assertEquals((int)employeeRelationAttrs.size(), (int)2);
        Assert.assertTrue((boolean)employeeRelationAttrs.containsKey(DEPARTMENT_TYPE));
        Assert.assertTrue((boolean)employeeRelationAttrs.containsKey(ADDRESS_TYPE));
        AtlasStructType.AtlasAttribute deptAttr = employeeRelationAttrs.get(DEPARTMENT_TYPE).values().iterator().next();
        Assert.assertEquals((String)deptAttr.getTypeName(), (String)DEPARTMENT_TYPE);
        AtlasStructType.AtlasAttribute addrAttr = employeeRelationAttrs.get(ADDRESS_TYPE).values().iterator().next();
        Assert.assertEquals((String)addrAttr.getTypeName(), (String)ADDRESS_TYPE);
        Map<String, Map<String, AtlasStructType.AtlasAttribute>> deptRelationAttrs = this.getRelationAttrsForType(DEPARTMENT_TYPE);
        Assert.assertNotNull(deptRelationAttrs);
        Assert.assertEquals((int)deptRelationAttrs.size(), (int)1);
        Assert.assertTrue((boolean)deptRelationAttrs.containsKey("employees"));
        AtlasStructType.AtlasAttribute employeesAttr = deptRelationAttrs.get("employees").values().iterator().next();
        Assert.assertEquals((String)employeesAttr.getTypeName(), (String)AtlasBaseTypeDef.getArrayTypeName((String)EMPLOYEE_TYPE));
        Map<String, Map<String, AtlasStructType.AtlasAttribute>> addressRelationAttrs = this.getRelationAttrsForType(ADDRESS_TYPE);
        Assert.assertNotNull(addressRelationAttrs);
        Assert.assertEquals((int)addressRelationAttrs.size(), (int)1);
        Assert.assertTrue((boolean)addressRelationAttrs.containsKey("employees"));
        AtlasStructType.AtlasAttribute employeesAttr1 = addressRelationAttrs.get("employees").values().iterator().next();
        Assert.assertEquals((String)employeesAttr1.getTypeName(), (String)AtlasBaseTypeDef.getArrayTypeName((String)EMPLOYEE_TYPE));
    }

    @Test(dependsOnMethods={"testRelationshipAttributes"})
    public void testRelationshipAttributesOnExistingAttributes() throws Exception {
        AtlasRelationshipDef employeePhoneRelationDef = new AtlasRelationshipDef(EMPLOYEE_PHONE_RELATION_TYPE, this.getDescription(EMPLOYEE_PHONE_RELATION_TYPE), "1.0", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "phone_no", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(PHONE_TYPE, "owner", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE));
        this.createType((AtlasBaseTypeDef)employeePhoneRelationDef);
        Map<String, Map<String, AtlasStructType.AtlasAttribute>> employeeRelationshipAttrs = this.getRelationAttrsForType(EMPLOYEE_TYPE);
        Map<String, AtlasStructType.AtlasAttribute> employeeAttrs = this.getAttrsForType(EMPLOYEE_TYPE);
        Assert.assertTrue((boolean)employeeRelationshipAttrs.containsKey("phone_no"));
        Assert.assertTrue((boolean)employeeAttrs.containsKey("phone_no"));
    }

    private void createEmployeeTypes() throws AtlasBaseException {
        AtlasEntityDef phoneDef = AtlasTypeUtil.createClassTypeDef((String)PHONE_TYPE, (String)this.getDescription(PHONE_TYPE), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"phone_number", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"area_code", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"owner", (String)EMPLOYEE_TYPE)});
        AtlasEntityDef employeeDef = AtlasTypeUtil.createClassTypeDef((String)EMPLOYEE_TYPE, (String)this.getDescription(EMPLOYEE_TYPE), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"name", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"dob", (String)"date"), AtlasTypeUtil.createOptionalAttrDef((String)"age", (String)"int"), AtlasTypeUtil.createRequiredAttrDef((String)"phone_no", (String)PHONE_TYPE)});
        AtlasEntityDef departmentDef = AtlasTypeUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)this.getDescription(DEPARTMENT_TYPE), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"name", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"count", (String)"int")});
        AtlasEntityDef addressDef = AtlasTypeUtil.createClassTypeDef((String)ADDRESS_TYPE, (String)this.getDescription(ADDRESS_TYPE), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"street", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"city", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"state", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"zip", (String)"int")});
        this.createTypes(new ArrayList<AtlasEntityDef>(Arrays.asList(phoneDef, employeeDef, departmentDef, addressDef)));
    }

    private void createRelationshipTypes() throws AtlasBaseException {
        AtlasRelationshipDef deptEmployeeRelationDef = new AtlasRelationshipDef(DEPT_EMPLOYEE_RELATION_TYPE, this.getDescription(DEPT_EMPLOYEE_RELATION_TYPE), "1.0", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, DEPARTMENT_TYPE, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(DEPARTMENT_TYPE, "employees", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        AtlasRelationshipDef employeeAddrRelationDef = new AtlasRelationshipDef(EMPLOYEE_ADDRESS_RELATION_TYPE, this.getDescription(EMPLOYEE_ADDRESS_RELATION_TYPE), "1.0", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, ADDRESS_TYPE, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(ADDRESS_TYPE, "employees", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        this.createTypes(new ArrayList<AtlasRelationshipDef>(Arrays.asList(deptEmployeeRelationDef, employeeAddrRelationDef)));
    }

    private void createType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
        this.createTypes(new ArrayList<AtlasBaseTypeDef>(Arrays.asList(typeDef)));
    }

    private void createTypes(List<? extends AtlasBaseTypeDef> typeDefs) throws AtlasBaseException {
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = this.typeRegistry.lockTypeRegistryForUpdate();
        ttr.addTypes(typeDefs);
        this.typeRegistry.releaseTypeRegistryForUpdate(ttr, true);
    }

    private String getDescription(String typeName) {
        return typeName + " description";
    }

    private Map<String, Map<String, AtlasStructType.AtlasAttribute>> getRelationAttrsForType(String typeName) {
        return this.typeRegistry.getEntityTypeByName(typeName).getRelationshipAttributes();
    }

    private Map<String, AtlasStructType.AtlasAttribute> getAttrsForType(String typeName) {
        return this.typeRegistry.getEntityTypeByName(typeName).getAllAttributes();
    }
}

