/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasObjectIdType {
    private final AtlasBuiltInTypes.AtlasObjectIdType objectIdType = new AtlasBuiltInTypes.AtlasObjectIdType();
    private final Object[] validValues;
    private final Object[] invalidValues;

    public TestAtlasObjectIdType() {
        HashMap<String, String> validObj1 = new HashMap<String, String>();
        HashMap<String, Object> validObj2 = new HashMap<String, Object>();
        HashMap<String, Object> validObj3 = new HashMap<String, Object>();
        HashMap<String, String> invalidObj1 = new HashMap<String, String>();
        HashMap<String, String> invalidObj2 = new HashMap<String, String>();
        HashMap<String, Object> invalidObj3 = new HashMap<String, Object>();
        HashMap<String, Object> invalidObj4 = new HashMap<String, Object>();
        HashMap<String, String> uniqAttribs = new HashMap<String, String>();
        uniqAttribs.put("name", "testTypeInstance-1");
        validObj1.put("guid", "guid-1234");
        validObj2.put("typeName", "testType");
        validObj2.put("uniqueAttributes", uniqAttribs);
        validObj3.put("guid", "guid-1234");
        validObj3.put("typeName", "testType");
        validObj3.put("uniqueAttributes", uniqAttribs);
        invalidObj1.put("guid-invalid", "guid-1234");
        invalidObj2.put("typeName", "testType");
        invalidObj3.put("typeName", "testType");
        invalidObj3.put("uniqueAttributes", new HashMap());
        invalidObj4.put("typeName", "testType");
        invalidObj4.put("uniqueAttributes", new ArrayList());
        this.validValues = new Object[]{null, validObj1, validObj2, validObj3, new AtlasObjectId(), new AtlasObjectId("guid-1234", "testType")};
        this.invalidValues = new Object[]{invalidObj1, invalidObj2, invalidObj3, invalidObj4, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1", "", "12ab", "abcd", "-12ab"};
    }

    @Test
    public void testObjectIdTypeDefaultValue() {
        AtlasObjectId defValue = this.objectIdType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
    }

    @Test
    public void testObjectIdTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.objectIdType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.objectIdType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testObjectIdTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.objectIdType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            AtlasObjectId normalizedValue = this.objectIdType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof AtlasObjectId) {
                Assert.assertEquals((Object)normalizedValue, (Object)value, (String)("value=" + value));
                continue;
            }
            if (!(value instanceof Map)) continue;
            Assert.assertEquals((Object)normalizedValue.getTypeName(), ((Map)value).get("typeName"), (String)("value=" + value));
            if (((Map)value).get("guid") == null) {
                Assert.assertEquals((Object)normalizedValue.getGuid(), ((Map)value).get("guid"), (String)("value=" + value));
            } else {
                Assert.assertEquals((Object)normalizedValue.getGuid(), ((Map)value).get("guid"), (String)("value=" + value));
            }
            Assert.assertEquals((Object)normalizedValue.getUniqueAttributes(), ((Map)value).get("uniqueAttributes"), (String)("value=" + value));
        }
    }

    @Test
    public void testObjectIdTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.objectIdType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.objectIdType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

