/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasByteType {
    private final AtlasBuiltInTypes.AtlasByteType byteType = new AtlasBuiltInTypes.AtlasByteType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1"};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1L), "-1"};
    private final Object[] invalidValues = new Object[]{""};

    @Test
    public void testByteTypeDefaultValue() {
        Byte defValue = this.byteType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)0);
    }

    @Test
    public void testByteTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.byteType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.byteType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.byteType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testByteTypeGetNormalizedValue() {
        Byte normalizedValue;
        Assert.assertNull((Object)this.byteType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            normalizedValue = this.byteType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)1, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            normalizedValue = this.byteType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)-1, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.byteType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testByteTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.byteType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.byteType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.byteType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

