/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.security;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.atlas.security.InMemoryJAASConfiguration;
import org.apache.hadoop.util.StringUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(enabled=false)
public class InMemoryJAASConfigurationTest {
    private static final String ATLAS_JAAS_PROP_FILE = "atlas-jaas.properties";

    @BeforeClass
    protected void setUp() throws Exception {
        InMemoryJAASConfiguration.init((String)ATLAS_JAAS_PROP_FILE);
    }

    @Test(enabled=false)
    public void testGetAppConfigurationEntryStringForKafkaClient() {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry("KafkaClient");
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((int)1, (int)entries.length);
        String principal = (String)entries[0].getOptions().get("principal");
        Assert.assertNotNull((Object)principal);
        String[] components = principal.split("[/@]");
        Assert.assertEquals((int)3, (int)components.length);
        Assert.assertEquals((boolean)false, (boolean)StringUtils.equalsIgnoreCase((String)components[1], (String)"_HOST"));
    }

    @Test(enabled=false)
    public void testGetAppConfigurationEntryStringForMyClient() {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry("myClient");
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((int)2, (int)entries.length);
        String principal = (String)entries[0].getOptions().get("principal");
        Assert.assertNotNull((Object)principal);
        String[] components = principal.split("[/@]");
        Assert.assertEquals((int)3, (int)components.length);
        Assert.assertEquals((boolean)true, (boolean)StringUtils.equalsIgnoreCase((String)components[1], (String)"abcd"));
        principal = (String)entries[1].getOptions().get("principal");
        Assert.assertNotNull((Object)principal);
        components = principal.split("[/@]");
        Assert.assertEquals((int)2, (int)components.length);
    }

    @Test(enabled=false)
    public void testGetAppConfigurationEntryStringForUnknownClient() {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry("UnknownClient");
        Assert.assertNull((Object)entries);
    }
}

